/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyAdapter<B>
extends AbstractValueModel {
    public static final String PROPERTYNAME_BEFORE_BEAN = "beforeBean";
    public static final String PROPERTYNAME_BEAN = "bean";
    public static final String PROPERTYNAME_AFTER_BEAN = "afterBean";
    public static final String PROPERTYNAME_CHANGED = "changed";
    private final ValueModel beanChannel;
    private final String propertyName;
    private final String getterName;
    private final String setterName;
    private final boolean observeChanges;
    private B storedOldBean;
    private boolean changed = false;
    private PropertyChangeListener propertyChangeHandler;
    private PropertyDescriptor cachedPropertyDescriptor;
    private Class<?> cachedBeanClass;

    public PropertyAdapter(B b, String string) {
        this(b, string, false);
    }

    public PropertyAdapter(B b, String string, boolean bl) {
        this(b, string, null, null, bl);
    }

    public PropertyAdapter(B b, String string, String string2, String string3) {
        this(b, string, string2, string3, false);
    }

    public PropertyAdapter(B b, String string, String string2, String string3, boolean bl) {
        this(new ValueHolder(b, true), string, string2, string3, bl);
    }

    public PropertyAdapter(ValueModel valueModel, String string) {
        this(valueModel, string, false);
    }

    public PropertyAdapter(ValueModel valueModel, String string, boolean bl) {
        this(valueModel, string, (String)null, (String)null, bl);
    }

    public PropertyAdapter(ValueModel valueModel, String string, String string2, String string3) {
        this(valueModel, string, string2, string3, false);
    }

    public PropertyAdapter(ValueModel valueModel, String string, String string2, String string3, boolean bl) {
        this.beanChannel = valueModel != null ? valueModel : new ValueHolder(null, true);
        this.propertyName = string;
        this.getterName = string2;
        this.setterName = string3;
        this.observeChanges = bl;
        if (string == null) {
            throw new NullPointerException("The property name must not be null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("The property name must not be empty.");
        }
        this.checkBeanChannelIdentityCheck(valueModel);
        this.beanChannel.addValueChangeListener(new BeanChangeHandler());
        B b = this.getBean();
        if (b != null) {
            this.getPropertyDescriptor(b);
            this.addChangeHandlerTo(b);
        }
        this.storedOldBean = b;
    }

    public B getBean() {
        return (B)this.beanChannel.getValue();
    }

    public void setBean(B b) {
        this.beanChannel.setValue(b);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean getObserveChanges() {
        return this.observeChanges;
    }

    @Override
    public Object getValue() {
        B b = this.getBean();
        if (b == null) {
            return null;
        }
        return this.getValue0(b);
    }

    @Override
    public void setValue(Object object) {
        B b = this.getBean();
        if (b == null) {
            return;
        }
        try {
            this.setValue0(b, object);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setVetoableValue(Object object) throws PropertyVetoException {
        B b = this.getBean();
        if (b == null) {
            return;
        }
        this.setValue0(this.getBean(), object);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void resetChanged() {
        this.setChanged(false);
    }

    private void setChanged(boolean bl) {
        boolean bl2 = this.isChanged();
        this.changed = bl;
        this.firePropertyChange(PROPERTYNAME_CHANGED, bl2, bl);
    }

    public void release() {
        this.removeChangeHandlerFrom(this.getBean());
    }

    @Override
    protected String paramString() {
        B b = this.getBean();
        String string = null;
        Object object = this.getValue();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Method method = null;
        if (b != null) {
            string = b.getClass().getName();
            string2 = object == null ? null : object.getClass().getName();
            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(b);
            string3 = propertyDescriptor.getName();
            string4 = propertyDescriptor.getPropertyType().getName();
            method = propertyDescriptor.getWriteMethod();
        }
        return "bean=" + b + "; bean type=" + string + "; value=" + object + "; value type=" + string2 + "; property name=" + string3 + "; property type=" + string4 + "; property setter=" + method;
    }

    private void setBean0(B b, B b2) {
        this.firePropertyChange(PROPERTYNAME_BEFORE_BEAN, b, b2, true);
        this.removeChangeHandlerFrom(b);
        this.forwardAdaptedValueChanged(b, b2);
        this.resetChanged();
        this.addChangeHandlerTo(b2);
        this.firePropertyChange(PROPERTYNAME_BEAN, b, b2, true);
        this.firePropertyChange(PROPERTYNAME_AFTER_BEAN, b, b2, true);
    }

    private void forwardAdaptedValueChanged(B b, B b2) {
        Object object;
        Object object2 = b == null || this.isWriteOnlyProperty(b) ? null : this.getValue0(b);
        Object object3 = object = b2 == null || this.isWriteOnlyProperty(b2) ? null : this.getValue0(b2);
        if (object2 != null || object != null) {
            this.fireValueChange(object2, object, true);
        }
    }

    private void forwardAdaptedValueChanged(B b) {
        Object object = b == null || this.isWriteOnlyProperty(b) ? null : this.getValue0(b);
        this.fireValueChange(null, object);
    }

    private void addChangeHandlerTo(B b) {
        if (!this.observeChanges || b == null) {
            return;
        }
        this.propertyChangeHandler = new PropertyChangeHandler();
        BeanUtils.addPropertyChangeListener(b, this.getBeanClass(b), this.propertyChangeHandler);
    }

    private void removeChangeHandlerFrom(B b) {
        if (!this.observeChanges || b == null || this.propertyChangeHandler == null) {
            return;
        }
        BeanUtils.removePropertyChangeListener(b, this.getBeanClass(b), this.propertyChangeHandler);
        this.propertyChangeHandler = null;
    }

    private Class<?> getBeanClass(B b) {
        return b.getClass();
    }

    private Object getValue0(B b) {
        return b == null ? null : BeanUtils.getValue(b, this.getPropertyDescriptor(b));
    }

    private void setValue0(B b, Object object) throws PropertyVetoException {
        BeanUtils.setValue(b, this.getPropertyDescriptor(b), object);
    }

    private PropertyDescriptor getPropertyDescriptor(B b) {
        Class<?> clazz = this.getBeanClass(b);
        if (this.cachedPropertyDescriptor == null || clazz != this.cachedBeanClass) {
            this.cachedPropertyDescriptor = BeanUtils.getPropertyDescriptor(clazz, this.getPropertyName(), this.getterName, this.setterName);
            this.cachedBeanClass = clazz;
        }
        return this.cachedPropertyDescriptor;
    }

    private boolean isWriteOnlyProperty(B b) {
        return null == this.getPropertyDescriptor(b).getReadMethod();
    }

    private void checkBeanChannelIdentityCheck(ValueModel valueModel) {
        if (!(valueModel instanceof ValueHolder)) {
            return;
        }
        ValueHolder valueHolder = (ValueHolder)valueModel;
        if (!valueHolder.isIdentityCheckEnabled()) {
            throw new IllegalArgumentException("The bean channel must have the identity check enabled.");
        }
    }

    private final class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PropertyAdapter.this.setChanged(true);
            if (propertyChangeEvent.getPropertyName() == null) {
                PropertyAdapter.this.forwardAdaptedValueChanged(PropertyAdapter.this.getBean());
            } else if (propertyChangeEvent.getPropertyName().equals(PropertyAdapter.this.getPropertyName())) {
                PropertyAdapter.this.fireValueChange(propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue(), true);
            }
        }
    }

    private final class BeanChangeHandler
    implements PropertyChangeListener {
        private BeanChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getNewValue() != null ? propertyChangeEvent.getNewValue() : PropertyAdapter.this.getBean();
            PropertyAdapter.this.setBean0(PropertyAdapter.this.storedOldBean, object);
            PropertyAdapter.this.storedOldBean = object;
        }
    }
}

