/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public final class BoundedRangeAdapter
implements BoundedRangeModel,
Serializable {
    private transient ChangeEvent changeEvent = null;
    private final EventListenerList listenerList = new EventListenerList();
    private final ValueModel subject;
    private int theExtent = 0;
    private int min = 0;
    private int max = 100;
    private boolean isAdjusting = false;

    public BoundedRangeAdapter(ValueModel valueModel, int n, int n2, int n3) {
        this.subject = valueModel;
        Object object = valueModel.getValue();
        int n4 = object == null ? n2 : (Integer)object;
        this.initialize(n4, n, n2, n3);
        valueModel.addValueChangeListener(new SubjectValueChangeHandler());
    }

    public int getExtent() {
        return this.theExtent;
    }

    public int getMaximum() {
        return this.max;
    }

    public int getMinimum() {
        return this.min;
    }

    public int getValue() {
        Object object = this.subject.getValue();
        return object == null ? this.getMinimum() : ((Integer)object).intValue();
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    public void setExtent(int n) {
        int n2 = Math.max(0, n);
        int n3 = this.getValue();
        if (n3 + n2 > this.max) {
            n2 = this.max - n3;
        }
        this.setRangeProperties(n3, n2, this.min, this.max, this.isAdjusting);
    }

    public void setMaximum(int n) {
        int n2 = Math.min(n, this.min);
        int n3 = Math.min(n, this.getValue());
        int n4 = Math.min(n - n3, this.theExtent);
        this.setRangeProperties(n3, n4, n2, n, this.isAdjusting);
    }

    public void setMinimum(int n) {
        int n2 = Math.max(n, this.max);
        int n3 = Math.max(n, this.getValue());
        int n4 = Math.min(n2 - n3, this.theExtent);
        this.setRangeProperties(n3, n4, n, n2, this.isAdjusting);
    }

    public void setRangeProperties(int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        if (n3 > n4) {
            n3 = n4;
        }
        if (n > n4) {
            n4 = n;
        }
        if (n < n3) {
            n3 = n;
        }
        if ((long)n2 + (long)n > (long)n4) {
            n2 = n4 - n;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        boolean bl3 = bl2 = n != this.getValue() || n2 != this.theExtent || n3 != this.min || n4 != this.max || bl != this.isAdjusting;
        if (bl2) {
            this.setValue0(n);
            this.theExtent = n2;
            this.min = n3;
            this.max = n4;
            this.isAdjusting = bl;
            this.fireStateChanged();
        }
    }

    public void setValue(int n) {
        int n2 = Math.max(n, this.min);
        if (n2 + this.theExtent > this.max) {
            n2 = this.max - this.theExtent;
        }
        this.setRangeProperties(n2, this.theExtent, this.min, this.max, this.isAdjusting);
    }

    public void setValueIsAdjusting(boolean bl) {
        this.setRangeProperties(this.getValue(), this.theExtent, this.min, this.max, bl);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    private void initialize(int n, int n2, int n3, int n4) {
        if (n4 < n3 || n < n3 || n + n2 < n || n + n2 > n4) {
            throw new IllegalArgumentException("invalid range properties");
        }
        this.theExtent = n2;
        this.min = n3;
        this.max = n4;
    }

    private void setValue0(int n) {
        this.subject.setValue(n);
    }

    public String toString() {
        String string = "value=" + this.getValue() + ", " + "extent=" + this.getExtent() + ", " + "min=" + this.getMinimum() + ", " + "max=" + this.getMaximum() + ", " + "adj=" + this.getValueIsAdjusting();
        return this.getClass().getName() + "[" + string + "]";
    }

    private final class SubjectValueChangeHandler
    implements PropertyChangeListener {
        private SubjectValueChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BoundedRangeAdapter.this.fireStateChanged();
        }
    }
}

