/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JacksonAnnotationValue;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.MapProperty;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

@JacksonStdImpl
public class MapSerializer
extends ContainerSerializer<Map<?, ?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected static final JavaType UNSPECIFIED_TYPE = TypeFactory.unknownType();
    protected final BeanProperty _property;
    protected final Set<String> _ignoredEntries;
    protected final boolean _valueTypeIsStatic;
    protected final JavaType _keyType;
    protected final JavaType _valueType;
    protected JsonSerializer<Object> _keySerializer;
    protected JsonSerializer<Object> _valueSerializer;
    protected final TypeSerializer _valueTypeSerializer;
    protected PropertySerializerMap _dynamicValueSerializers;
    protected final Object _filterId;
    protected final boolean _sortKeys;
    protected final Object _suppressableValue;

    protected MapSerializer(Set<String> set, JavaType javaType, JavaType javaType2, boolean bl, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, JsonSerializer<?> jsonSerializer2) {
        super(Map.class, false);
        this._ignoredEntries = set == null || set.isEmpty() ? null : set;
        this._keyType = javaType;
        this._valueType = javaType2;
        this._valueTypeIsStatic = bl;
        this._valueTypeSerializer = typeSerializer;
        this._keySerializer = jsonSerializer;
        this._valueSerializer = jsonSerializer2;
        this._dynamicValueSerializers = PropertySerializerMap.emptyForProperties();
        this._property = null;
        this._filterId = null;
        this._sortKeys = false;
        this._suppressableValue = null;
    }

    protected void _ensureOverride() {
        if (this.getClass() != MapSerializer.class) {
            throw new IllegalStateException("Missing override in class " + this.getClass().getName());
        }
    }

    protected MapSerializer(MapSerializer mapSerializer, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, JsonSerializer<?> jsonSerializer2, Set<String> set) {
        super(Map.class, false);
        this._ignoredEntries = set == null || set.isEmpty() ? null : set;
        this._keyType = mapSerializer._keyType;
        this._valueType = mapSerializer._valueType;
        this._valueTypeIsStatic = mapSerializer._valueTypeIsStatic;
        this._valueTypeSerializer = mapSerializer._valueTypeSerializer;
        this._keySerializer = jsonSerializer;
        this._valueSerializer = jsonSerializer2;
        this._dynamicValueSerializers = mapSerializer._dynamicValueSerializers;
        this._property = beanProperty;
        this._filterId = mapSerializer._filterId;
        this._sortKeys = mapSerializer._sortKeys;
        this._suppressableValue = mapSerializer._suppressableValue;
    }

    @Deprecated
    protected MapSerializer(MapSerializer mapSerializer, TypeSerializer typeSerializer) {
        this(mapSerializer, typeSerializer, mapSerializer._suppressableValue);
    }

    protected MapSerializer(MapSerializer mapSerializer, TypeSerializer typeSerializer, Object object) {
        super(Map.class, false);
        this._ignoredEntries = mapSerializer._ignoredEntries;
        this._keyType = mapSerializer._keyType;
        this._valueType = mapSerializer._valueType;
        this._valueTypeIsStatic = mapSerializer._valueTypeIsStatic;
        this._valueTypeSerializer = typeSerializer;
        this._keySerializer = mapSerializer._keySerializer;
        this._valueSerializer = mapSerializer._valueSerializer;
        this._dynamicValueSerializers = mapSerializer._dynamicValueSerializers;
        this._property = mapSerializer._property;
        this._filterId = mapSerializer._filterId;
        this._sortKeys = mapSerializer._sortKeys;
        if (object == JsonInclude.Include.NON_ABSENT) {
            object = this._valueType.isReferenceType() ? JsonInclude.Include.NON_EMPTY : JsonInclude.Include.NON_NULL;
        }
        this._suppressableValue = object;
    }

    protected MapSerializer(MapSerializer mapSerializer, Object object, boolean bl) {
        super(Map.class, false);
        this._ignoredEntries = mapSerializer._ignoredEntries;
        this._keyType = mapSerializer._keyType;
        this._valueType = mapSerializer._valueType;
        this._valueTypeIsStatic = mapSerializer._valueTypeIsStatic;
        this._valueTypeSerializer = mapSerializer._valueTypeSerializer;
        this._keySerializer = mapSerializer._keySerializer;
        this._valueSerializer = mapSerializer._valueSerializer;
        this._dynamicValueSerializers = mapSerializer._dynamicValueSerializers;
        this._property = mapSerializer._property;
        this._filterId = object;
        this._sortKeys = bl;
        this._suppressableValue = mapSerializer._suppressableValue;
    }

    public MapSerializer _withValueTypeSerializer(TypeSerializer typeSerializer) {
        if (this._valueTypeSerializer == typeSerializer) {
            return this;
        }
        this._ensureOverride();
        return new MapSerializer(this, typeSerializer, null);
    }

    public MapSerializer withResolved(BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, JsonSerializer<?> jsonSerializer2, Set<String> set, boolean bl) {
        this._ensureOverride();
        MapSerializer mapSerializer = new MapSerializer(this, beanProperty, jsonSerializer, jsonSerializer2, set);
        if (bl != mapSerializer._sortKeys) {
            mapSerializer = new MapSerializer(mapSerializer, this._filterId, bl);
        }
        return mapSerializer;
    }

    public MapSerializer withFilterId(Object object) {
        if (this._filterId == object) {
            return this;
        }
        this._ensureOverride();
        return new MapSerializer(this, object, this._sortKeys);
    }

    public MapSerializer withContentInclusion(Object object) {
        if (object == this._suppressableValue) {
            return this;
        }
        this._ensureOverride();
        return new MapSerializer(this, this._valueTypeSerializer, object);
    }

    @Deprecated
    public static MapSerializer construct(String[] stringArray, JavaType javaType, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer, JsonSerializer<Object> jsonSerializer2, Object object) {
        HashSet<String> hashSet = stringArray == null || stringArray.length == 0 ? null : ArrayBuilders.arrayToSet(stringArray);
        return MapSerializer.construct(hashSet, javaType, bl, typeSerializer, jsonSerializer, jsonSerializer2, object);
    }

    public static MapSerializer construct(Set<String> set, JavaType javaType, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer, JsonSerializer<Object> jsonSerializer2, Object object) {
        JavaType javaType2;
        JavaType javaType3;
        if (javaType == null) {
            javaType2 = javaType3 = UNSPECIFIED_TYPE;
        } else {
            javaType2 = javaType.getKeyType();
            javaType3 = javaType.getContentType();
        }
        if (!bl) {
            bl = javaType3 != null && javaType3.isFinal();
        } else if (javaType3.getRawClass() == Object.class) {
            bl = false;
        }
        MapSerializer mapSerializer = new MapSerializer(set, javaType2, javaType3, bl, typeSerializer, jsonSerializer, jsonSerializer2);
        if (object != null) {
            mapSerializer = mapSerializer.withFilterId(object);
        }
        return mapSerializer;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Object object;
        Object object2;
        Object object3;
        JacksonAnnotationValue<JsonIgnoreProperties> jacksonAnnotationValue;
        JsonInclude.Include include;
        Object object4;
        JsonSerializer<Object> jsonSerializer = null;
        JsonSerializer<Object> jsonSerializer2 = null;
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        AnnotatedMember annotatedMember = beanProperty == null ? null : beanProperty.getMember();
        Object object5 = this._suppressableValue;
        if (annotatedMember != null && annotationIntrospector != null) {
            object4 = annotationIntrospector.findKeySerializer(annotatedMember);
            if (object4 != null) {
                jsonSerializer2 = serializerProvider.serializerInstance(annotatedMember, object4);
            }
            if ((object4 = annotationIntrospector.findContentSerializer(annotatedMember)) != null) {
                jsonSerializer = serializerProvider.serializerInstance(annotatedMember, object4);
            }
        }
        if ((include = ((JsonInclude.Value)(object4 = this.findIncludeOverrides(serializerProvider, beanProperty, Map.class))).getContentInclusion()) != null && include != JsonInclude.Include.USE_DEFAULTS) {
            object5 = include;
        }
        if (jsonSerializer == null) {
            jsonSerializer = this._valueSerializer;
        }
        if ((jsonSerializer = this.findConvertingContentSerializer(serializerProvider, beanProperty, jsonSerializer)) == null) {
            if (this._valueTypeIsStatic && !this._valueType.isJavaLangObject()) {
                jsonSerializer = serializerProvider.findValueSerializer(this._valueType, beanProperty);
            }
        } else {
            jsonSerializer = serializerProvider.handleSecondaryContextualization(jsonSerializer, beanProperty);
        }
        if (jsonSerializer2 == null) {
            jsonSerializer2 = this._keySerializer;
        }
        jsonSerializer2 = jsonSerializer2 == null ? serializerProvider.findKeySerializer(this._keyType, beanProperty) : serializerProvider.handleSecondaryContextualization(jsonSerializer2, beanProperty);
        Set<String> set = this._ignoredEntries;
        boolean bl = false;
        if (annotationIntrospector != null && annotatedMember != null) {
            jacksonAnnotationValue = annotationIntrospector.findPropertyIgnorals(annotatedMember);
            if (jacksonAnnotationValue != null && (object3 = ((JsonIgnoreProperties.Value)jacksonAnnotationValue).findIgnoredForSerialization()) != null && !object3.isEmpty()) {
                set = set == null ? new HashSet<String>() : new HashSet<String>(set);
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    set.add((String)object);
                }
            }
            boolean bl2 = bl = (object3 = annotationIntrospector.findSerializationSortAlphabetically(annotatedMember)) != null && ((Boolean)object3).booleanValue();
        }
        if ((jacksonAnnotationValue = this.findFormatOverrides(serializerProvider, beanProperty, Map.class)) != null && (object3 = ((JsonFormat.Value)jacksonAnnotationValue).getFeature(JsonFormat.Feature.WRITE_SORTED_MAP_ENTRIES)) != null) {
            bl = (Boolean)object3;
        }
        object3 = this.withResolved(beanProperty, jsonSerializer2, jsonSerializer, set, bl);
        if (object5 != this._suppressableValue) {
            object3 = ((MapSerializer)object3).withContentInclusion(object5);
        }
        if (beanProperty != null && (object2 = beanProperty.getMember()) != null && (object = annotationIntrospector.findFilterId((Annotated)object2)) != null) {
            object3 = ((MapSerializer)object3).withFilterId(object);
        }
        return object3;
    }

    @Override
    public JavaType getContentType() {
        return this._valueType;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._valueSerializer;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, Map<?, ?> map) {
        if (map == null || map.isEmpty()) {
            return true;
        }
        Object object = this._suppressableValue;
        if (object == null || object == JsonInclude.Include.ALWAYS) {
            return false;
        }
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer != null) {
            for (Object obj : map.values()) {
                if (obj == null || jsonSerializer.isEmpty(serializerProvider, obj)) continue;
                return false;
            }
            return true;
        }
        PropertySerializerMap propertySerializerMap = this._dynamicValueSerializers;
        for (Object obj : map.values()) {
            if (obj == null) continue;
            Class<?> clazz = obj.getClass();
            jsonSerializer = propertySerializerMap.serializerFor(clazz);
            if (jsonSerializer == null) {
                try {
                    jsonSerializer = this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                }
                catch (JsonMappingException jsonMappingException) {
                    return false;
                }
                propertySerializerMap = this._dynamicValueSerializers;
            }
            if (jsonSerializer.isEmpty(serializerProvider, obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasSingleElement(Map<?, ?> map) {
        return map.size() == 1;
    }

    public JsonSerializer<?> getKeySerializer() {
        return this._keySerializer;
    }

    @Override
    public void serialize(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject(map);
        if (!map.isEmpty()) {
            Object object = this._suppressableValue;
            if (object == JsonInclude.Include.ALWAYS) {
                object = null;
            } else if (object == null && !serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES)) {
                object = JsonInclude.Include.NON_NULL;
            }
            if (this._sortKeys || serializerProvider.isEnabled(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS)) {
                map = this._orderEntries(map);
            }
            if (this._filterId != null) {
                this.serializeFilteredFields(map, jsonGenerator, serializerProvider, this.findPropertyFilter(serializerProvider, this._filterId, map), object);
            } else if (object != null) {
                this.serializeOptionalFields(map, jsonGenerator, serializerProvider, object);
            } else if (this._valueSerializer != null) {
                this.serializeFieldsUsing(map, jsonGenerator, serializerProvider, this._valueSerializer);
            } else {
                this.serializeFields(map, jsonGenerator, serializerProvider);
            }
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        typeSerializer.writeTypePrefixForObject(map, jsonGenerator);
        jsonGenerator.setCurrentValue(map);
        if (!map.isEmpty()) {
            Object object = this._suppressableValue;
            if (object == JsonInclude.Include.ALWAYS) {
                object = null;
            } else if (object == null && !serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES)) {
                object = JsonInclude.Include.NON_NULL;
            }
            if (this._sortKeys || serializerProvider.isEnabled(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS)) {
                map = this._orderEntries(map);
            }
            if (this._filterId != null) {
                this.serializeFilteredFields(map, jsonGenerator, serializerProvider, this.findPropertyFilter(serializerProvider, this._filterId, map), object);
            } else if (object != null) {
                this.serializeOptionalFields(map, jsonGenerator, serializerProvider, object);
            } else if (this._valueSerializer != null) {
                this.serializeFieldsUsing(map, jsonGenerator, serializerProvider, this._valueSerializer);
            } else {
                this.serializeFields(map, jsonGenerator, serializerProvider);
            }
        }
        typeSerializer.writeTypeSuffixForObject(map, jsonGenerator);
    }

    public void serializeFields(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this._valueTypeSerializer != null) {
            this.serializeTypedFields(map, jsonGenerator, serializerProvider, null);
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._keySerializer;
        Set<String> set = this._ignoredEntries;
        PropertySerializerMap propertySerializerMap = this._dynamicValueSerializers;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Class<?> clazz;
            Object obj = entry.getValue();
            Object obj2 = entry.getKey();
            if (obj2 == null) {
                serializerProvider.findNullKeySerializer(this._keyType, this._property).serialize(null, jsonGenerator, serializerProvider);
            } else {
                if (set != null && set.contains(obj2)) continue;
                jsonSerializer.serialize(obj2, jsonGenerator, serializerProvider);
            }
            if (obj == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            JsonSerializer<Object> jsonSerializer2 = this._valueSerializer;
            if (jsonSerializer2 == null && (jsonSerializer2 = propertySerializerMap.serializerFor(clazz = obj.getClass())) == null) {
                jsonSerializer2 = this._valueType.hasGenericTypes() ? this._findAndAddDynamic(propertySerializerMap, serializerProvider.constructSpecializedType(this._valueType, clazz), serializerProvider) : this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                propertySerializerMap = this._dynamicValueSerializers;
            }
            try {
                jsonSerializer2.serialize(obj, jsonGenerator, serializerProvider);
            }
            catch (Exception exception) {
                String string = "" + obj2;
                this.wrapAndThrow(serializerProvider, (Throwable)exception, map, string);
            }
        }
    }

    public void serializeOptionalFields(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, Object object) throws IOException {
        if (this._valueTypeSerializer != null) {
            this.serializeTypedFields(map, jsonGenerator, serializerProvider, object);
            return;
        }
        Set<String> set = this._ignoredEntries;
        PropertySerializerMap propertySerializerMap = this._dynamicValueSerializers;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            JsonSerializer<Object> jsonSerializer;
            JsonSerializer<Object> jsonSerializer2;
            Object obj = entry.getKey();
            if (obj == null) {
                jsonSerializer2 = serializerProvider.findNullKeySerializer(this._keyType, this._property);
            } else {
                if (set != null && set.contains(obj)) continue;
                jsonSerializer2 = this._keySerializer;
            }
            Object obj2 = entry.getValue();
            if (obj2 == null) {
                if (object != null) continue;
                jsonSerializer = serializerProvider.getDefaultNullValueSerializer();
            } else {
                Class<?> clazz;
                jsonSerializer = this._valueSerializer;
                if (jsonSerializer == null && (jsonSerializer = propertySerializerMap.serializerFor(clazz = obj2.getClass())) == null) {
                    jsonSerializer = this._valueType.hasGenericTypes() ? this._findAndAddDynamic(propertySerializerMap, serializerProvider.constructSpecializedType(this._valueType, clazz), serializerProvider) : this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                    propertySerializerMap = this._dynamicValueSerializers;
                }
                if (object == JsonInclude.Include.NON_EMPTY && jsonSerializer.isEmpty(serializerProvider, obj2)) continue;
            }
            try {
                jsonSerializer2.serialize(obj, jsonGenerator, serializerProvider);
                jsonSerializer.serialize(obj2, jsonGenerator, serializerProvider);
            }
            catch (Exception exception) {
                String string = "" + obj;
                this.wrapAndThrow(serializerProvider, (Throwable)exception, map, string);
            }
        }
    }

    public void serializeFieldsUsing(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer<Object> jsonSerializer) throws IOException {
        JsonSerializer<Object> jsonSerializer2 = this._keySerializer;
        Set<String> set = this._ignoredEntries;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object obj = entry.getKey();
            if (set != null && set.contains(obj)) continue;
            if (obj == null) {
                serializerProvider.findNullKeySerializer(this._keyType, this._property).serialize(null, jsonGenerator, serializerProvider);
            } else {
                jsonSerializer2.serialize(obj, jsonGenerator, serializerProvider);
            }
            Object obj2 = entry.getValue();
            if (obj2 == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            try {
                if (typeSerializer == null) {
                    jsonSerializer.serialize(obj2, jsonGenerator, serializerProvider);
                    continue;
                }
                jsonSerializer.serializeWithType(obj2, jsonGenerator, serializerProvider, typeSerializer);
            }
            catch (Exception exception) {
                String string = "" + obj;
                this.wrapAndThrow(serializerProvider, (Throwable)exception, map, string);
            }
        }
    }

    public void serializeFilteredFields(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, PropertyFilter propertyFilter, Object object) throws IOException {
        Set<String> set = this._ignoredEntries;
        PropertySerializerMap propertySerializerMap = this._dynamicValueSerializers;
        MapProperty mapProperty = new MapProperty(this._valueTypeSerializer, this._property);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            JsonSerializer<Object> jsonSerializer;
            Object obj = entry.getKey();
            if (set != null && set.contains(obj)) continue;
            JsonSerializer<Object> jsonSerializer2 = obj == null ? serializerProvider.findNullKeySerializer(this._keyType, this._property) : this._keySerializer;
            Object obj2 = entry.getValue();
            if (obj2 == null) {
                if (object != null) continue;
                jsonSerializer = serializerProvider.getDefaultNullValueSerializer();
            } else {
                Class<?> clazz;
                jsonSerializer = this._valueSerializer;
                if (jsonSerializer == null && (jsonSerializer = propertySerializerMap.serializerFor(clazz = obj2.getClass())) == null) {
                    jsonSerializer = this._valueType.hasGenericTypes() ? this._findAndAddDynamic(propertySerializerMap, serializerProvider.constructSpecializedType(this._valueType, clazz), serializerProvider) : this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                    propertySerializerMap = this._dynamicValueSerializers;
                }
                if (object == JsonInclude.Include.NON_EMPTY && jsonSerializer.isEmpty(serializerProvider, obj2)) continue;
            }
            mapProperty.reset(obj, jsonSerializer2, jsonSerializer);
            try {
                propertyFilter.serializeAsField(obj2, jsonGenerator, serializerProvider, mapProperty);
            }
            catch (Exception exception) {
                String string = "" + obj;
                this.wrapAndThrow(serializerProvider, (Throwable)exception, map, string);
            }
        }
    }

    @Deprecated
    public void serializeFilteredFields(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, PropertyFilter propertyFilter) throws IOException {
        this.serializeFilteredFields(map, jsonGenerator, serializerProvider, propertyFilter, (Object)(serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES) ? null : JsonInclude.Include.NON_NULL));
    }

    public void serializeTypedFields(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, Object object) throws IOException {
        Set<String> set = this._ignoredEntries;
        PropertySerializerMap propertySerializerMap = this._dynamicValueSerializers;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            JsonSerializer<Object> jsonSerializer;
            JsonSerializer<Object> jsonSerializer2;
            Object obj = entry.getKey();
            if (obj == null) {
                jsonSerializer2 = serializerProvider.findNullKeySerializer(this._keyType, this._property);
            } else {
                if (set != null && set.contains(obj)) continue;
                jsonSerializer2 = this._keySerializer;
            }
            Object obj2 = entry.getValue();
            if (obj2 == null) {
                if (object != null) continue;
                jsonSerializer = serializerProvider.getDefaultNullValueSerializer();
            } else {
                jsonSerializer = this._valueSerializer;
                Class<?> clazz = obj2.getClass();
                jsonSerializer = propertySerializerMap.serializerFor(clazz);
                if (jsonSerializer == null) {
                    jsonSerializer = this._valueType.hasGenericTypes() ? this._findAndAddDynamic(propertySerializerMap, serializerProvider.constructSpecializedType(this._valueType, clazz), serializerProvider) : this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                    propertySerializerMap = this._dynamicValueSerializers;
                }
                if (object == JsonInclude.Include.NON_EMPTY && jsonSerializer.isEmpty(serializerProvider, obj2)) continue;
            }
            jsonSerializer2.serialize(obj, jsonGenerator, serializerProvider);
            try {
                jsonSerializer.serializeWithType(obj2, jsonGenerator, serializerProvider, this._valueTypeSerializer);
            }
            catch (Exception exception) {
                String string = "" + obj;
                this.wrapAndThrow(serializerProvider, (Throwable)exception, map, string);
            }
        }
    }

    @Deprecated
    protected void serializeTypedFields(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        this.serializeTypedFields(map, jsonGenerator, serializerProvider, (Object)(serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES) ? null : JsonInclude.Include.NON_NULL));
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode("object", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        JsonMapFormatVisitor jsonMapFormatVisitor;
        JsonMapFormatVisitor jsonMapFormatVisitor2 = jsonMapFormatVisitor = jsonFormatVisitorWrapper == null ? null : jsonFormatVisitorWrapper.expectMapFormat(javaType);
        if (jsonMapFormatVisitor != null) {
            jsonMapFormatVisitor.keyFormat(this._keySerializer, this._keyType);
            JsonSerializer<Object> jsonSerializer = this._valueSerializer;
            if (jsonSerializer == null) {
                jsonSerializer = this._findAndAddDynamic(this._dynamicValueSerializers, this._valueType, jsonFormatVisitorWrapper.getProvider());
            }
            jsonMapFormatVisitor.valueFormat(jsonSerializer, this._valueType);
        }
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, Class<?> clazz, SerializerProvider serializerProvider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult serializerAndMapResult = propertySerializerMap.findAndAddSecondarySerializer(clazz, serializerProvider, this._property);
        if (propertySerializerMap != serializerAndMapResult.map) {
            this._dynamicValueSerializers = serializerAndMapResult.map;
        }
        return serializerAndMapResult.serializer;
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, JavaType javaType, SerializerProvider serializerProvider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult serializerAndMapResult = propertySerializerMap.findAndAddSecondarySerializer(javaType, serializerProvider, this._property);
        if (propertySerializerMap != serializerAndMapResult.map) {
            this._dynamicValueSerializers = serializerAndMapResult.map;
        }
        return serializerAndMapResult.serializer;
    }

    protected Map<?, ?> _orderEntries(Map<?, ?> map) {
        if (map instanceof SortedMap) {
            return map;
        }
        return new TreeMap(map);
    }
}

