/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.Map;

abstract class NodeCursor
extends JsonStreamContext {
    protected final NodeCursor _parent;
    protected String _currentName;
    protected Object _currentValue;

    public NodeCursor(int n, NodeCursor nodeCursor) {
        this._type = n;
        this._index = -1;
        this._parent = nodeCursor;
    }

    @Override
    public final NodeCursor getParent() {
        return this._parent;
    }

    @Override
    public final String getCurrentName() {
        return this._currentName;
    }

    public void overrideCurrentName(String string) {
        this._currentName = string;
    }

    @Override
    public Object getCurrentValue() {
        return this._currentValue;
    }

    @Override
    public void setCurrentValue(Object object) {
        this._currentValue = object;
    }

    public abstract JsonToken nextToken();

    public abstract JsonToken nextValue();

    public abstract JsonToken endToken();

    public abstract JsonNode currentNode();

    public abstract boolean currentHasChildren();

    public final NodeCursor iterateChildren() {
        JsonNode jsonNode = this.currentNode();
        if (jsonNode == null) {
            throw new IllegalStateException("No current node");
        }
        if (jsonNode.isArray()) {
            return new ArrayCursor(jsonNode, this);
        }
        if (jsonNode.isObject()) {
            return new ObjectCursor(jsonNode, this);
        }
        throw new IllegalStateException("Current node of type " + jsonNode.getClass().getName());
    }

    protected static final class ObjectCursor
    extends NodeCursor {
        protected Iterator<Map.Entry<String, JsonNode>> _contents;
        protected Map.Entry<String, JsonNode> _current;
        protected boolean _needEntry;

        public ObjectCursor(JsonNode jsonNode, NodeCursor nodeCursor) {
            super(2, nodeCursor);
            this._contents = ((ObjectNode)jsonNode).fields();
            this._needEntry = true;
        }

        @Override
        public JsonToken nextToken() {
            if (this._needEntry) {
                if (!this._contents.hasNext()) {
                    this._currentName = null;
                    this._current = null;
                    return null;
                }
                this._needEntry = false;
                this._current = this._contents.next();
                this._currentName = this._current == null ? null : this._current.getKey();
                return JsonToken.FIELD_NAME;
            }
            this._needEntry = true;
            return this._current.getValue().asToken();
        }

        @Override
        public JsonToken nextValue() {
            JsonToken jsonToken = this.nextToken();
            if (jsonToken == JsonToken.FIELD_NAME) {
                jsonToken = this.nextToken();
            }
            return jsonToken;
        }

        @Override
        public JsonToken endToken() {
            return JsonToken.END_OBJECT;
        }

        @Override
        public JsonNode currentNode() {
            return this._current == null ? null : this._current.getValue();
        }

        @Override
        public boolean currentHasChildren() {
            return ((ContainerNode)this.currentNode()).size() > 0;
        }
    }

    protected static final class ArrayCursor
    extends NodeCursor {
        protected Iterator<JsonNode> _contents;
        protected JsonNode _currentNode;

        public ArrayCursor(JsonNode jsonNode, NodeCursor nodeCursor) {
            super(1, nodeCursor);
            this._contents = jsonNode.elements();
        }

        @Override
        public JsonToken nextToken() {
            if (!this._contents.hasNext()) {
                this._currentNode = null;
                return null;
            }
            this._currentNode = this._contents.next();
            return this._currentNode.asToken();
        }

        @Override
        public JsonToken nextValue() {
            return this.nextToken();
        }

        @Override
        public JsonToken endToken() {
            return JsonToken.END_ARRAY;
        }

        @Override
        public JsonNode currentNode() {
            return this._currentNode;
        }

        @Override
        public boolean currentHasChildren() {
            return ((ContainerNode)this.currentNode()).size() > 0;
        }
    }

    protected static final class RootCursor
    extends NodeCursor {
        protected JsonNode _node;
        protected boolean _done = false;

        public RootCursor(JsonNode jsonNode, NodeCursor nodeCursor) {
            super(0, nodeCursor);
            this._node = jsonNode;
        }

        @Override
        public void overrideCurrentName(String string) {
        }

        @Override
        public JsonToken nextToken() {
            if (!this._done) {
                this._done = true;
                return this._node.asToken();
            }
            this._node = null;
            return null;
        }

        @Override
        public JsonToken nextValue() {
            return this.nextToken();
        }

        @Override
        public JsonToken endToken() {
            return null;
        }

        @Override
        public JsonNode currentNode() {
            return this._node;
        }

        @Override
        public boolean currentHasChildren() {
            return false;
        }
    }
}

