/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeSerializerBase;
import java.io.IOException;

public class AsExternalTypeSerializer
extends TypeSerializerBase {
    protected final String _typePropertyName;

    public AsExternalTypeSerializer(TypeIdResolver typeIdResolver, BeanProperty beanProperty, String string) {
        super(typeIdResolver, beanProperty);
        this._typePropertyName = string;
    }

    @Override
    public AsExternalTypeSerializer forProperty(BeanProperty beanProperty) {
        return this._property == beanProperty ? this : new AsExternalTypeSerializer(this._idResolver, beanProperty, this._typePropertyName);
    }

    @Override
    public String getPropertyName() {
        return this._typePropertyName;
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.EXTERNAL_PROPERTY;
    }

    @Override
    public void writeTypePrefixForObject(Object object, JsonGenerator jsonGenerator) throws IOException {
        this._writeObjectPrefix(object, jsonGenerator);
    }

    @Override
    public void writeTypePrefixForObject(Object object, JsonGenerator jsonGenerator, Class<?> clazz) throws IOException {
        this._writeObjectPrefix(object, jsonGenerator);
    }

    @Override
    public void writeTypePrefixForArray(Object object, JsonGenerator jsonGenerator) throws IOException {
        this._writeArrayPrefix(object, jsonGenerator);
    }

    @Override
    public void writeTypePrefixForArray(Object object, JsonGenerator jsonGenerator, Class<?> clazz) throws IOException {
        this._writeArrayPrefix(object, jsonGenerator);
    }

    @Override
    public void writeTypePrefixForScalar(Object object, JsonGenerator jsonGenerator) throws IOException {
        this._writeScalarPrefix(object, jsonGenerator);
    }

    @Override
    public void writeTypePrefixForScalar(Object object, JsonGenerator jsonGenerator, Class<?> clazz) throws IOException {
        this._writeScalarPrefix(object, jsonGenerator);
    }

    @Override
    public void writeTypeSuffixForObject(Object object, JsonGenerator jsonGenerator) throws IOException {
        this._writeObjectSuffix(object, jsonGenerator, this.idFromValue(object));
    }

    @Override
    public void writeTypeSuffixForArray(Object object, JsonGenerator jsonGenerator) throws IOException {
        this._writeArraySuffix(object, jsonGenerator, this.idFromValue(object));
    }

    @Override
    public void writeTypeSuffixForScalar(Object object, JsonGenerator jsonGenerator) throws IOException {
        this._writeScalarSuffix(object, jsonGenerator, this.idFromValue(object));
    }

    @Override
    public void writeCustomTypePrefixForScalar(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        this._writeScalarPrefix(object, jsonGenerator);
    }

    @Override
    public void writeCustomTypePrefixForObject(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        this._writeObjectPrefix(object, jsonGenerator);
    }

    @Override
    public void writeCustomTypePrefixForArray(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        this._writeArrayPrefix(object, jsonGenerator);
    }

    @Override
    public void writeCustomTypeSuffixForScalar(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        this._writeScalarSuffix(object, jsonGenerator, string);
    }

    @Override
    public void writeCustomTypeSuffixForObject(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        this._writeObjectSuffix(object, jsonGenerator, string);
    }

    @Override
    public void writeCustomTypeSuffixForArray(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        this._writeArraySuffix(object, jsonGenerator, string);
    }

    protected final void _writeScalarPrefix(Object object, JsonGenerator jsonGenerator) throws IOException {
    }

    protected final void _writeObjectPrefix(Object object, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
    }

    protected final void _writeArrayPrefix(Object object, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartArray();
    }

    protected final void _writeScalarSuffix(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        if (string != null) {
            jsonGenerator.writeStringField(this._typePropertyName, string);
        }
    }

    protected final void _writeObjectSuffix(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        jsonGenerator.writeEndObject();
        if (string != null) {
            jsonGenerator.writeStringField(this._typePropertyName, string);
        }
    }

    protected final void _writeArraySuffix(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        jsonGenerator.writeEndArray();
        if (string != null) {
            jsonGenerator.writeStringField(this._typePropertyName, string);
        }
    }
}

