/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class ExternalTypeHandler {
    private final ExtTypedProperty[] _properties;
    private final HashMap<String, Integer> _nameToPropertyIndex;
    private final String[] _typeIds;
    private final TokenBuffer[] _tokens;

    protected ExternalTypeHandler(ExtTypedProperty[] extTypedPropertyArray, HashMap<String, Integer> hashMap, String[] stringArray, TokenBuffer[] tokenBufferArray) {
        this._properties = extTypedPropertyArray;
        this._nameToPropertyIndex = hashMap;
        this._typeIds = stringArray;
        this._tokens = tokenBufferArray;
    }

    protected ExternalTypeHandler(ExternalTypeHandler externalTypeHandler) {
        this._properties = externalTypeHandler._properties;
        this._nameToPropertyIndex = externalTypeHandler._nameToPropertyIndex;
        int n = this._properties.length;
        this._typeIds = new String[n];
        this._tokens = new TokenBuffer[n];
    }

    public ExternalTypeHandler start() {
        return new ExternalTypeHandler(this);
    }

    public boolean handleTypePropertyValue(JsonParser jsonParser, DeserializationContext deserializationContext, String string, Object object) throws IOException {
        boolean bl;
        Integer n = this._nameToPropertyIndex.get(string);
        if (n == null) {
            return false;
        }
        int n2 = n;
        ExtTypedProperty extTypedProperty = this._properties[n2];
        if (!extTypedProperty.hasTypePropertyName(string)) {
            return false;
        }
        String string2 = jsonParser.getText();
        boolean bl2 = bl = object != null && this._tokens[n2] != null;
        if (bl) {
            this._deserializeAndSet(jsonParser, deserializationContext, object, n2, string2);
            this._tokens[n2] = null;
        } else {
            this._typeIds[n2] = string2;
        }
        return true;
    }

    public boolean handlePropertyValue(JsonParser jsonParser, DeserializationContext deserializationContext, String string, Object object) throws IOException {
        Object object2;
        boolean bl;
        Integer n = this._nameToPropertyIndex.get(string);
        if (n == null) {
            return false;
        }
        int n2 = n;
        ExtTypedProperty extTypedProperty = this._properties[n2];
        if (extTypedProperty.hasTypePropertyName(string)) {
            this._typeIds[n2] = jsonParser.getText();
            jsonParser.skipChildren();
            bl = object != null && this._tokens[n2] != null;
        } else {
            object2 = new TokenBuffer(jsonParser, deserializationContext);
            ((TokenBuffer)object2).copyCurrentStructure(jsonParser);
            this._tokens[n2] = object2;
            boolean bl2 = bl = object != null && this._typeIds[n2] != null;
        }
        if (bl) {
            object2 = this._typeIds[n2];
            this._typeIds[n2] = null;
            this._deserializeAndSet(jsonParser, deserializationContext, object, n2, (String)object2);
            this._tokens[n2] = null;
        }
        return true;
    }

    public Object complete(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        int n = this._properties.length;
        for (int i = 0; i < n; ++i) {
            Object object2;
            String string = this._typeIds[i];
            if (string == null) {
                object2 = this._tokens[i];
                if (object2 == null) continue;
                JsonToken jsonToken = ((TokenBuffer)object2).firstToken();
                if (jsonToken != null && jsonToken.isScalarValue()) {
                    JsonParser jsonParser2 = ((TokenBuffer)object2).asParser(jsonParser);
                    jsonParser2.nextToken();
                    SettableBeanProperty settableBeanProperty = this._properties[i].getProperty();
                    Object object3 = TypeDeserializer.deserializeIfNatural(jsonParser2, deserializationContext, settableBeanProperty.getType());
                    if (object3 != null) {
                        settableBeanProperty.set(object, object3);
                        continue;
                    }
                    if (!this._properties[i].hasDefaultType()) {
                        deserializationContext.reportMappingException("Missing external type id property '%s'", this._properties[i].getTypePropertyName());
                    } else {
                        string = this._properties[i].getDefaultTypeId();
                    }
                }
            } else if (this._tokens[i] == null) {
                object2 = this._properties[i].getProperty();
                deserializationContext.reportMappingException("Missing property '%s' for external type id '%s'", ((SettableBeanProperty)object2).getName(), this._properties[i].getTypePropertyName());
            }
            this._deserializeAndSet(jsonParser, deserializationContext, object, i, string);
        }
        return object;
    }

    public Object complete(JsonParser jsonParser, DeserializationContext deserializationContext, PropertyValueBuffer propertyValueBuffer, PropertyBasedCreator propertyBasedCreator) throws IOException {
        Object object;
        int n = this._properties.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            SettableBeanProperty settableBeanProperty;
            String string = this._typeIds[i];
            object = this._properties[i];
            if (string == null) {
                if (this._tokens[i] == null) continue;
                if (!((ExtTypedProperty)object).hasDefaultType()) {
                    deserializationContext.reportMappingException("Missing external type id property '%s'", ((ExtTypedProperty)object).getTypePropertyName());
                } else {
                    string = ((ExtTypedProperty)object).getDefaultTypeId();
                }
            } else if (this._tokens[i] == null) {
                settableBeanProperty = ((ExtTypedProperty)object).getProperty();
                deserializationContext.reportMappingException("Missing property '%s' for external type id '%s'", settableBeanProperty.getName(), this._properties[i].getTypePropertyName());
            }
            objectArray[i] = this._deserialize(jsonParser, deserializationContext, i, string);
            settableBeanProperty = ((ExtTypedProperty)object).getProperty();
            if (settableBeanProperty.getCreatorIndex() < 0) continue;
            propertyValueBuffer.assignParameter(settableBeanProperty, objectArray[i]);
            SettableBeanProperty settableBeanProperty2 = ((ExtTypedProperty)object).getTypeProperty();
            if (settableBeanProperty2 == null || settableBeanProperty2.getCreatorIndex() < 0) continue;
            propertyValueBuffer.assignParameter(settableBeanProperty2, string);
        }
        Object object2 = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        for (int i = 0; i < n; ++i) {
            object = this._properties[i].getProperty();
            if (((SettableBeanProperty)object).getCreatorIndex() >= 0) continue;
            ((SettableBeanProperty)object).set(object2, objectArray[i]);
        }
        return object2;
    }

    protected final Object _deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, int n, String string) throws IOException {
        JsonParser jsonParser2 = this._tokens[n].asParser(jsonParser);
        JsonToken jsonToken = jsonParser2.nextToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser, deserializationContext);
        tokenBuffer.writeStartArray();
        tokenBuffer.writeString(string);
        tokenBuffer.copyCurrentStructure(jsonParser2);
        tokenBuffer.writeEndArray();
        JsonParser jsonParser3 = tokenBuffer.asParser(jsonParser);
        jsonParser3.nextToken();
        return this._properties[n].getProperty().deserialize(jsonParser3, deserializationContext);
    }

    protected final void _deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, int n, String string) throws IOException {
        JsonParser jsonParser2 = this._tokens[n].asParser(jsonParser);
        JsonToken jsonToken = jsonParser2.nextToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            this._properties[n].getProperty().set(object, null);
            return;
        }
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser, deserializationContext);
        tokenBuffer.writeStartArray();
        tokenBuffer.writeString(string);
        tokenBuffer.copyCurrentStructure(jsonParser2);
        tokenBuffer.writeEndArray();
        JsonParser jsonParser3 = tokenBuffer.asParser(jsonParser);
        jsonParser3.nextToken();
        this._properties[n].getProperty().deserializeAndSet(jsonParser3, deserializationContext, object);
    }

    private static final class ExtTypedProperty {
        private final SettableBeanProperty _property;
        private final TypeDeserializer _typeDeserializer;
        private final String _typePropertyName;
        private SettableBeanProperty _typeProperty;

        public ExtTypedProperty(SettableBeanProperty settableBeanProperty, TypeDeserializer typeDeserializer) {
            this._property = settableBeanProperty;
            this._typeDeserializer = typeDeserializer;
            this._typePropertyName = typeDeserializer.getPropertyName();
        }

        public void linkTypeProperty(SettableBeanProperty settableBeanProperty) {
            this._typeProperty = settableBeanProperty;
        }

        public boolean hasTypePropertyName(String string) {
            return string.equals(this._typePropertyName);
        }

        public boolean hasDefaultType() {
            return this._typeDeserializer.getDefaultImpl() != null;
        }

        public String getDefaultTypeId() {
            Class<?> clazz = this._typeDeserializer.getDefaultImpl();
            if (clazz == null) {
                return null;
            }
            return this._typeDeserializer.getTypeIdResolver().idFromValueAndType(null, clazz);
        }

        public String getTypePropertyName() {
            return this._typePropertyName;
        }

        public SettableBeanProperty getProperty() {
            return this._property;
        }

        public SettableBeanProperty getTypeProperty() {
            return this._typeProperty;
        }
    }

    public static class Builder {
        private final ArrayList<ExtTypedProperty> _properties = new ArrayList();
        private final HashMap<String, Integer> _nameToPropertyIndex = new HashMap();

        public void addExternal(SettableBeanProperty settableBeanProperty, TypeDeserializer typeDeserializer) {
            Integer n = this._properties.size();
            this._properties.add(new ExtTypedProperty(settableBeanProperty, typeDeserializer));
            this._nameToPropertyIndex.put(settableBeanProperty.getName(), n);
            this._nameToPropertyIndex.put(typeDeserializer.getPropertyName(), n);
        }

        public ExternalTypeHandler build(BeanPropertyMap beanPropertyMap) {
            int n = this._properties.size();
            ExtTypedProperty[] extTypedPropertyArray = new ExtTypedProperty[n];
            for (int i = 0; i < n; ++i) {
                ExtTypedProperty extTypedProperty = this._properties.get(i);
                String string = extTypedProperty.getTypePropertyName();
                SettableBeanProperty settableBeanProperty = beanPropertyMap.find(string);
                if (settableBeanProperty != null) {
                    extTypedProperty.linkTypeProperty(settableBeanProperty);
                }
                extTypedPropertyArray[i] = extTypedProperty;
            }
            return new ExternalTypeHandler(extTypedPropertyArray, this._nameToPropertyIndex, null, null);
        }

        @Deprecated
        public ExternalTypeHandler build() {
            return new ExternalTypeHandler(this._properties.toArray(new ExtTypedProperty[this._properties.size()]), this._nameToPropertyIndex, null, null);
        }
    }
}

