/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.impl.BeanAsArrayDeserializer;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ExternalTypeHandler;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BeanDeserializer
extends BeanDeserializerBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient Exception _nullFromCreator;

    public BeanDeserializer(BeanDeserializerBuilder beanDeserializerBuilder, BeanDescription beanDescription, BeanPropertyMap beanPropertyMap, Map<String, SettableBeanProperty> map, HashSet<String> hashSet, boolean bl, boolean bl2) {
        super(beanDeserializerBuilder, beanDescription, beanPropertyMap, map, hashSet, bl, bl2);
    }

    protected BeanDeserializer(BeanDeserializerBase beanDeserializerBase) {
        super(beanDeserializerBase, beanDeserializerBase._ignoreAllUnknown);
    }

    protected BeanDeserializer(BeanDeserializerBase beanDeserializerBase, boolean bl) {
        super(beanDeserializerBase, bl);
    }

    protected BeanDeserializer(BeanDeserializerBase beanDeserializerBase, NameTransformer nameTransformer) {
        super(beanDeserializerBase, nameTransformer);
    }

    public BeanDeserializer(BeanDeserializerBase beanDeserializerBase, ObjectIdReader objectIdReader) {
        super(beanDeserializerBase, objectIdReader);
    }

    public BeanDeserializer(BeanDeserializerBase beanDeserializerBase, Set<String> set) {
        super(beanDeserializerBase, set);
    }

    public BeanDeserializer(BeanDeserializerBase beanDeserializerBase, BeanPropertyMap beanPropertyMap) {
        super(beanDeserializerBase, beanPropertyMap);
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer nameTransformer) {
        if (this.getClass() != BeanDeserializer.class) {
            return this;
        }
        return new BeanDeserializer((BeanDeserializerBase)this, nameTransformer);
    }

    @Override
    public BeanDeserializer withObjectIdReader(ObjectIdReader objectIdReader) {
        return new BeanDeserializer((BeanDeserializerBase)this, objectIdReader);
    }

    @Override
    public BeanDeserializer withIgnorableProperties(Set<String> set) {
        return new BeanDeserializer((BeanDeserializerBase)this, set);
    }

    @Override
    public BeanDeserializerBase withBeanProperties(BeanPropertyMap beanPropertyMap) {
        return new BeanDeserializer((BeanDeserializerBase)this, beanPropertyMap);
    }

    @Override
    protected BeanDeserializerBase asArrayDeserializer() {
        SettableBeanProperty[] settableBeanPropertyArray = this._beanProperties.getPropertiesInInsertionOrder();
        return new BeanAsArrayDeserializer((BeanDeserializerBase)this, settableBeanPropertyArray);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.isExpectedStartObjectToken()) {
            if (this._vanillaProcessing) {
                return this.vanillaDeserialize(jsonParser, deserializationContext, jsonParser.nextToken());
            }
            jsonParser.nextToken();
            if (this._objectIdReader != null) {
                return this.deserializeWithObjectId(jsonParser, deserializationContext);
            }
            return this.deserializeFromObject(jsonParser, deserializationContext);
        }
        return this._deserializeOther(jsonParser, deserializationContext, jsonParser.getCurrentToken());
    }

    protected final Object _deserializeOther(JsonParser jsonParser, DeserializationContext deserializationContext, JsonToken jsonToken) throws IOException {
        switch (jsonToken) {
            case VALUE_STRING: {
                return this.deserializeFromString(jsonParser, deserializationContext);
            }
            case VALUE_NUMBER_INT: {
                return this.deserializeFromNumber(jsonParser, deserializationContext);
            }
            case VALUE_NUMBER_FLOAT: {
                return this.deserializeFromDouble(jsonParser, deserializationContext);
            }
            case VALUE_EMBEDDED_OBJECT: {
                return this.deserializeFromEmbedded(jsonParser, deserializationContext);
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                return this.deserializeFromBoolean(jsonParser, deserializationContext);
            }
            case VALUE_NULL: {
                return this.deserializeFromNull(jsonParser, deserializationContext);
            }
            case START_ARRAY: {
                return this.deserializeFromArray(jsonParser, deserializationContext);
            }
            case FIELD_NAME: 
            case END_OBJECT: {
                if (this._vanillaProcessing) {
                    return this.vanillaDeserialize(jsonParser, deserializationContext, jsonToken);
                }
                if (this._objectIdReader != null) {
                    return this.deserializeWithObjectId(jsonParser, deserializationContext);
                }
                return this.deserializeFromObject(jsonParser, deserializationContext);
            }
        }
        return deserializationContext.handleUnexpectedToken(this.handledType(), jsonParser);
    }

    @Deprecated
    protected Object _missingToken(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        throw deserializationContext.endOfInputException(this.handledType());
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        Serializable serializable;
        String string;
        jsonParser.setCurrentValue(object);
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        if (this._unwrappedPropertyHandler != null) {
            return this.deserializeWithUnwrapped(jsonParser, deserializationContext, object);
        }
        if (this._externalTypeIdHandler != null) {
            return this.deserializeWithExternalTypeId(jsonParser, deserializationContext, object);
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            string = jsonParser.nextFieldName();
            if (string == null) {
                return object;
            }
        } else if (jsonParser.hasTokenId(5)) {
            string = jsonParser.getCurrentName();
        } else {
            return object;
        }
        if (this._needViewProcesing && (serializable = deserializationContext.getActiveView()) != null) {
            return this.deserializeWithView(jsonParser, deserializationContext, object, (Class<?>)serializable);
        }
        do {
            jsonParser.nextToken();
            serializable = this._beanProperties.find(string);
            if (serializable != null) {
                try {
                    ((SettableBeanProperty)serializable).deserializeAndSet(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                }
                continue;
            }
            this.handleUnknownVanilla(jsonParser, deserializationContext, object, string);
        } while ((string = jsonParser.nextFieldName()) != null);
        return object;
    }

    private final Object vanillaDeserialize(JsonParser jsonParser, DeserializationContext deserializationContext, JsonToken jsonToken) throws IOException {
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        jsonParser.setCurrentValue(object);
        if (jsonParser.hasTokenId(5)) {
            String string = jsonParser.getCurrentName();
            do {
                jsonParser.nextToken();
                SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
                if (settableBeanProperty != null) {
                    try {
                        settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                    }
                    continue;
                }
                this.handleUnknownVanilla(jsonParser, deserializationContext, object, string);
            } while ((string = jsonParser.nextFieldName()) != null);
        }
        return object;
    }

    @Override
    public Object deserializeFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object object;
        if (this._objectIdReader != null && this._objectIdReader.maySerializeAsObject() && jsonParser.hasTokenId(5) && this._objectIdReader.isValidReferencePropertyName(jsonParser.getCurrentName(), jsonParser)) {
            return this.deserializeFromObjectId(jsonParser, deserializationContext);
        }
        if (this._nonStandardCreation) {
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(jsonParser, deserializationContext);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(jsonParser, deserializationContext);
            }
            Object object2 = this.deserializeFromObjectUsingNonDefault(jsonParser, deserializationContext);
            if (this._injectables != null) {
                this.injectValues(deserializationContext, object2);
            }
            return object2;
        }
        Object object3 = this._valueInstantiator.createUsingDefault(deserializationContext);
        jsonParser.setCurrentValue(object3);
        if (jsonParser.canReadObjectId() && (object = jsonParser.getObjectId()) != null) {
            this._handleTypedObjectId(jsonParser, deserializationContext, object3, object);
        }
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object3);
        }
        if (this._needViewProcesing && (object = deserializationContext.getActiveView()) != null) {
            return this.deserializeWithView(jsonParser, deserializationContext, object3, (Class<?>)object);
        }
        if (jsonParser.hasTokenId(5)) {
            object = jsonParser.getCurrentName();
            do {
                jsonParser.nextToken();
                SettableBeanProperty settableBeanProperty = this._beanProperties.find((String)object);
                if (settableBeanProperty != null) {
                    try {
                        settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object3);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object3, (String)object, deserializationContext);
                    }
                    continue;
                }
                this.handleUnknownVanilla(jsonParser, deserializationContext, object3, (String)object);
            } while ((object = jsonParser.nextFieldName()) != null);
        }
        return object3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Object _deserializeUsingPropertyBased(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object object;
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, this._objectIdReader);
        TokenBuffer tokenBuffer = null;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        ArrayList<BeanReferring> arrayList = null;
        while (jsonToken == JsonToken.FIELD_NAME) {
            object = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty((String)object);
            if (settableBeanProperty != null) {
                if (propertyValueBuffer.assignParameter(settableBeanProperty, this._deserializeWithErrorWrapping(jsonParser, deserializationContext, settableBeanProperty))) {
                    void var10_16;
                    void var10_14;
                    jsonParser.nextToken();
                    try {
                        Object object2 = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                    }
                    catch (Exception exception) {
                        Object object3 = this.wrapInstantiationProblem(exception, deserializationContext);
                    }
                    if (var10_14 == null) {
                        return deserializationContext.handleInstantiationProblem(this.handledType(), null, this._creatorReturnedNullException());
                    }
                    jsonParser.setCurrentValue(var10_14);
                    if (var10_14.getClass() != this._beanType.getRawClass()) {
                        return this.handlePolymorphic(jsonParser, deserializationContext, var10_14, tokenBuffer);
                    }
                    if (tokenBuffer != null) {
                        Object object4 = this.handleUnknownProperties(deserializationContext, var10_14, tokenBuffer);
                    }
                    return this.deserialize(jsonParser, deserializationContext, (Object)var10_16);
                }
            } else if (!propertyValueBuffer.readIdProperty((String)object)) {
                SettableBeanProperty object2 = this._beanProperties.find((String)object);
                if (object2 != null) {
                    try {
                        propertyValueBuffer.bufferProperty(object2, this._deserializeWithErrorWrapping(jsonParser, deserializationContext, object2));
                    }
                    catch (UnresolvedForwardReference unresolvedForwardReference) {
                        BeanReferring beanReferring = this.handleUnresolvedReference(deserializationContext, object2, propertyValueBuffer, unresolvedForwardReference);
                        if (arrayList == null) {
                            arrayList = new ArrayList<BeanReferring>();
                        }
                        arrayList.add(beanReferring);
                    }
                } else if (this._ignorableProps != null && this._ignorableProps.contains(object)) {
                    this.handleIgnoredProperty(jsonParser, deserializationContext, this.handledType(), (String)object);
                } else if (this._anySetter != null) {
                    try {
                        propertyValueBuffer.bufferAnyProperty(this._anySetter, (String)object, this._anySetter.deserialize(jsonParser, deserializationContext));
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, this._beanType.getRawClass(), (String)object, deserializationContext);
                    }
                } else {
                    if (tokenBuffer == null) {
                        tokenBuffer = new TokenBuffer(jsonParser, deserializationContext);
                    }
                    tokenBuffer.writeFieldName((String)object);
                    tokenBuffer.copyCurrentStructure(jsonParser);
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        try {
            object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        }
        catch (Exception exception) {
            this.wrapInstantiationProblem(exception, deserializationContext);
            object = null;
        }
        if (arrayList != null) {
            for (BeanReferring beanReferring : arrayList) {
                beanReferring.setBean(object);
            }
        }
        if (tokenBuffer != null) {
            if (object.getClass() != this._beanType.getRawClass()) {
                return this.handlePolymorphic(null, deserializationContext, object, tokenBuffer);
            }
            return this.handleUnknownProperties(deserializationContext, object, tokenBuffer);
        }
        return object;
    }

    private BeanReferring handleUnresolvedReference(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty, PropertyValueBuffer propertyValueBuffer, UnresolvedForwardReference unresolvedForwardReference) throws JsonMappingException {
        BeanReferring beanReferring = new BeanReferring(deserializationContext, unresolvedForwardReference, settableBeanProperty.getType(), propertyValueBuffer, settableBeanProperty);
        unresolvedForwardReference.getRoid().appendReferring(beanReferring);
        return beanReferring;
    }

    protected final Object _deserializeWithErrorWrapping(JsonParser jsonParser, DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty) throws IOException {
        try {
            return settableBeanProperty.deserialize(jsonParser, deserializationContext);
        }
        catch (Exception exception) {
            this.wrapAndThrow((Throwable)exception, this._beanType.getRawClass(), settableBeanProperty.getName(), deserializationContext);
            return null;
        }
    }

    protected Object deserializeFromNull(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.requiresCustomCodec()) {
            TokenBuffer tokenBuffer = new TokenBuffer(jsonParser, deserializationContext);
            tokenBuffer.writeEndObject();
            JsonParser jsonParser2 = tokenBuffer.asParser(jsonParser);
            jsonParser2.nextToken();
            Object object = this._vanillaProcessing ? this.vanillaDeserialize(jsonParser2, deserializationContext, JsonToken.END_OBJECT) : this.deserializeFromObject(jsonParser2, deserializationContext);
            jsonParser2.close();
            return object;
        }
        return deserializationContext.handleUnexpectedToken(this.handledType(), jsonParser);
    }

    protected final Object deserializeWithView(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, Class<?> clazz) throws IOException {
        if (jsonParser.hasTokenId(5)) {
            String string = jsonParser.getCurrentName();
            do {
                jsonParser.nextToken();
                SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
                if (settableBeanProperty != null) {
                    if (!settableBeanProperty.visibleInView(clazz)) {
                        jsonParser.skipChildren();
                        continue;
                    }
                    try {
                        settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                    }
                    continue;
                }
                this.handleUnknownVanilla(jsonParser, deserializationContext, object, string);
            } while ((string = jsonParser.nextFieldName()) != null);
        }
        return object;
    }

    protected Object deserializeWithUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string;
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithUnwrapped(jsonParser, deserializationContext);
        }
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser, deserializationContext);
        tokenBuffer.writeStartObject();
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        jsonParser.setCurrentValue(object);
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        Class<?> clazz = this._needViewProcesing ? deserializationContext.getActiveView() : null;
        String string2 = string = jsonParser.hasTokenId(5) ? jsonParser.getCurrentName() : null;
        while (string != null) {
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            if (settableBeanProperty != null) {
                if (clazz != null && !settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                this.handleIgnoredProperty(jsonParser, deserializationContext, object, string);
            } else {
                tokenBuffer.writeFieldName(string);
                tokenBuffer.copyCurrentStructure(jsonParser);
                if (this._anySetter != null) {
                    try {
                        this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                    }
                }
            }
            string = jsonParser.nextFieldName();
        }
        tokenBuffer.writeEndObject();
        this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
        return object;
    }

    protected Object deserializeWithUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        Class<?> clazz;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            jsonToken = jsonParser.nextToken();
        }
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser, deserializationContext);
        tokenBuffer.writeStartObject();
        Class<?> clazz2 = clazz = this._needViewProcesing ? deserializationContext.getActiveView() : null;
        while (jsonToken == JsonToken.FIELD_NAME) {
            String string = jsonParser.getCurrentName();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            jsonParser.nextToken();
            if (settableBeanProperty != null) {
                if (clazz != null && !settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                this.handleIgnoredProperty(jsonParser, deserializationContext, object, string);
            } else {
                tokenBuffer.writeFieldName(string);
                tokenBuffer.copyCurrentStructure(jsonParser);
                if (this._anySetter != null) {
                    this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        tokenBuffer.writeEndObject();
        this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
        return object;
    }

    protected Object deserializeUsingPropertyBasedWithUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object object;
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, this._objectIdReader);
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser, deserializationContext);
        tokenBuffer.writeStartObject();
        JsonToken jsonToken = jsonParser.getCurrentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            Object object2;
            object = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty((String)object);
            if (settableBeanProperty != null) {
                if (propertyValueBuffer.assignParameter(settableBeanProperty, this._deserializeWithErrorWrapping(jsonParser, deserializationContext, settableBeanProperty))) {
                    jsonToken = jsonParser.nextToken();
                    try {
                        object2 = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                    }
                    catch (Exception exception) {
                        object2 = this.wrapInstantiationProblem(exception, deserializationContext);
                    }
                    jsonParser.setCurrentValue(object2);
                    while (jsonToken == JsonToken.FIELD_NAME) {
                        jsonParser.nextToken();
                        tokenBuffer.copyCurrentStructure(jsonParser);
                        jsonToken = jsonParser.nextToken();
                    }
                    tokenBuffer.writeEndObject();
                    if (object2.getClass() != this._beanType.getRawClass()) {
                        tokenBuffer.close();
                        deserializationContext.reportMappingException("Can not create polymorphic instances with unwrapped values", new Object[0]);
                        return null;
                    }
                    return this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object2, tokenBuffer);
                }
            } else if (!propertyValueBuffer.readIdProperty((String)object)) {
                object2 = this._beanProperties.find((String)object);
                if (object2 != null) {
                    propertyValueBuffer.bufferProperty((SettableBeanProperty)object2, this._deserializeWithErrorWrapping(jsonParser, deserializationContext, (SettableBeanProperty)object2));
                } else if (this._ignorableProps != null && this._ignorableProps.contains(object)) {
                    this.handleIgnoredProperty(jsonParser, deserializationContext, this.handledType(), (String)object);
                } else {
                    tokenBuffer.writeFieldName((String)object);
                    tokenBuffer.copyCurrentStructure(jsonParser);
                    if (this._anySetter != null) {
                        try {
                            propertyValueBuffer.bufferAnyProperty(this._anySetter, (String)object, this._anySetter.deserialize(jsonParser, deserializationContext));
                        }
                        catch (Exception exception) {
                            this.wrapAndThrow((Throwable)exception, this._beanType.getRawClass(), (String)object, deserializationContext);
                        }
                    }
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        try {
            object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        }
        catch (Exception exception) {
            this.wrapInstantiationProblem(exception, deserializationContext);
            return null;
        }
        return this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
    }

    protected Object deserializeWithExternalTypeId(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithExternalTypeId(jsonParser, deserializationContext);
        }
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        return this.deserializeWithExternalTypeId(jsonParser, deserializationContext, this._valueInstantiator.createUsingDefault(deserializationContext));
    }

    protected Object deserializeWithExternalTypeId(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        Class<?> clazz = this._needViewProcesing ? deserializationContext.getActiveView() : null;
        ExternalTypeHandler externalTypeHandler = this._externalTypeIdHandler.start();
        JsonToken jsonToken = jsonParser.getCurrentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            String string = jsonParser.getCurrentName();
            jsonToken = jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            if (settableBeanProperty != null) {
                if (jsonToken.isScalarValue()) {
                    externalTypeHandler.handleTypePropertyValue(jsonParser, deserializationContext, string, object);
                }
                if (clazz != null && !settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                this.handleIgnoredProperty(jsonParser, deserializationContext, object, string);
            } else if (!externalTypeHandler.handlePropertyValue(jsonParser, deserializationContext, string, object)) {
                if (this._anySetter != null) {
                    try {
                        this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                    }
                } else {
                    this.handleUnknownProperty(jsonParser, deserializationContext, object, string);
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        return externalTypeHandler.complete(jsonParser, deserializationContext, object);
    }

    protected Object deserializeUsingPropertyBasedWithExternalTypeId(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ExternalTypeHandler externalTypeHandler = this._externalTypeIdHandler.start();
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, this._objectIdReader);
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser, deserializationContext);
        tokenBuffer.writeStartObject();
        JsonToken jsonToken = jsonParser.getCurrentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            block17: {
                Object object;
                String string = jsonParser.getCurrentName();
                jsonParser.nextToken();
                SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty(string);
                if (settableBeanProperty != null) {
                    if (!externalTypeHandler.handlePropertyValue(jsonParser, deserializationContext, string, null) && propertyValueBuffer.assignParameter(settableBeanProperty, this._deserializeWithErrorWrapping(jsonParser, deserializationContext, settableBeanProperty))) {
                        jsonToken = jsonParser.nextToken();
                        try {
                            object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                        }
                        catch (Exception exception) {
                            this.wrapAndThrow((Throwable)exception, this._beanType.getRawClass(), string, deserializationContext);
                            break block17;
                        }
                        while (jsonToken == JsonToken.FIELD_NAME) {
                            jsonParser.nextToken();
                            tokenBuffer.copyCurrentStructure(jsonParser);
                            jsonToken = jsonParser.nextToken();
                        }
                        if (object.getClass() != this._beanType.getRawClass()) {
                            deserializationContext.reportMappingException("Can not create polymorphic instances with external type ids", new Object[0]);
                            return null;
                        }
                        return externalTypeHandler.complete(jsonParser, deserializationContext, object);
                    }
                } else if (!propertyValueBuffer.readIdProperty(string)) {
                    object = this._beanProperties.find(string);
                    if (object != null) {
                        propertyValueBuffer.bufferProperty((SettableBeanProperty)object, ((SettableBeanProperty)object).deserialize(jsonParser, deserializationContext));
                    } else if (!externalTypeHandler.handlePropertyValue(jsonParser, deserializationContext, string, null)) {
                        if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                            this.handleIgnoredProperty(jsonParser, deserializationContext, this.handledType(), string);
                        } else if (this._anySetter != null) {
                            propertyValueBuffer.bufferAnyProperty(this._anySetter, string, this._anySetter.deserialize(jsonParser, deserializationContext));
                        }
                    }
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        try {
            return externalTypeHandler.complete(jsonParser, deserializationContext, propertyValueBuffer, propertyBasedCreator);
        }
        catch (Exception exception) {
            return this.wrapInstantiationProblem(exception, deserializationContext);
        }
    }

    protected Exception _creatorReturnedNullException() {
        if (this._nullFromCreator == null) {
            this._nullFromCreator = new NullPointerException("JSON Creator returned null");
        }
        return this._nullFromCreator;
    }

    static class BeanReferring
    extends ReadableObjectId.Referring {
        private final DeserializationContext _context;
        private final SettableBeanProperty _prop;
        private Object _bean;

        BeanReferring(DeserializationContext deserializationContext, UnresolvedForwardReference unresolvedForwardReference, JavaType javaType, PropertyValueBuffer propertyValueBuffer, SettableBeanProperty settableBeanProperty) {
            super(unresolvedForwardReference, javaType);
            this._context = deserializationContext;
            this._prop = settableBeanProperty;
        }

        public void setBean(Object object) {
            this._bean = object;
        }

        @Override
        public void handleResolvedForwardReference(Object object, Object object2) throws IOException {
            if (this._bean == null) {
                this._context.reportMappingException("Can not resolve ObjectId forward reference using property '%s' (of type %s): Bean not yet resolved", this._prop.getName(), this._prop.getDeclaringClass().getName());
            }
            this._prop.set(this._bean, object2);
        }
    }
}

