/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.LocationInformation;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLLocationInformation
extends LocationInformation {
    private final String xpath;
    private int lineNo = -1;
    private int column = -1;

    XMLLocationInformation(Node node, String string) {
        this.xpath = string;
        if (node.hasAttributes()) {
            Node node2;
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node3 = namedNodeMap.getNamedItemNS("https://github.com/3breadt/dd-plist/", "LINE_NUMBER");
            if (node3 != null) {
                try {
                    this.lineNo = Integer.parseInt(node3.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((node2 = namedNodeMap.getNamedItemNS("https://github.com/3breadt/dd-plist/", "COLUMN_NUMBER")) != null) {
                try {
                    this.column = Integer.parseInt(node2.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public String getXPath() {
        return this.xpath;
    }

    public boolean hasLineInformation() {
        return this.lineNo > 0 && this.column > 0;
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public int getColumnNumber() {
        return this.column;
    }

    @Override
    public String getDescription() {
        if (this.hasLineInformation()) {
            return "Line: " + this.lineNo + ", Column: " + this.column + ", XPath: " + this.xpath;
        }
        return "XPath: " + this.xpath;
    }
}

