/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.quartz;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredResult;
import org.terracotta.quartz.ClusteredJobStore;
import org.terracotta.quartz.DefaultClusteredJobStore;
import org.terracotta.quartz.TerracottaJobStoreExtensions;
import org.terracotta.quartz.UpdateChecker;
import org.terracotta.toolkit.Toolkit;
import org.terracotta.toolkit.internal.ToolkitInternal;

public class PlainTerracottaJobStore<T extends ClusteredJobStore>
implements TerracottaJobStoreExtensions {
    private static final long WEEKLY = 604800000L;
    private Timer updateCheckTimer;
    private volatile T clusteredJobStore = null;
    private Long misfireThreshold = null;
    private String schedName;
    private String synchWrite = "false";
    private Long estimatedTimeToReleaseAndAcquireTrigger = null;
    private String schedInstanceId;
    private long tcRetryInterval;
    private int threadPoolSize;
    protected final ToolkitInternal toolkit;

    public PlainTerracottaJobStore(ToolkitInternal toolkitInternal) {
        this.toolkit = toolkitInternal;
    }

    @Override
    public void setSynchronousWrite(String string) {
        this.synchWrite = string;
    }

    @Override
    public void setThreadPoolSize(int n) {
        this.threadPoolSize = n;
    }

    @Override
    public List<OperableTrigger> acquireNextTriggers(long l, int n, long l2) throws JobPersistenceException {
        return this.clusteredJobStore.acquireNextTriggers(l, n, l2);
    }

    @Override
    public List<String> getCalendarNames() throws JobPersistenceException {
        return this.clusteredJobStore.getCalendarNames();
    }

    @Override
    public List<String> getJobGroupNames() throws JobPersistenceException {
        return this.clusteredJobStore.getJobGroupNames();
    }

    @Override
    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        return this.clusteredJobStore.getJobKeys(groupMatcher);
    }

    @Override
    public int getNumberOfCalendars() throws JobPersistenceException {
        return this.clusteredJobStore.getNumberOfCalendars();
    }

    @Override
    public int getNumberOfJobs() throws JobPersistenceException {
        return this.clusteredJobStore.getNumberOfJobs();
    }

    @Override
    public int getNumberOfTriggers() throws JobPersistenceException {
        return this.clusteredJobStore.getNumberOfTriggers();
    }

    @Override
    public Set<String> getPausedTriggerGroups() throws JobPersistenceException {
        return this.clusteredJobStore.getPausedTriggerGroups();
    }

    @Override
    public List<String> getTriggerGroupNames() throws JobPersistenceException {
        return this.clusteredJobStore.getTriggerGroupNames();
    }

    @Override
    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> groupMatcher) throws JobPersistenceException {
        return this.clusteredJobStore.getTriggerKeys(groupMatcher);
    }

    @Override
    public List<OperableTrigger> getTriggersForJob(JobKey jobKey) throws JobPersistenceException {
        return this.clusteredJobStore.getTriggersForJob(jobKey);
    }

    @Override
    public Trigger.TriggerState getTriggerState(TriggerKey triggerKey) throws JobPersistenceException {
        return this.clusteredJobStore.getTriggerState(triggerKey);
    }

    @Override
    public synchronized void initialize(ClassLoadHelper classLoadHelper, SchedulerSignaler schedulerSignaler) throws SchedulerConfigException {
        if (this.clusteredJobStore != null) {
            throw new IllegalStateException("already initialized");
        }
        this.clusteredJobStore = this.createNewJobStoreInstance(this.schedName, Boolean.valueOf(this.synchWrite));
        this.clusteredJobStore.setThreadPoolSize(this.threadPoolSize);
        if (this.misfireThreshold != null) {
            this.clusteredJobStore.setMisfireThreshold(this.misfireThreshold);
            this.misfireThreshold = null;
        }
        if (this.estimatedTimeToReleaseAndAcquireTrigger != null) {
            this.clusteredJobStore.setEstimatedTimeToReleaseAndAcquireTrigger(this.estimatedTimeToReleaseAndAcquireTrigger);
            this.estimatedTimeToReleaseAndAcquireTrigger = null;
        }
        this.clusteredJobStore.setInstanceId(this.schedInstanceId);
        this.clusteredJobStore.setTcRetryInterval(this.tcRetryInterval);
        this.clusteredJobStore.initialize(classLoadHelper, schedulerSignaler);
        this.scheduleUpdateCheck();
    }

    @Override
    public void pauseAll() throws JobPersistenceException {
        this.clusteredJobStore.pauseAll();
    }

    @Override
    public void pauseJob(JobKey jobKey) throws JobPersistenceException {
        this.clusteredJobStore.pauseJob(jobKey);
    }

    @Override
    public Collection<String> pauseJobs(GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        return this.clusteredJobStore.pauseJobs(groupMatcher);
    }

    @Override
    public void pauseTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        this.clusteredJobStore.pauseTrigger(triggerKey);
    }

    @Override
    public Collection<String> pauseTriggers(GroupMatcher<TriggerKey> groupMatcher) throws JobPersistenceException {
        return this.clusteredJobStore.pauseTriggers(groupMatcher);
    }

    @Override
    public void releaseAcquiredTrigger(OperableTrigger operableTrigger) {
        this.clusteredJobStore.releaseAcquiredTrigger(operableTrigger);
    }

    @Override
    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> list) throws JobPersistenceException {
        return this.clusteredJobStore.triggersFired(list);
    }

    @Override
    public boolean removeCalendar(String string) throws JobPersistenceException {
        return this.clusteredJobStore.removeCalendar(string);
    }

    @Override
    public boolean removeJob(JobKey jobKey) throws JobPersistenceException {
        return this.clusteredJobStore.removeJob(jobKey);
    }

    @Override
    public boolean removeTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        return this.clusteredJobStore.removeTrigger(triggerKey);
    }

    @Override
    public boolean removeJobs(List<JobKey> list) throws JobPersistenceException {
        return this.clusteredJobStore.removeJobs(list);
    }

    @Override
    public boolean removeTriggers(List<TriggerKey> list) throws JobPersistenceException {
        return this.clusteredJobStore.removeTriggers(list);
    }

    @Override
    public void storeJobsAndTriggers(Map<JobDetail, Set<? extends Trigger>> map, boolean bl) throws JobPersistenceException {
        this.clusteredJobStore.storeJobsAndTriggers(map, bl);
    }

    @Override
    public boolean replaceTrigger(TriggerKey triggerKey, OperableTrigger operableTrigger) throws JobPersistenceException {
        return this.clusteredJobStore.replaceTrigger(triggerKey, operableTrigger);
    }

    @Override
    public void resumeAll() throws JobPersistenceException {
        this.clusteredJobStore.resumeAll();
    }

    @Override
    public void resumeJob(JobKey jobKey) throws JobPersistenceException {
        this.clusteredJobStore.resumeJob(jobKey);
    }

    @Override
    public Collection<String> resumeJobs(GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        return this.clusteredJobStore.resumeJobs(groupMatcher);
    }

    @Override
    public void resumeTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        this.clusteredJobStore.resumeTrigger(triggerKey);
    }

    @Override
    public Collection<String> resumeTriggers(GroupMatcher<TriggerKey> groupMatcher) throws JobPersistenceException {
        return this.clusteredJobStore.resumeTriggers(groupMatcher);
    }

    @Override
    public Calendar retrieveCalendar(String string) throws JobPersistenceException {
        return this.clusteredJobStore.retrieveCalendar(string);
    }

    @Override
    public JobDetail retrieveJob(JobKey jobKey) throws JobPersistenceException {
        return this.clusteredJobStore.retrieveJob(jobKey);
    }

    @Override
    public OperableTrigger retrieveTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        return this.clusteredJobStore.retrieveTrigger(triggerKey);
    }

    @Override
    public boolean checkExists(JobKey jobKey) throws JobPersistenceException {
        return this.clusteredJobStore.checkExists(jobKey);
    }

    @Override
    public boolean checkExists(TriggerKey triggerKey) throws JobPersistenceException {
        return this.clusteredJobStore.checkExists(triggerKey);
    }

    @Override
    public void clearAllSchedulingData() throws JobPersistenceException {
        this.clusteredJobStore.clearAllSchedulingData();
    }

    @Override
    public void schedulerStarted() throws SchedulerException {
        this.clusteredJobStore.schedulerStarted();
    }

    @Override
    public void schedulerPaused() {
        if (this.clusteredJobStore != null) {
            this.clusteredJobStore.schedulerPaused();
        }
    }

    @Override
    public void schedulerResumed() {
        this.clusteredJobStore.schedulerResumed();
    }

    @Override
    public void shutdown() {
        if (this.clusteredJobStore != null) {
            this.clusteredJobStore.shutdown();
        }
        if (this.updateCheckTimer != null) {
            this.updateCheckTimer.cancel();
        }
    }

    @Override
    public void storeCalendar(String string, Calendar calendar, boolean bl, boolean bl2) throws JobPersistenceException {
        this.clusteredJobStore.storeCalendar(string, calendar, bl, bl2);
    }

    @Override
    public void storeJob(JobDetail jobDetail, boolean bl) throws JobPersistenceException {
        this.clusteredJobStore.storeJob(jobDetail, bl);
    }

    @Override
    public void storeJobAndTrigger(JobDetail jobDetail, OperableTrigger operableTrigger) throws JobPersistenceException {
        this.clusteredJobStore.storeJobAndTrigger(jobDetail, operableTrigger);
    }

    @Override
    public void storeTrigger(OperableTrigger operableTrigger, boolean bl) throws JobPersistenceException {
        this.clusteredJobStore.storeTrigger(operableTrigger, bl);
    }

    @Override
    public boolean supportsPersistence() {
        return true;
    }

    public String toString() {
        return this.clusteredJobStore.toString();
    }

    @Override
    public void triggeredJobComplete(OperableTrigger operableTrigger, JobDetail jobDetail, Trigger.CompletedExecutionInstruction completedExecutionInstruction) {
        this.clusteredJobStore.triggeredJobComplete(operableTrigger, jobDetail, completedExecutionInstruction);
    }

    @Override
    public synchronized void setMisfireThreshold(long l) {
        T t = this.clusteredJobStore;
        if (t != null) {
            t.setMisfireThreshold(l);
        } else {
            this.misfireThreshold = l;
        }
    }

    @Override
    public synchronized void setEstimatedTimeToReleaseAndAcquireTrigger(long l) {
        T t = this.clusteredJobStore;
        if (t != null) {
            t.setEstimatedTimeToReleaseAndAcquireTrigger(l);
        } else {
            this.estimatedTimeToReleaseAndAcquireTrigger = l;
        }
    }

    @Override
    public void setInstanceId(String string) {
        this.schedInstanceId = string;
    }

    @Override
    public void setInstanceName(String string) {
        this.schedName = string;
    }

    @Override
    public void setTcRetryInterval(long l) {
        this.tcRetryInterval = l;
    }

    @Override
    public String getUUID() {
        return this.toolkit.getClientUUID();
    }

    protected T createNewJobStoreInstance(String string, boolean bl) {
        return (T)new DefaultClusteredJobStore(bl, (Toolkit)this.toolkit, string);
    }

    private void scheduleUpdateCheck() {
        if (!Boolean.getBoolean("org.terracotta.quartz.skipUpdateCheck")) {
            this.updateCheckTimer = new Timer("Update Checker", true);
            this.updateCheckTimer.scheduleAtFixedRate((TimerTask)new UpdateChecker(), 100L, 604800000L);
        }
    }

    @Override
    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return this.clusteredJobStore.getEstimatedTimeToReleaseAndAcquireTrigger();
    }

    @Override
    public boolean isClustered() {
        return true;
    }

    protected T getClusteredJobStore() {
        return this.clusteredJobStore;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void jobToBeExecuted(JobExecutionContext jobExecutionContext) {
    }

    @Override
    public void jobExecutionVetoed(JobExecutionContext jobExecutionContext) {
    }

    @Override
    public void jobWasExecuted(JobExecutionContext jobExecutionContext, JobExecutionException jobExecutionException) {
    }
}

