/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.resources;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceManager {
    private static Hashtable m_resources = new Hashtable();
    private int m_refreshCounter;
    private static int m_staticRefreshCounter = 0;
    private ResourceBundle m_bundle;
    private String m_bundleName;

    private ResourceManager(String string) {
        String string2 = this.getClass().getName();
        int n = string2.lastIndexOf(46);
        this.m_bundleName = n > 0 ? string2.substring(0, n + 1) : "";
        this.m_bundleName = this.m_bundleName + string;
        this.refreshBundle();
    }

    private void refreshBundle() {
        try {
            this.m_bundle = ResourceBundle.getBundle(this.m_bundleName);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println(missingResourceException);
        }
        this.m_refreshCounter = m_staticRefreshCounter;
    }

    public static ResourceManager getResourceManager() {
        return ResourceManager.getResourceManager(null);
    }

    public static synchronized ResourceManager getResourceManager(String string) {
        ResourceManager resourceManager;
        if (string == null) {
            string = "resource";
        }
        if ((resourceManager = (ResourceManager)m_resources.get(string)) == null) {
            resourceManager = new ResourceManager(string);
            m_resources.put(string, resourceManager);
        }
        return resourceManager;
    }

    public static synchronized void refresh() {
        m_resources = new Hashtable();
        ++m_staticRefreshCounter;
    }

    private String getString(String string) {
        String string2;
        ResourceManager resourceManager = this;
        synchronized (resourceManager) {
            if (this.m_refreshCounter != m_staticRefreshCounter) {
                this.refreshBundle();
            }
        }
        if (this.m_bundle == null) {
            string2 = string;
        } else {
            try {
                string2 = this.m_bundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = string;
                System.out.println(string + " is missing from resource bundle \"" + this.m_bundleName + "\"");
            }
        }
        return string2;
    }

    public String format(String string) {
        return this.getString(string);
    }

    public String format(String string, Object object) {
        return MessageFormat.format(this.getString(string), object);
    }

    public String format(String string, Object object, Object object2) {
        return MessageFormat.format(this.getString(string), object, object2);
    }

    public String format(String string, Object object, Object object2, Object object3) {
        return MessageFormat.format(this.getString(string), object, object2, object3);
    }

    public String format(String string, Object object, Object object2, Object object3, Object object4) {
        return MessageFormat.format(this.getString(string), object, object2, object3, object4);
    }
}

