/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.Actions;
import org.squirrelframework.foundation.fsm.StateMachine;

public class ActionsImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements Actions<T, S, E, C> {
    private final List<Action<T, S, E, C>> actions = Lists.newArrayList();
    private List<Action<T, S, E, C>> sortedActions;

    @Override
    public void add(Action<T, S, E, C> action) {
        if (action != null && !this.actions.contains(action)) {
            this.actions.add(action);
        }
    }

    @Override
    public void addAll(List<? extends Action<T, S, E, C>> list) {
        if (list != null && !list.isEmpty()) {
            for (Action<T, S, E, C> action : list) {
                if (action == null) continue;
                this.add(action);
            }
        }
    }

    @Override
    public List<Action<T, S, E, C>> getAll() {
        return this.getSortedAction();
    }

    private List<Action<T, S, E, C>> getSortedAction() {
        if (this.actions.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.sortedActions == null) {
            this.sortedActions = Lists.newArrayList(this.actions);
            Collections.sort(this.sortedActions, new Comparator<Action<T, S, E, C>>(){

                @Override
                public int compare(Action<T, S, E, C> action, Action<T, S, E, C> action2) {
                    return action2.weight() - action.weight();
                }
            });
            this.sortedActions = Collections.unmodifiableList(this.sortedActions);
        }
        return this.sortedActions;
    }

    @Override
    public void clear() {
        this.actions.clear();
        this.sortedActions = null;
    }
}

