/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import java.io.Serializable;
import org.quartz.utils.DirtyFlagMap;

public class StringKeyDirtyFlagMap
extends DirtyFlagMap<String, Object> {
    static final long serialVersionUID = -9076749120524952280L;
    private boolean allowsTransientData = false;

    public StringKeyDirtyFlagMap() {
    }

    public StringKeyDirtyFlagMap(int n) {
        super(n);
    }

    public StringKeyDirtyFlagMap(int n, float f) {
        super(n, f);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return ((Object)this.getWrappedMap()).hashCode();
    }

    public String[] getKeys() {
        return this.keySet().toArray(new String[this.size()]);
    }

    public void setAllowsTransientData(boolean bl) {
        if (this.containsTransientData() && !bl) {
            throw new IllegalStateException("Cannot set property 'allowsTransientData' to 'false' when data map contains non-serializable objects.");
        }
        this.allowsTransientData = bl;
    }

    public boolean getAllowsTransientData() {
        return this.allowsTransientData;
    }

    public boolean containsTransientData() {
        if (!this.getAllowsTransientData()) {
            return false;
        }
        String[] stringArray = this.getKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            Object v = super.get(stringArray[i]);
            if (v instanceof Serializable) continue;
            return true;
        }
        return false;
    }

    public void removeTransientData() {
        if (!this.getAllowsTransientData()) {
            return;
        }
        String[] stringArray = this.getKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            Object v = super.get(stringArray[i]);
            if (v instanceof Serializable) continue;
            this.remove(stringArray[i]);
        }
    }

    @Override
    public void put(String string, int n) {
        super.put(string, n);
    }

    @Override
    public void put(String string, long l) {
        super.put(string, l);
    }

    @Override
    public void put(String string, float f) {
        super.put(string, Float.valueOf(f));
    }

    @Override
    public void put(String string, double d) {
        super.put(string, d);
    }

    @Override
    public void put(String string, boolean bl) {
        super.put(string, bl);
    }

    @Override
    public void put(String string, char c) {
        super.put(string, Character.valueOf(c));
    }

    @Override
    public void put(String string, String string2) {
        super.put(string, string2);
    }

    @Override
    public Object put(String string, Object object) {
        return super.put(string, object);
    }

    public int getInt(String string) {
        Object v = this.get(string);
        try {
            if (v instanceof Integer) {
                return (Integer)v;
            }
            return Integer.parseInt((String)v);
        }
        catch (Exception exception) {
            throw new ClassCastException("Identified object is not an Integer.");
        }
    }

    public long getLong(String string) {
        Object v = this.get(string);
        try {
            if (v instanceof Long) {
                return (Long)v;
            }
            return Long.parseLong((String)v);
        }
        catch (Exception exception) {
            throw new ClassCastException("Identified object is not a Long.");
        }
    }

    public float getFloat(String string) {
        Object v = this.get(string);
        try {
            if (v instanceof Float) {
                return ((Float)v).floatValue();
            }
            return Float.parseFloat((String)v);
        }
        catch (Exception exception) {
            throw new ClassCastException("Identified object is not a Float.");
        }
    }

    public double getDouble(String string) {
        Object v = this.get(string);
        try {
            if (v instanceof Double) {
                return (Double)v;
            }
            return Double.parseDouble((String)v);
        }
        catch (Exception exception) {
            throw new ClassCastException("Identified object is not a Double.");
        }
    }

    public boolean getBoolean(String string) {
        Object v = this.get(string);
        try {
            if (v instanceof Boolean) {
                return (Boolean)v;
            }
            return Boolean.parseBoolean((String)v);
        }
        catch (Exception exception) {
            throw new ClassCastException("Identified object is not a Boolean.");
        }
    }

    public char getChar(String string) {
        Object v = this.get(string);
        try {
            if (v instanceof Character) {
                return ((Character)v).charValue();
            }
            return ((String)v).charAt(0);
        }
        catch (Exception exception) {
            throw new ClassCastException("Identified object is not a Character.");
        }
    }

    public String getString(String string) {
        Object v = this.get(string);
        try {
            return (String)v;
        }
        catch (Exception exception) {
            throw new ClassCastException("Identified object is not a String.");
        }
    }
}

