/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.mail;

import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMailJob
implements Job {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String PROP_SMTP_HOST = "smtp_host";
    public static final String PROP_RECIPIENT = "recipient";
    public static final String PROP_CC_RECIPIENT = "cc_recipient";
    public static final String PROP_SENDER = "sender";
    public static final String PROP_REPLY_TO = "reply_to";
    public static final String PROP_SUBJECT = "subject";
    public static final String PROP_MESSAGE = "message";
    public static final String PROP_CONTENT_TYPE = "content_type";
    public static final String PROP_USERNAME = "username";
    public static final String PROP_PASSWORD = "password";

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
        MailInfo mailInfo = this.populateMailInfo(jobDataMap, this.createMailInfo());
        this.getLog().info("Sending message " + mailInfo);
        try {
            MimeMessage mimeMessage = this.prepareMimeMessage(mailInfo);
            Transport.send((Message)mimeMessage);
        }
        catch (MessagingException messagingException) {
            throw new JobExecutionException("Unable to send mail: " + mailInfo, messagingException, false);
        }
    }

    protected Logger getLog() {
        return this.log;
    }

    protected MimeMessage prepareMimeMessage(MailInfo mailInfo) throws MessagingException {
        Session session = this.getMailSession(mailInfo);
        MimeMessage mimeMessage = new MimeMessage(session);
        InternetAddress[] internetAddressArray = InternetAddress.parse((String)mailInfo.getTo());
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])internetAddressArray);
        if (mailInfo.getCc() != null) {
            InternetAddress[] internetAddressArray2 = InternetAddress.parse((String)mailInfo.getCc());
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])internetAddressArray2);
        }
        mimeMessage.setFrom((Address)new InternetAddress(mailInfo.getFrom()));
        if (mailInfo.getReplyTo() != null) {
            mimeMessage.setReplyTo((Address[])new InternetAddress[]{new InternetAddress(mailInfo.getReplyTo())});
        }
        mimeMessage.setSubject(mailInfo.getSubject());
        mimeMessage.setSentDate(new Date());
        this.setMimeMessageContent(mimeMessage, mailInfo);
        return mimeMessage;
    }

    protected void setMimeMessageContent(MimeMessage mimeMessage, MailInfo mailInfo) throws MessagingException {
        if (mailInfo.getContentType() == null) {
            mimeMessage.setText(mailInfo.getMessage());
        } else {
            mimeMessage.setContent((Object)mailInfo.getMessage(), mailInfo.getContentType());
        }
    }

    protected Session getMailSession(final MailInfo mailInfo) throws MessagingException {
        Properties properties = new Properties();
        properties.put("mail.smtp.host", mailInfo.getSmtpHost());
        Properties properties2 = mailInfo.getSmtpProperties();
        if (properties2 != null) {
            properties.putAll((Map<?, ?>)properties2);
        }
        Authenticator authenticator = null;
        if (mailInfo.getUsername() != null && mailInfo.getPassword() != null) {
            this.log.info("using username '{}' and password 'xxx'", (Object)mailInfo.getUsername());
            authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(mailInfo.getUsername(), mailInfo.getPassword());
                }
            };
        }
        this.log.debug("Sending mail with properties: {}", (Object)properties);
        return Session.getDefaultInstance((Properties)properties, authenticator);
    }

    protected MailInfo createMailInfo() {
        return new MailInfo();
    }

    protected MailInfo populateMailInfo(JobDataMap jobDataMap, MailInfo mailInfo) {
        mailInfo.setSmtpHost(this.getRequiredParm(jobDataMap, PROP_SMTP_HOST, "PROP_SMTP_HOST"));
        mailInfo.setTo(this.getRequiredParm(jobDataMap, PROP_RECIPIENT, "PROP_RECIPIENT"));
        mailInfo.setFrom(this.getRequiredParm(jobDataMap, PROP_SENDER, "PROP_SENDER"));
        mailInfo.setSubject(this.getRequiredParm(jobDataMap, PROP_SUBJECT, "PROP_SUBJECT"));
        mailInfo.setMessage(this.getRequiredParm(jobDataMap, PROP_MESSAGE, "PROP_MESSAGE"));
        mailInfo.setReplyTo(this.getOptionalParm(jobDataMap, PROP_REPLY_TO));
        mailInfo.setCc(this.getOptionalParm(jobDataMap, PROP_CC_RECIPIENT));
        mailInfo.setContentType(this.getOptionalParm(jobDataMap, PROP_CONTENT_TYPE));
        mailInfo.setUsername(this.getOptionalParm(jobDataMap, PROP_USERNAME));
        mailInfo.setPassword(this.getOptionalParm(jobDataMap, PROP_PASSWORD));
        Properties properties = new Properties();
        for (String string : jobDataMap.keySet()) {
            if (!string.startsWith("mail.smtp.")) continue;
            properties.put(string, jobDataMap.getString(string));
        }
        if (mailInfo.getSmtpProperties() == null) {
            mailInfo.setSmtpProperties(properties);
        } else {
            mailInfo.getSmtpProperties().putAll((Map<?, ?>)properties);
        }
        return mailInfo;
    }

    protected String getRequiredParm(JobDataMap jobDataMap, String string, String string2) {
        String string3 = this.getOptionalParm(jobDataMap, string);
        if (string3 == null) {
            throw new IllegalArgumentException(string2 + " not specified.");
        }
        return string3;
    }

    protected String getOptionalParm(JobDataMap jobDataMap, String string) {
        String string2 = jobDataMap.getString(string);
        if (string2 != null && string2.trim().length() == 0) {
            return null;
        }
        return string2;
    }

    protected static class MailInfo {
        private String smtpHost;
        private String to;
        private String from;
        private String subject;
        private String message;
        private String replyTo;
        private String cc;
        private String contentType;
        private String username;
        private String password;
        private Properties smtpProperties;

        protected MailInfo() {
        }

        public String toString() {
            return "'" + this.getSubject() + "' to: " + this.getTo();
        }

        public String getCc() {
            return this.cc;
        }

        public void setCc(String string) {
            this.cc = string;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String string) {
            this.contentType = string;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String string) {
            this.from = string;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String string) {
            this.message = string;
        }

        public String getReplyTo() {
            return this.replyTo;
        }

        public void setReplyTo(String string) {
            this.replyTo = string;
        }

        public String getSmtpHost() {
            return this.smtpHost;
        }

        public void setSmtpHost(String string) {
            this.smtpHost = string;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String string) {
            this.subject = string;
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String string) {
            this.to = string;
        }

        public Properties getSmtpProperties() {
            return this.smtpProperties;
        }

        public void setSmtpProperties(Properties properties) {
            this.smtpProperties = properties;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String string) {
            this.username = string;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String string) {
            this.password = string;
        }
    }
}

