/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.quartz.JobDetail;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.TriggerKey;
import org.quartz.impl.jdbcjobstore.StdJDBCConstants;
import org.quartz.impl.jdbcjobstore.TriggerPersistenceDelegate;
import org.quartz.impl.jdbcjobstore.Util;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class SimpleTriggerPersistenceDelegate
implements TriggerPersistenceDelegate,
StdJDBCConstants {
    protected String tablePrefix;
    protected String schedNameLiteral;

    @Override
    public void initialize(String string, String string2) {
        this.tablePrefix = string;
        this.schedNameLiteral = "'" + string2 + "'";
    }

    @Override
    public String getHandledTriggerTypeDiscriminator() {
        return "SIMPLE";
    }

    @Override
    public boolean canHandleTriggerType(OperableTrigger operableTrigger) {
        return operableTrigger instanceof SimpleTriggerImpl && !((SimpleTriggerImpl)operableTrigger).hasAdditionalProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteExtendedTriggerProperties(Connection connection, TriggerKey triggerKey) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(Util.rtp("DELETE FROM {0}SIMPLE_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
            preparedStatement.setString(1, triggerKey.getName());
            preparedStatement.setString(2, triggerKey.getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            Util.closeStatement(preparedStatement);
            throw throwable;
        }
        Util.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insertExtendedTriggerProperties(Connection connection, OperableTrigger operableTrigger, String string, JobDetail jobDetail) throws SQLException, IOException {
        int n;
        SimpleTrigger simpleTrigger = (SimpleTrigger)((Object)operableTrigger);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(Util.rtp("INSERT INTO {0}SIMPLE_TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, REPEAT_COUNT, REPEAT_INTERVAL, TIMES_TRIGGERED)  VALUES({1}, ?, ?, ?, ?, ?)", this.tablePrefix, this.schedNameLiteral));
            preparedStatement.setString(1, operableTrigger.getKey().getName());
            preparedStatement.setString(2, operableTrigger.getKey().getGroup());
            preparedStatement.setInt(3, simpleTrigger.getRepeatCount());
            preparedStatement.setBigDecimal(4, new BigDecimal(String.valueOf(simpleTrigger.getRepeatInterval())));
            preparedStatement.setInt(5, simpleTrigger.getTimesTriggered());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            Util.closeStatement(preparedStatement);
            throw throwable;
        }
        Util.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public TriggerPersistenceDelegate.TriggerPropertyBundle loadExtendedTriggerProperties(Connection connection, TriggerKey triggerKey) throws SQLException {
        block3: {
            TriggerPersistenceDelegate.TriggerPropertyBundle triggerPropertyBundle;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(Util.rtp("SELECT * FROM {0}SIMPLE_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
                preparedStatement.setString(1, triggerKey.getName());
                preparedStatement.setString(2, triggerKey.getGroup());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block3;
                int n = resultSet.getInt("REPEAT_COUNT");
                long l = resultSet.getLong("REPEAT_INTERVAL");
                int n2 = resultSet.getInt("TIMES_TRIGGERED");
                SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withRepeatCount(n).withIntervalInMilliseconds(l);
                String[] stringArray = new String[]{"timesTriggered"};
                Object[] objectArray = new Object[]{n2};
                triggerPropertyBundle = new TriggerPersistenceDelegate.TriggerPropertyBundle(simpleScheduleBuilder, stringArray, objectArray);
            }
            catch (Throwable throwable) {
                Util.closeResultSet(resultSet);
                Util.closeStatement(preparedStatement);
                throw throwable;
            }
            Util.closeResultSet(resultSet);
            Util.closeStatement(preparedStatement);
            return triggerPropertyBundle;
        }
        throw new IllegalStateException("No record found for selection of Trigger with key: '" + triggerKey + "' and statement: " + Util.rtp("SELECT * FROM {0}SIMPLE_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateExtendedTriggerProperties(Connection connection, OperableTrigger operableTrigger, String string, JobDetail jobDetail) throws SQLException, IOException {
        int n;
        SimpleTrigger simpleTrigger = (SimpleTrigger)((Object)operableTrigger);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(Util.rtp("UPDATE {0}SIMPLE_TRIGGERS SET REPEAT_COUNT = ?, REPEAT_INTERVAL = ?, TIMES_TRIGGERED = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
            preparedStatement.setInt(1, simpleTrigger.getRepeatCount());
            preparedStatement.setBigDecimal(2, new BigDecimal(String.valueOf(simpleTrigger.getRepeatInterval())));
            preparedStatement.setInt(3, simpleTrigger.getTimesTriggered());
            preparedStatement.setString(4, simpleTrigger.getKey().getName());
            preparedStatement.setString(5, simpleTrigger.getKey().getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            Util.closeStatement(preparedStatement);
            throw throwable;
        }
        Util.closeStatement(preparedStatement);
        return n;
    }
}

