/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Matcher;
import org.quartz.Scheduler;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.core.JobRunShellFactory;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.ee.jta.JTAAnnotationAwareJobRunShellFactory;
import org.quartz.ee.jta.JTAJobRunShellFactory;
import org.quartz.ee.jta.UserTransactionHelper;
import org.quartz.impl.DefaultThreadExecutor;
import org.quartz.impl.RemoteMBeanScheduler;
import org.quartz.impl.RemoteScheduler;
import org.quartz.impl.SchedulerDetailsSetter;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.StdScheduler;
import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.quartz.impl.jdbcjobstore.Semaphore;
import org.quartz.impl.jdbcjobstore.TablePrefixAware;
import org.quartz.impl.matchers.EverythingMatcher;
import org.quartz.management.ManagementRESTServiceConfiguration;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.InstanceIdGenerator;
import org.quartz.spi.JobFactory;
import org.quartz.spi.JobStore;
import org.quartz.spi.SchedulerPlugin;
import org.quartz.spi.ThreadExecutor;
import org.quartz.spi.ThreadPool;
import org.quartz.utils.ConnectionProvider;
import org.quartz.utils.DBConnectionManager;
import org.quartz.utils.JNDIConnectionProvider;
import org.quartz.utils.PoolingConnectionProvider;
import org.quartz.utils.PropertiesParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdSchedulerFactory
implements SchedulerFactory {
    public static final String PROPERTIES_FILE = "org.quartz.properties";
    public static final String PROP_SCHED_INSTANCE_NAME = "org.quartz.scheduler.instanceName";
    public static final String PROP_SCHED_INSTANCE_ID = "org.quartz.scheduler.instanceId";
    public static final String PROP_SCHED_INSTANCE_ID_GENERATOR_PREFIX = "org.quartz.scheduler.instanceIdGenerator";
    public static final String PROP_SCHED_INSTANCE_ID_GENERATOR_CLASS = "org.quartz.scheduler.instanceIdGenerator.class";
    public static final String PROP_SCHED_THREAD_NAME = "org.quartz.scheduler.threadName";
    public static final String PROP_SCHED_SKIP_UPDATE_CHECK = "org.quartz.scheduler.skipUpdateCheck";
    public static final String PROP_SCHED_BATCH_TIME_WINDOW = "org.quartz.scheduler.batchTriggerAcquisitionFireAheadTimeWindow";
    public static final String PROP_SCHED_MAX_BATCH_SIZE = "org.quartz.scheduler.batchTriggerAcquisitionMaxCount";
    public static final String PROP_SCHED_JMX_EXPORT = "org.quartz.scheduler.jmx.export";
    public static final String PROP_SCHED_JMX_OBJECT_NAME = "org.quartz.scheduler.jmx.objectName";
    public static final String PROP_SCHED_JMX_PROXY = "org.quartz.scheduler.jmx.proxy";
    public static final String PROP_SCHED_JMX_PROXY_CLASS = "org.quartz.scheduler.jmx.proxy.class";
    public static final String PROP_SCHED_RMI_EXPORT = "org.quartz.scheduler.rmi.export";
    public static final String PROP_SCHED_RMI_PROXY = "org.quartz.scheduler.rmi.proxy";
    public static final String PROP_SCHED_RMI_HOST = "org.quartz.scheduler.rmi.registryHost";
    public static final String PROP_SCHED_RMI_PORT = "org.quartz.scheduler.rmi.registryPort";
    public static final String PROP_SCHED_RMI_SERVER_PORT = "org.quartz.scheduler.rmi.serverPort";
    public static final String PROP_SCHED_RMI_CREATE_REGISTRY = "org.quartz.scheduler.rmi.createRegistry";
    public static final String PROP_SCHED_RMI_BIND_NAME = "org.quartz.scheduler.rmi.bindName";
    public static final String PROP_SCHED_WRAP_JOB_IN_USER_TX = "org.quartz.scheduler.wrapJobExecutionInUserTransaction";
    public static final String PROP_SCHED_USER_TX_URL = "org.quartz.scheduler.userTransactionURL";
    public static final String PROP_SCHED_IDLE_WAIT_TIME = "org.quartz.scheduler.idleWaitTime";
    public static final String PROP_SCHED_DB_FAILURE_RETRY_INTERVAL = "org.quartz.scheduler.dbFailureRetryInterval";
    public static final String PROP_SCHED_MAKE_SCHEDULER_THREAD_DAEMON = "org.quartz.scheduler.makeSchedulerThreadDaemon";
    public static final String PROP_SCHED_SCHEDULER_THREADS_INHERIT_CONTEXT_CLASS_LOADER_OF_INITIALIZING_THREAD = "org.quartz.scheduler.threadsInheritContextClassLoaderOfInitializer";
    public static final String PROP_SCHED_CLASS_LOAD_HELPER_CLASS = "org.quartz.scheduler.classLoadHelper.class";
    public static final String PROP_SCHED_JOB_FACTORY_CLASS = "org.quartz.scheduler.jobFactory.class";
    public static final String PROP_SCHED_JOB_FACTORY_PREFIX = "org.quartz.scheduler.jobFactory";
    public static final String PROP_SCHED_INTERRUPT_JOBS_ON_SHUTDOWN = "org.quartz.scheduler.interruptJobsOnShutdown";
    public static final String PROP_SCHED_INTERRUPT_JOBS_ON_SHUTDOWN_WITH_WAIT = "org.quartz.scheduler.interruptJobsOnShutdownWithWait";
    public static final String PROP_SCHED_CONTEXT_PREFIX = "org.quartz.context.key";
    public static final String PROP_THREAD_POOL_PREFIX = "org.quartz.threadPool";
    public static final String PROP_THREAD_POOL_CLASS = "org.quartz.threadPool.class";
    public static final String PROP_JOB_STORE_PREFIX = "org.quartz.jobStore";
    public static final String PROP_JOB_STORE_LOCK_HANDLER_PREFIX = "org.quartz.jobStore.lockHandler";
    public static final String PROP_JOB_STORE_LOCK_HANDLER_CLASS = "org.quartz.jobStore.lockHandler.class";
    public static final String PROP_TABLE_PREFIX = "tablePrefix";
    public static final String PROP_SCHED_NAME = "schedName";
    public static final String PROP_JOB_STORE_CLASS = "org.quartz.jobStore.class";
    public static final String PROP_JOB_STORE_USE_PROP = "org.quartz.jobStore.useProperties";
    public static final String PROP_DATASOURCE_PREFIX = "org.quartz.dataSource";
    public static final String PROP_CONNECTION_PROVIDER_CLASS = "connectionProvider.class";
    @Deprecated
    public static final String PROP_DATASOURCE_DRIVER = "driver";
    @Deprecated
    public static final String PROP_DATASOURCE_URL = "URL";
    @Deprecated
    public static final String PROP_DATASOURCE_USER = "user";
    @Deprecated
    public static final String PROP_DATASOURCE_PASSWORD = "password";
    @Deprecated
    public static final String PROP_DATASOURCE_MAX_CONNECTIONS = "maxConnections";
    @Deprecated
    public static final String PROP_DATASOURCE_VALIDATION_QUERY = "validationQuery";
    public static final String PROP_DATASOURCE_JNDI_URL = "jndiURL";
    public static final String PROP_DATASOURCE_JNDI_ALWAYS_LOOKUP = "jndiAlwaysLookup";
    public static final String PROP_DATASOURCE_JNDI_INITIAL = "java.naming.factory.initial";
    public static final String PROP_DATASOURCE_JNDI_PROVDER = "java.naming.provider.url";
    public static final String PROP_DATASOURCE_JNDI_PRINCIPAL = "java.naming.security.principal";
    public static final String PROP_DATASOURCE_JNDI_CREDENTIALS = "java.naming.security.credentials";
    public static final String PROP_PLUGIN_PREFIX = "org.quartz.plugin";
    public static final String PROP_PLUGIN_CLASS = "class";
    public static final String PROP_JOB_LISTENER_PREFIX = "org.quartz.jobListener";
    public static final String PROP_TRIGGER_LISTENER_PREFIX = "org.quartz.triggerListener";
    public static final String PROP_LISTENER_CLASS = "class";
    public static final String DEFAULT_INSTANCE_ID = "NON_CLUSTERED";
    public static final String AUTO_GENERATE_INSTANCE_ID = "AUTO";
    public static final String PROP_THREAD_EXECUTOR = "org.quartz.threadExecutor";
    public static final String PROP_THREAD_EXECUTOR_CLASS = "org.quartz.threadExecutor.class";
    public static final String SYSTEM_PROPERTY_AS_INSTANCE_ID = "SYS_PROP";
    public static final String MANAGEMENT_REST_SERVICE_ENABLED = "org.quartz.managementRESTService.enabled";
    public static final String MANAGEMENT_REST_SERVICE_HOST_PORT = "org.quartz.managementRESTService.bind";
    private SchedulerException initException = null;
    private String propSrc = null;
    private PropertiesParser cfg;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public StdSchedulerFactory() {
    }

    public StdSchedulerFactory(Properties properties) throws SchedulerException {
        this.initialize(properties);
    }

    public StdSchedulerFactory(String string) throws SchedulerException {
        this.initialize(string);
    }

    public Logger getLog() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws SchedulerException {
        Properties properties;
        block24: {
            if (this.cfg != null) {
                return;
            }
            if (this.initException != null) {
                throw this.initException;
            }
            String string = System.getProperty(PROPERTIES_FILE);
            String string2 = string != null ? string : "quartz.properties";
            File file = new File(string2);
            properties = new Properties();
            InputStream inputStream = null;
            try {
                if (file.exists()) {
                    try {
                        this.propSrc = string != null ? "specified file: '" + string + "'" : "default file in current working dir: 'quartz.properties'";
                        inputStream = new BufferedInputStream(new FileInputStream(string2));
                        properties.load(inputStream);
                        break block24;
                    }
                    catch (IOException iOException) {
                        this.initException = new SchedulerException("Properties file: '" + string2 + "' could not be read.", iOException);
                        throw this.initException;
                    }
                }
                if (string != null) {
                    inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
                    if (inputStream == null) {
                        this.initException = new SchedulerException("Properties file: '" + string + "' could not be found.");
                        throw this.initException;
                    }
                    this.propSrc = "specified file: '" + string + "' in the class resource path.";
                    inputStream = new BufferedInputStream(inputStream);
                    try {
                        properties.load(inputStream);
                        break block24;
                    }
                    catch (IOException iOException) {
                        this.initException = new SchedulerException("Properties file: '" + string + "' could not be read.", iOException);
                        throw this.initException;
                    }
                }
                this.propSrc = "default resource file in Quartz package: 'quartz.properties'";
                ClassLoader classLoader = this.getClass().getClassLoader();
                if (classLoader == null) {
                    classLoader = this.findClassloader();
                }
                if (classLoader == null) {
                    throw new SchedulerConfigException("Unable to find a class loader on the current thread or class.");
                }
                inputStream = classLoader.getResourceAsStream("quartz.properties");
                if (inputStream == null) {
                    inputStream = classLoader.getResourceAsStream("/quartz.properties");
                }
                if (inputStream == null) {
                    inputStream = classLoader.getResourceAsStream("org/quartz/quartz.properties");
                }
                if (inputStream == null) {
                    this.initException = new SchedulerException("Default quartz.properties not found in class path");
                    throw this.initException;
                }
                try {
                    properties.load(inputStream);
                }
                catch (IOException iOException) {
                    this.initException = new SchedulerException("Resource properties file: 'org/quartz/quartz.properties' could not be read from the classpath.", iOException);
                    throw this.initException;
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.initialize(this.overrideWithSysProps(properties));
    }

    private Properties overrideWithSysProps(Properties properties) {
        Properties properties2 = null;
        try {
            properties2 = System.getProperties();
        }
        catch (AccessControlException accessControlException) {
            this.getLog().warn("Skipping overriding quartz properties with System properties during initialization because of an AccessControlException.  This is likely due to not having read/write access for java.util.PropertyPermission as required by java.lang.System.getProperties().  To resolve this warning, either add this permission to your policy file or use a non-default version of initialize().", accessControlException);
        }
        if (properties2 != null) {
            properties.putAll((Map<?, ?>)properties2);
        }
        return properties;
    }

    public void initialize(String string) throws SchedulerException {
        if (this.cfg != null) {
            return;
        }
        if (this.initException != null) {
            throw this.initException;
        }
        InputStream inputStream = null;
        Properties properties = new Properties();
        inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        try {
            if (inputStream != null) {
                inputStream = new BufferedInputStream(inputStream);
                this.propSrc = "the specified file : '" + string + "' from the class resource path.";
            } else {
                inputStream = new BufferedInputStream(new FileInputStream(string));
                this.propSrc = "the specified file : '" + string + "'";
            }
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            this.initException = new SchedulerException("Properties file: '" + string + "' could not be read.", iOException);
            throw this.initException;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.initialize(properties);
    }

    public void initialize(InputStream inputStream) throws SchedulerException {
        if (this.cfg != null) {
            return;
        }
        if (this.initException != null) {
            throw this.initException;
        }
        Properties properties = new Properties();
        if (inputStream != null) {
            try {
                properties.load(inputStream);
                this.propSrc = "an externally opened InputStream.";
            }
            catch (IOException iOException) {
                this.initException = new SchedulerException("Error loading property data from InputStream", iOException);
                throw this.initException;
            }
        } else {
            this.initException = new SchedulerException("Error loading property data from InputStream - InputStream is null.");
            throw this.initException;
        }
        this.initialize(properties);
    }

    public void initialize(Properties properties) throws SchedulerException {
        if (this.propSrc == null) {
            this.propSrc = "an externally provided properties instance.";
        }
        this.cfg = new PropertiesParser(properties);
    }

    private Scheduler instantiate() throws SchedulerException {
        ThreadExecutor threadExecutor;
        Object object;
        int n;
        Object object2;
        Object object3;
        Object object4;
        String string;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        String[] stringArray;
        String string2;
        if (this.cfg == null) {
            this.initialize();
        }
        if (this.initException != null) {
            throw this.initException;
        }
        JobStore jobStore = null;
        ThreadPool threadPool = null;
        QuartzScheduler quartzScheduler = null;
        DBConnectionManager dBConnectionManager = null;
        String string3 = null;
        Properties properties = null;
        String string4 = null;
        boolean bl = false;
        boolean bl2 = false;
        long l = -1L;
        long l2 = 15000L;
        SchedulerRepository schedulerRepository = SchedulerRepository.getInstance();
        String string5 = this.cfg.getStringProperty(PROP_SCHED_INSTANCE_NAME, "QuartzScheduler");
        String string6 = this.cfg.getStringProperty(PROP_SCHED_THREAD_NAME, string5 + "_QuartzSchedulerThread");
        String string7 = this.cfg.getStringProperty(PROP_SCHED_INSTANCE_ID, DEFAULT_INSTANCE_ID);
        if (string7.equals(AUTO_GENERATE_INSTANCE_ID)) {
            bl2 = true;
            string3 = this.cfg.getStringProperty(PROP_SCHED_INSTANCE_ID_GENERATOR_CLASS, "org.quartz.simpl.SimpleInstanceIdGenerator");
        } else if (string7.equals(SYSTEM_PROPERTY_AS_INSTANCE_ID)) {
            bl2 = true;
            string3 = "org.quartz.simpl.SystemPropertyInstanceIdGenerator";
        }
        string4 = this.cfg.getStringProperty(PROP_SCHED_USER_TX_URL, string4);
        if (string4 != null && string4.trim().length() == 0) {
            string4 = null;
        }
        String string8 = this.cfg.getStringProperty(PROP_SCHED_CLASS_LOAD_HELPER_CLASS, "org.quartz.simpl.CascadingClassLoadHelper");
        bl = this.cfg.getBooleanProperty(PROP_SCHED_WRAP_JOB_IN_USER_TX, bl);
        String string9 = this.cfg.getStringProperty(PROP_SCHED_JOB_FACTORY_CLASS, null);
        if ((l = this.cfg.getLongProperty(PROP_SCHED_IDLE_WAIT_TIME, l)) > -1L && l < 1000L) {
            throw new SchedulerException("org.quartz.scheduler.idleWaitTime of less than 1000ms is not legal.");
        }
        if ((l2 = this.cfg.getLongProperty(PROP_SCHED_DB_FAILURE_RETRY_INTERVAL, l2)) < 0L) {
            throw new SchedulerException("org.quartz.scheduler.dbFailureRetryInterval of less than 0 ms is not legal.");
        }
        boolean bl3 = this.cfg.getBooleanProperty(PROP_SCHED_MAKE_SCHEDULER_THREAD_DAEMON);
        boolean bl4 = this.cfg.getBooleanProperty(PROP_SCHED_SCHEDULER_THREADS_INHERIT_CONTEXT_CLASS_LOADER_OF_INITIALIZING_THREAD);
        boolean bl5 = this.cfg.getBooleanProperty(PROP_SCHED_SKIP_UPDATE_CHECK, true);
        long l3 = this.cfg.getLongProperty(PROP_SCHED_BATCH_TIME_WINDOW, 0L);
        int n2 = this.cfg.getIntProperty(PROP_SCHED_MAX_BATCH_SIZE, 1);
        boolean bl6 = this.cfg.getBooleanProperty(PROP_SCHED_INTERRUPT_JOBS_ON_SHUTDOWN, false);
        boolean bl7 = this.cfg.getBooleanProperty(PROP_SCHED_INTERRUPT_JOBS_ON_SHUTDOWN_WITH_WAIT, false);
        boolean bl8 = this.cfg.getBooleanProperty(PROP_SCHED_JMX_EXPORT);
        String string10 = this.cfg.getStringProperty(PROP_SCHED_JMX_OBJECT_NAME);
        boolean bl9 = this.cfg.getBooleanProperty(PROP_SCHED_JMX_PROXY);
        String string11 = this.cfg.getStringProperty(PROP_SCHED_JMX_PROXY_CLASS);
        boolean bl10 = this.cfg.getBooleanProperty(PROP_SCHED_RMI_EXPORT, false);
        boolean bl11 = this.cfg.getBooleanProperty(PROP_SCHED_RMI_PROXY, false);
        String string12 = this.cfg.getStringProperty(PROP_SCHED_RMI_HOST, "localhost");
        int n3 = this.cfg.getIntProperty(PROP_SCHED_RMI_PORT, 1099);
        int n4 = this.cfg.getIntProperty(PROP_SCHED_RMI_SERVER_PORT, -1);
        String string13 = this.cfg.getStringProperty(PROP_SCHED_RMI_CREATE_REGISTRY, "never");
        String string14 = this.cfg.getStringProperty(PROP_SCHED_RMI_BIND_NAME);
        if (bl9 && bl11) {
            throw new SchedulerConfigException("Cannot proxy both RMI and JMX.");
        }
        boolean bl12 = this.cfg.getBooleanProperty(MANAGEMENT_REST_SERVICE_ENABLED, false);
        String string15 = this.cfg.getStringProperty(MANAGEMENT_REST_SERVICE_HOST_PORT, "0.0.0.0:9889");
        Properties properties2 = this.cfg.getPropertyGroup(PROP_SCHED_CONTEXT_PREFIX, true);
        if (bl11) {
            if (bl2) {
                string7 = DEFAULT_INSTANCE_ID;
            }
            String string16 = string14 == null ? QuartzSchedulerResources.getUniqueIdentifier(string5, string7) : string14;
            RemoteScheduler remoteScheduler = new RemoteScheduler(string16, string12, n3);
            schedulerRepository.bind(remoteScheduler);
            return remoteScheduler;
        }
        ClassLoadHelper classLoadHelper = null;
        try {
            classLoadHelper = (ClassLoadHelper)this.loadClass(string8).newInstance();
        }
        catch (Exception exception) {
            throw new SchedulerConfigException("Unable to instantiate class load helper class: " + exception.getMessage(), exception);
        }
        classLoadHelper.initialize();
        if (bl9) {
            if (bl2) {
                string7 = DEFAULT_INSTANCE_ID;
            }
            if (string11 == null) {
                throw new SchedulerConfigException("No JMX Proxy Scheduler class provided");
            }
            RemoteMBeanScheduler remoteMBeanScheduler = null;
            try {
                remoteMBeanScheduler = (RemoteMBeanScheduler)classLoadHelper.loadClass(string11).newInstance();
            }
            catch (Exception exception) {
                throw new SchedulerConfigException("Unable to instantiate RemoteMBeanScheduler class.", exception);
            }
            if (string10 == null) {
                string10 = QuartzSchedulerResources.generateJMXObjectName(string5, string7);
            }
            remoteMBeanScheduler.setSchedulerObjectName(string10);
            properties = this.cfg.getPropertyGroup(PROP_SCHED_JMX_PROXY, true);
            try {
                this.setBeanProps(remoteMBeanScheduler, properties);
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("RemoteMBeanScheduler class '" + string11 + "' props could not be configured.", exception);
                throw this.initException;
            }
            remoteMBeanScheduler.initialize();
            schedulerRepository.bind(remoteMBeanScheduler);
            return remoteMBeanScheduler;
        }
        JobFactory jobFactory = null;
        if (string9 != null) {
            try {
                jobFactory = (JobFactory)classLoadHelper.loadClass(string9).newInstance();
            }
            catch (Exception exception) {
                throw new SchedulerConfigException("Unable to instantiate JobFactory class: " + exception.getMessage(), exception);
            }
            properties = this.cfg.getPropertyGroup(PROP_SCHED_JOB_FACTORY_PREFIX, true);
            try {
                this.setBeanProps(jobFactory, properties);
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("JobFactory class '" + string9 + "' props could not be configured.", exception);
                throw this.initException;
            }
        }
        InstanceIdGenerator instanceIdGenerator = null;
        if (string3 != null) {
            try {
                instanceIdGenerator = (InstanceIdGenerator)classLoadHelper.loadClass(string3).newInstance();
            }
            catch (Exception exception) {
                throw new SchedulerConfigException("Unable to instantiate InstanceIdGenerator class: " + exception.getMessage(), exception);
            }
            properties = this.cfg.getPropertyGroup(PROP_SCHED_INSTANCE_ID_GENERATOR_PREFIX, true);
            try {
                this.setBeanProps(instanceIdGenerator, properties);
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("InstanceIdGenerator class '" + string3 + "' props could not be configured.", exception);
                throw this.initException;
            }
        }
        if ((string2 = this.cfg.getStringProperty(PROP_THREAD_POOL_CLASS, SimpleThreadPool.class.getName())) == null) {
            this.initException = new SchedulerException("ThreadPool class not specified. ");
            throw this.initException;
        }
        try {
            threadPool = (ThreadPool)classLoadHelper.loadClass(string2).newInstance();
        }
        catch (Exception exception) {
            this.initException = new SchedulerException("ThreadPool class '" + string2 + "' could not be instantiated.", exception);
            throw this.initException;
        }
        properties = this.cfg.getPropertyGroup(PROP_THREAD_POOL_PREFIX, true);
        try {
            this.setBeanProps(threadPool, properties);
        }
        catch (Exception exception) {
            this.initException = new SchedulerException("ThreadPool class '" + string2 + "' props could not be configured.", exception);
            throw this.initException;
        }
        String string17 = this.cfg.getStringProperty(PROP_JOB_STORE_CLASS, RAMJobStore.class.getName());
        if (string17 == null) {
            this.initException = new SchedulerException("JobStore class not specified. ");
            throw this.initException;
        }
        try {
            jobStore = (JobStore)classLoadHelper.loadClass(string17).newInstance();
        }
        catch (Exception exception) {
            this.initException = new SchedulerException("JobStore class '" + string17 + "' could not be instantiated.", exception);
            throw this.initException;
        }
        SchedulerDetailsSetter.setDetails(jobStore, string5, string7);
        properties = this.cfg.getPropertyGroup(PROP_JOB_STORE_PREFIX, true, new String[]{PROP_JOB_STORE_LOCK_HANDLER_PREFIX});
        try {
            this.setBeanProps(jobStore, properties);
        }
        catch (Exception exception) {
            this.initException = new SchedulerException("JobStore class '" + string17 + "' props could not be configured.", exception);
            throw this.initException;
        }
        if (jobStore instanceof JobStoreSupport && (stringArray = this.cfg.getStringProperty(PROP_JOB_STORE_LOCK_HANDLER_CLASS)) != null) {
            try {
                Semaphore semaphore = (Semaphore)classLoadHelper.loadClass((String)stringArray).newInstance();
                properties = this.cfg.getPropertyGroup(PROP_JOB_STORE_LOCK_HANDLER_PREFIX, true);
                if (semaphore instanceof TablePrefixAware) {
                    properties.setProperty(PROP_TABLE_PREFIX, ((JobStoreSupport)jobStore).getTablePrefix());
                    properties.setProperty(PROP_SCHED_NAME, string5);
                }
                try {
                    this.setBeanProps(semaphore, properties);
                }
                catch (Exception exception) {
                    this.initException = new SchedulerException("JobStore LockHandler class '" + (String)stringArray + "' props could not be configured.", exception);
                    throw this.initException;
                }
                ((JobStoreSupport)jobStore).setLockHandler(semaphore);
                this.getLog().info("Using custom data access locking (synchronization): " + (String)stringArray);
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("JobStore LockHandler class '" + (String)stringArray + "' could not be instantiated.", exception);
                throw this.initException;
            }
        }
        stringArray = this.cfg.getPropertyGroups(PROP_DATASOURCE_PREFIX);
        for (int i = 0; i < stringArray.length; ++i) {
            object8 = new PropertiesParser(this.cfg.getPropertyGroup("org.quartz.dataSource." + stringArray[i], true));
            String string18 = ((PropertiesParser)object8).getStringProperty(PROP_CONNECTION_PROVIDER_CLASS, null);
            if (string18 != null) {
                object7 = null;
                try {
                    object7 = (ConnectionProvider)classLoadHelper.loadClass(string18).newInstance();
                }
                catch (Exception exception) {
                    this.initException = new SchedulerException("ConnectionProvider class '" + string18 + "' could not be instantiated.", exception);
                    throw this.initException;
                }
                try {
                    ((PropertiesParser)object8).getUnderlyingProperties().remove(PROP_CONNECTION_PROVIDER_CLASS);
                    if (object7 instanceof PoolingConnectionProvider) {
                        this.populateProviderWithExtraProps((PoolingConnectionProvider)object7, ((PropertiesParser)object8).getUnderlyingProperties());
                    } else {
                        this.setBeanProps(object7, ((PropertiesParser)object8).getUnderlyingProperties());
                    }
                    object7.initialize();
                }
                catch (Exception exception) {
                    this.initException = new SchedulerException("ConnectionProvider class '" + string18 + "' props could not be configured.", exception);
                    throw this.initException;
                }
                dBConnectionManager = DBConnectionManager.getInstance();
                dBConnectionManager.addConnectionProvider(stringArray[i], (ConnectionProvider)object7);
                continue;
            }
            object7 = ((PropertiesParser)object8).getStringProperty(PROP_DATASOURCE_JNDI_URL, null);
            if (object7 != null) {
                boolean bl13 = ((PropertiesParser)object8).getBooleanProperty(PROP_DATASOURCE_JNDI_ALWAYS_LOOKUP);
                object6 = ((PropertiesParser)object8).getStringProperty(PROP_DATASOURCE_JNDI_INITIAL);
                object5 = ((PropertiesParser)object8).getStringProperty(PROP_DATASOURCE_JNDI_PROVDER);
                string = ((PropertiesParser)object8).getStringProperty(PROP_DATASOURCE_JNDI_PRINCIPAL);
                object4 = ((PropertiesParser)object8).getStringProperty(PROP_DATASOURCE_JNDI_CREDENTIALS);
                object3 = null;
                if (null != object6 || null != object5 || null != string || null != object4) {
                    object3 = new Properties();
                    if (object6 != null) {
                        ((Properties)object3).put(PROP_DATASOURCE_JNDI_INITIAL, object6);
                    }
                    if (object5 != null) {
                        ((Properties)object3).put(PROP_DATASOURCE_JNDI_PROVDER, object5);
                    }
                    if (string != null) {
                        ((Properties)object3).put(PROP_DATASOURCE_JNDI_PRINCIPAL, string);
                    }
                    if (object4 != null) {
                        ((Properties)object3).put(PROP_DATASOURCE_JNDI_CREDENTIALS, object4);
                    }
                }
                object2 = new JNDIConnectionProvider((String)object7, (Properties)object3, bl13);
                dBConnectionManager = DBConnectionManager.getInstance();
                dBConnectionManager.addConnectionProvider(stringArray[i], (ConnectionProvider)object2);
                continue;
            }
            String string19 = ((PropertiesParser)object8).getStringProperty(PROP_DATASOURCE_DRIVER);
            object6 = ((PropertiesParser)object8).getStringProperty(PROP_DATASOURCE_URL);
            if (string19 == null) {
                this.initException = new SchedulerException("Driver not specified for DataSource: " + stringArray[i]);
                throw this.initException;
            }
            if (object6 == null) {
                this.initException = new SchedulerException("DB URL not specified for DataSource: " + stringArray[i]);
                throw this.initException;
            }
            try {
                object5 = new PoolingConnectionProvider(((PropertiesParser)object8).getUnderlyingProperties());
                dBConnectionManager = DBConnectionManager.getInstance();
                dBConnectionManager.addConnectionProvider(stringArray[i], (ConnectionProvider)object5);
                this.populateProviderWithExtraProps((PoolingConnectionProvider)object5, ((PropertiesParser)object8).getUnderlyingProperties());
                continue;
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("Could not initialize DataSource: " + stringArray[i], exception);
                throw this.initException;
            }
        }
        String[] stringArray2 = this.cfg.getPropertyGroups(PROP_PLUGIN_PREFIX);
        object8 = new SchedulerPlugin[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            object7 = this.cfg.getPropertyGroup("org.quartz.plugin." + stringArray2[i], true);
            String string20 = ((Properties)object7).getProperty("class", null);
            if (string20 == null) {
                this.initException = new SchedulerException("SchedulerPlugin class not specified for plugin '" + stringArray2[i] + "'");
                throw this.initException;
            }
            object6 = null;
            try {
                object6 = (SchedulerPlugin)classLoadHelper.loadClass(string20).newInstance();
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("SchedulerPlugin class '" + string20 + "' could not be instantiated.", exception);
                throw this.initException;
            }
            try {
                this.setBeanProps(object6, (Properties)object7);
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("JobStore SchedulerPlugin '" + string20 + "' props could not be configured.", exception);
                throw this.initException;
            }
            object8[i] = object6;
        }
        Class[] classArray = new Class[]{String.class};
        object7 = this.cfg.getPropertyGroups(PROP_JOB_LISTENER_PREFIX);
        JobListener[] jobListenerArray = new JobListener[((String[])object7).length];
        for (int i = 0; i < ((String[])object7).length; ++i) {
            object5 = this.cfg.getPropertyGroup("org.quartz.jobListener." + object7[i], true);
            string = ((Properties)object5).getProperty("class", null);
            if (string == null) {
                this.initException = new SchedulerException("JobListener class not specified for listener '" + (String)object7[i] + "'");
                throw this.initException;
            }
            object4 = null;
            try {
                object4 = (JobListener)classLoadHelper.loadClass(string).newInstance();
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("JobListener class '" + string + "' could not be instantiated.", exception);
                throw this.initException;
            }
            try {
                object3 = null;
                try {
                    object3 = object4.getClass().getMethod("setName", classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (object3 != null) {
                    ((Method)object3).invoke(object4, object7[i]);
                }
                this.setBeanProps(object4, (Properties)object5);
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("JobListener '" + string + "' props could not be configured.", exception);
                throw this.initException;
            }
            jobListenerArray[i] = object4;
        }
        String[] stringArray3 = this.cfg.getPropertyGroups(PROP_TRIGGER_LISTENER_PREFIX);
        object5 = new TriggerListener[stringArray3.length];
        for (n = 0; n < stringArray3.length; ++n) {
            object4 = this.cfg.getPropertyGroup("org.quartz.triggerListener." + stringArray3[n], true);
            object3 = ((Properties)object4).getProperty("class", null);
            if (object3 == null) {
                this.initException = new SchedulerException("TriggerListener class not specified for listener '" + stringArray3[n] + "'");
                throw this.initException;
            }
            object2 = null;
            try {
                object2 = (TriggerListener)classLoadHelper.loadClass((String)object3).newInstance();
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("TriggerListener class '" + (String)object3 + "' could not be instantiated.", exception);
                throw this.initException;
            }
            try {
                object = null;
                try {
                    object = object2.getClass().getMethod("setName", classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (object != null) {
                    ((Method)object).invoke(object2, stringArray3[n]);
                }
                this.setBeanProps(object2, (Properties)object4);
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("TriggerListener '" + (String)object3 + "' props could not be configured.", exception);
                throw this.initException;
            }
            object5[n] = object2;
        }
        n = 0;
        boolean bl14 = false;
        object3 = this.cfg.getStringProperty(PROP_THREAD_EXECUTOR_CLASS);
        if (object3 != null) {
            properties = this.cfg.getPropertyGroup(PROP_THREAD_EXECUTOR, true);
            try {
                threadExecutor = (ThreadExecutor)classLoadHelper.loadClass((String)object3).newInstance();
                this.log.info("Using custom implementation for ThreadExecutor: " + (String)object3);
                this.setBeanProps(threadExecutor, properties);
            }
            catch (Exception exception) {
                this.initException = new SchedulerException("ThreadExecutor class '" + (String)object3 + "' could not be instantiated.", exception);
                throw this.initException;
            }
        } else {
            this.log.info("Using default implementation for ThreadExecutor");
            threadExecutor = new DefaultThreadExecutor();
        }
        try {
            int n5;
            object2 = null;
            if (string4 != null) {
                UserTransactionHelper.setUserTxLocation(string4);
            }
            object2 = bl ? new JTAJobRunShellFactory() : new JTAAnnotationAwareJobRunShellFactory();
            if (bl2) {
                try {
                    string7 = DEFAULT_INSTANCE_ID;
                    if (jobStore.isClustered()) {
                        string7 = instanceIdGenerator.generateInstanceId();
                    }
                }
                catch (Exception exception) {
                    this.getLog().error("Couldn't generate instance Id!", exception);
                    throw new IllegalStateException("Cannot run without an instance id.");
                }
            }
            if (jobStore.getClass().getName().startsWith("org.terracotta.quartz")) {
                try {
                    object = (String)jobStore.getClass().getMethod("getUUID", new Class[0]).invoke((Object)jobStore, new Object[0]);
                    if (string7.equals(DEFAULT_INSTANCE_ID)) {
                        string7 = "TERRACOTTA_CLUSTERED,node=" + (String)object;
                        if (string10 == null) {
                            string10 = QuartzSchedulerResources.generateJMXObjectName(string5, string7);
                        }
                    } else if (string10 == null) {
                        string10 = QuartzSchedulerResources.generateJMXObjectName(string5, string7 + ",node=" + (String)object);
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException("Problem obtaining node id from TerracottaJobStore.", exception);
                }
                if (null == this.cfg.getStringProperty(PROP_SCHED_JMX_EXPORT)) {
                    bl8 = true;
                }
            }
            if (jobStore instanceof JobStoreSupport) {
                object = (JobStoreSupport)jobStore;
                ((JobStoreSupport)object).setDbRetryInterval(l2);
                if (bl4) {
                    ((JobStoreSupport)object).setThreadsInheritInitializersClassLoadContext(bl4);
                }
                ((JobStoreSupport)object).setThreadExecutor(threadExecutor);
            }
            object = new QuartzSchedulerResources();
            ((QuartzSchedulerResources)object).setName(string5);
            ((QuartzSchedulerResources)object).setThreadName(string6);
            ((QuartzSchedulerResources)object).setInstanceId(string7);
            ((QuartzSchedulerResources)object).setJobRunShellFactory((JobRunShellFactory)object2);
            ((QuartzSchedulerResources)object).setMakeSchedulerThreadDaemon(bl3);
            ((QuartzSchedulerResources)object).setThreadsInheritInitializersClassLoadContext(bl4);
            ((QuartzSchedulerResources)object).setRunUpdateCheck(!bl5);
            ((QuartzSchedulerResources)object).setBatchTimeWindow(l3);
            ((QuartzSchedulerResources)object).setMaxBatchSize(n2);
            ((QuartzSchedulerResources)object).setInterruptJobsOnShutdown(bl6);
            ((QuartzSchedulerResources)object).setInterruptJobsOnShutdownWithWait(bl7);
            ((QuartzSchedulerResources)object).setJMXExport(bl8);
            ((QuartzSchedulerResources)object).setJMXObjectName(string10);
            if (bl12) {
                ManagementRESTServiceConfiguration managementRESTServiceConfiguration = new ManagementRESTServiceConfiguration();
                managementRESTServiceConfiguration.setBind(string15);
                managementRESTServiceConfiguration.setEnabled(bl12);
                ((QuartzSchedulerResources)object).setManagementRESTServiceConfiguration(managementRESTServiceConfiguration);
            }
            if (bl10) {
                ((QuartzSchedulerResources)object).setRMIRegistryHost(string12);
                ((QuartzSchedulerResources)object).setRMIRegistryPort(n3);
                ((QuartzSchedulerResources)object).setRMIServerPort(n4);
                ((QuartzSchedulerResources)object).setRMICreateRegistryStrategy(string13);
                ((QuartzSchedulerResources)object).setRMIBindName(string14);
            }
            SchedulerDetailsSetter.setDetails(threadPool, string5, string7);
            ((QuartzSchedulerResources)object).setThreadExecutor(threadExecutor);
            threadExecutor.initialize();
            ((QuartzSchedulerResources)object).setThreadPool(threadPool);
            if (threadPool instanceof SimpleThreadPool && bl4) {
                ((SimpleThreadPool)threadPool).setThreadsInheritContextClassLoaderOfInitializingThread(bl4);
            }
            threadPool.initialize();
            n = 1;
            ((QuartzSchedulerResources)object).setJobStore(jobStore);
            for (int i = 0; i < ((Object)object8).length; ++i) {
                ((QuartzSchedulerResources)object).addSchedulerPlugin((SchedulerPlugin)object8[i]);
            }
            quartzScheduler = new QuartzScheduler((QuartzSchedulerResources)object, l, l2);
            bl14 = true;
            Scheduler scheduler = this.instantiate((QuartzSchedulerResources)object, quartzScheduler);
            if (jobFactory != null) {
                quartzScheduler.setJobFactory(jobFactory);
            }
            for (n5 = 0; n5 < ((Object)object8).length; ++n5) {
                object8[n5].initialize(stringArray2[n5], scheduler, classLoadHelper);
            }
            for (n5 = 0; n5 < jobListenerArray.length; ++n5) {
                quartzScheduler.getListenerManager().addJobListener(jobListenerArray[n5], (Matcher<JobKey>)EverythingMatcher.allJobs());
            }
            for (n5 = 0; n5 < ((Object)object5).length; ++n5) {
                quartzScheduler.getListenerManager().addTriggerListener((TriggerListener)object5[n5], (Matcher<TriggerKey>)EverythingMatcher.allTriggers());
            }
            for (Object object9 : properties2.keySet()) {
                String string21 = properties2.getProperty((String)object9);
                scheduler.getContext().put((String)object9, string21);
            }
            jobStore.setInstanceId(string7);
            jobStore.setInstanceName(string5);
            jobStore.setThreadPoolSize(threadPool.getPoolSize());
            jobStore.initialize(classLoadHelper, quartzScheduler.getSchedulerSignaler());
            object2.initialize(scheduler);
            quartzScheduler.initialize();
            this.getLog().info("Quartz scheduler '" + scheduler.getSchedulerName() + "' initialized from " + this.propSrc);
            this.getLog().info("Quartz scheduler version: " + quartzScheduler.getVersion());
            quartzScheduler.addNoGCObject(schedulerRepository);
            if (dBConnectionManager != null) {
                quartzScheduler.addNoGCObject(dBConnectionManager);
            }
            schedulerRepository.bind(scheduler);
            return scheduler;
        }
        catch (SchedulerException schedulerException) {
            this.shutdownFromInstantiateException(threadPool, quartzScheduler, n != 0, bl14);
            throw schedulerException;
        }
        catch (RuntimeException runtimeException) {
            this.shutdownFromInstantiateException(threadPool, quartzScheduler, n != 0, bl14);
            throw runtimeException;
        }
        catch (Error error) {
            this.shutdownFromInstantiateException(threadPool, quartzScheduler, n != 0, bl14);
            throw error;
        }
    }

    private void populateProviderWithExtraProps(PoolingConnectionProvider poolingConnectionProvider, Properties properties) throws Exception {
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        properties2.remove(PROP_DATASOURCE_DRIVER);
        properties2.remove(PROP_DATASOURCE_URL);
        properties2.remove(PROP_DATASOURCE_USER);
        properties2.remove(PROP_DATASOURCE_PASSWORD);
        properties2.remove("idleConnectionValidationSeconds");
        properties2.remove(PROP_DATASOURCE_MAX_CONNECTIONS);
        properties2.remove("maxCachedStatementsPerConnection");
        properties2.remove("validateOnCheckout");
        properties2.remove(PROP_DATASOURCE_VALIDATION_QUERY);
        this.setBeanProps(poolingConnectionProvider.getDataSource(), properties2);
    }

    private void shutdownFromInstantiateException(ThreadPool threadPool, QuartzScheduler quartzScheduler, boolean bl, boolean bl2) {
        try {
            if (bl2) {
                quartzScheduler.shutdown(false);
            } else if (bl) {
                threadPool.shutdown(false);
            }
        }
        catch (Exception exception) {
            this.getLog().error("Got another exception while shutting down after instantiation exception", exception);
        }
    }

    protected Scheduler instantiate(QuartzSchedulerResources quartzSchedulerResources, QuartzScheduler quartzScheduler) {
        StdScheduler stdScheduler = new StdScheduler(quartzScheduler);
        return stdScheduler;
    }

    private void setBeanProps(Object object, Properties properties) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, IntrospectionException, SchedulerConfigException {
        properties.remove("class");
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        PropertiesParser propertiesParser = new PropertiesParser(properties);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = string.substring(0, 1).toUpperCase(Locale.US);
            String string3 = "set" + string2 + string.substring(1);
            Method method = this.getSetMethod(string3, propertyDescriptorArray);
            try {
                if (method == null) {
                    throw new NoSuchMethodException("No setter for property '" + string + "'");
                }
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length != 1) {
                    throw new NoSuchMethodException("No 1-argument setter for property '" + string + "'");
                }
                PropertiesParser propertiesParser2 = propertiesParser;
                String string4 = propertiesParser.getStringProperty(string);
                if (string4 != null && string4.startsWith("$@")) {
                    string4 = string4.substring(2);
                    propertiesParser2 = this.cfg;
                } else {
                    string4 = string;
                }
                if (classArray[0].equals(Integer.TYPE)) {
                    method.invoke(object, propertiesParser2.getIntProperty(string4));
                    continue;
                }
                if (classArray[0].equals(Long.TYPE)) {
                    method.invoke(object, propertiesParser2.getLongProperty(string4));
                    continue;
                }
                if (classArray[0].equals(Float.TYPE)) {
                    method.invoke(object, Float.valueOf(propertiesParser2.getFloatProperty(string4)));
                    continue;
                }
                if (classArray[0].equals(Double.TYPE)) {
                    method.invoke(object, propertiesParser2.getDoubleProperty(string4));
                    continue;
                }
                if (classArray[0].equals(Boolean.TYPE)) {
                    method.invoke(object, propertiesParser2.getBooleanProperty(string4));
                    continue;
                }
                if (classArray[0].equals(String.class)) {
                    method.invoke(object, propertiesParser2.getStringProperty(string4));
                    continue;
                }
                throw new NoSuchMethodException("No primitive-type setter for property '" + string + "'");
            }
            catch (NumberFormatException numberFormatException) {
                throw new SchedulerConfigException("Could not parse property '" + string + "' into correct data type: " + numberFormatException.toString());
            }
        }
    }

    private Method getSetMethod(String string, PropertyDescriptor[] propertyDescriptorArray) {
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            Method method = propertyDescriptorArray[i].getWriteMethod();
            if (method == null || !method.getName().equals(string)) continue;
            return method;
        }
        return null;
    }

    private Class<?> loadClass(String string) throws ClassNotFoundException, SchedulerConfigException {
        try {
            ClassLoader classLoader = this.findClassloader();
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
            throw new SchedulerConfigException("Unable to find a class loader on the current thread or class.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.getClass().getClassLoader() != null) {
                return this.getClass().getClassLoader().loadClass(string);
            }
            throw classNotFoundException;
        }
    }

    private ClassLoader findClassloader() {
        if (Thread.currentThread().getContextClassLoader() == null && this.getClass().getClassLoader() != null) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
        return Thread.currentThread().getContextClassLoader();
    }

    private String getSchedulerName() {
        return this.cfg.getStringProperty(PROP_SCHED_INSTANCE_NAME, "QuartzScheduler");
    }

    @Override
    public Scheduler getScheduler() throws SchedulerException {
        SchedulerRepository schedulerRepository;
        Scheduler scheduler;
        if (this.cfg == null) {
            this.initialize();
        }
        if ((scheduler = (schedulerRepository = SchedulerRepository.getInstance()).lookup(this.getSchedulerName())) != null) {
            if (scheduler.isShutdown()) {
                schedulerRepository.remove(this.getSchedulerName());
            } else {
                return scheduler;
            }
        }
        scheduler = this.instantiate();
        return scheduler;
    }

    public static Scheduler getDefaultScheduler() throws SchedulerException {
        StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
        return stdSchedulerFactory.getScheduler();
    }

    @Override
    public Scheduler getScheduler(String string) throws SchedulerException {
        return SchedulerRepository.getInstance().lookup(string);
    }

    @Override
    public Collection<Scheduler> getAllSchedulers() throws SchedulerException {
        return SchedulerRepository.getInstance().lookupAll();
    }
}

