/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

public class SchedulerRepository {
    private HashMap<String, Scheduler> schedulers = new HashMap();
    private static SchedulerRepository inst;

    private SchedulerRepository() {
    }

    public static synchronized SchedulerRepository getInstance() {
        if (inst == null) {
            inst = new SchedulerRepository();
        }
        return inst;
    }

    public synchronized void bind(Scheduler scheduler) throws SchedulerException {
        if (this.schedulers.get(scheduler.getSchedulerName()) != null) {
            throw new SchedulerException("Scheduler with name '" + scheduler.getSchedulerName() + "' already exists.");
        }
        this.schedulers.put(scheduler.getSchedulerName(), scheduler);
    }

    public synchronized boolean remove(String string) {
        return this.schedulers.remove(string) != null;
    }

    public synchronized Scheduler lookup(String string) {
        return this.schedulers.get(string);
    }

    public synchronized Collection<Scheduler> lookupAll() {
        return Collections.unmodifiableCollection(this.schedulers.values());
    }
}

