/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ListenerManager;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.UnableToInterruptJobException;
import org.quartz.core.RemotableQuartzScheduler;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.JobFactory;

public class RemoteScheduler
implements Scheduler {
    private RemotableQuartzScheduler rsched;
    private String schedId;
    private String rmiHost;
    private int rmiPort;

    public RemoteScheduler(String string, String string2, int n) {
        this.schedId = string;
        this.rmiHost = string2;
        this.rmiPort = n;
    }

    protected RemotableQuartzScheduler getRemoteScheduler() throws SchedulerException {
        if (this.rsched != null) {
            return this.rsched;
        }
        try {
            Registry registry = LocateRegistry.getRegistry(this.rmiHost, this.rmiPort);
            this.rsched = (RemotableQuartzScheduler)registry.lookup(this.schedId);
        }
        catch (Exception exception) {
            SchedulerException schedulerException = new SchedulerException("Could not get handle to remote scheduler: " + exception.getMessage(), exception);
            throw schedulerException;
        }
        return this.rsched;
    }

    protected SchedulerException invalidateHandleCreateException(String string, Exception exception) {
        this.rsched = null;
        SchedulerException schedulerException = new SchedulerException(string, exception);
        return schedulerException;
    }

    @Override
    public String getSchedulerName() throws SchedulerException {
        try {
            return this.getRemoteScheduler().getSchedulerName();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public String getSchedulerInstanceId() throws SchedulerException {
        try {
            return this.getRemoteScheduler().getSchedulerInstanceId();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public SchedulerMetaData getMetaData() throws SchedulerException {
        try {
            RemotableQuartzScheduler remotableQuartzScheduler = this.getRemoteScheduler();
            return new SchedulerMetaData(this.getSchedulerName(), this.getSchedulerInstanceId(), this.getClass(), true, this.isStarted(), this.isInStandbyMode(), this.isShutdown(), remotableQuartzScheduler.runningSince(), remotableQuartzScheduler.numJobsExecuted(), remotableQuartzScheduler.getJobStoreClass(), remotableQuartzScheduler.supportsPersistence(), remotableQuartzScheduler.isClustered(), remotableQuartzScheduler.getThreadPoolClass(), remotableQuartzScheduler.getThreadPoolSize(), remotableQuartzScheduler.getVersion());
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public SchedulerContext getContext() throws SchedulerException {
        try {
            return this.getRemoteScheduler().getSchedulerContext();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void start() throws SchedulerException {
        try {
            this.getRemoteScheduler().start();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void startDelayed(int n) throws SchedulerException {
        try {
            this.getRemoteScheduler().startDelayed(n);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void standby() throws SchedulerException {
        try {
            this.getRemoteScheduler().standby();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean isStarted() throws SchedulerException {
        try {
            return this.getRemoteScheduler().runningSince() != null;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean isInStandbyMode() throws SchedulerException {
        try {
            return this.getRemoteScheduler().isInStandbyMode();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void shutdown() throws SchedulerException {
        try {
            String string = this.getSchedulerName();
            this.getRemoteScheduler().shutdown();
            SchedulerRepository.getInstance().remove(string);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void shutdown(boolean bl) throws SchedulerException {
        try {
            String string = this.getSchedulerName();
            this.getRemoteScheduler().shutdown(bl);
            SchedulerRepository.getInstance().remove(string);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean isShutdown() throws SchedulerException {
        try {
            return this.getRemoteScheduler().isShutdown();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public List<JobExecutionContext> getCurrentlyExecutingJobs() throws SchedulerException {
        try {
            return this.getRemoteScheduler().getCurrentlyExecutingJobs();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public Date scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        try {
            return this.getRemoteScheduler().scheduleJob(jobDetail, trigger);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public Date scheduleJob(Trigger trigger) throws SchedulerException {
        try {
            return this.getRemoteScheduler().scheduleJob(trigger);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void addJob(JobDetail jobDetail, boolean bl) throws SchedulerException {
        try {
            this.getRemoteScheduler().addJob(jobDetail, bl);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void addJob(JobDetail jobDetail, boolean bl, boolean bl2) throws SchedulerException {
        try {
            this.getRemoteScheduler().addJob(jobDetail, bl, bl2);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean deleteJobs(List<JobKey> list) throws SchedulerException {
        try {
            return this.getRemoteScheduler().deleteJobs(list);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void scheduleJobs(Map<JobDetail, Set<? extends Trigger>> map, boolean bl) throws SchedulerException {
        try {
            this.getRemoteScheduler().scheduleJobs(map, bl);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void scheduleJob(JobDetail jobDetail, Set<? extends Trigger> set, boolean bl) throws SchedulerException {
        try {
            this.getRemoteScheduler().scheduleJob(jobDetail, set, bl);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean unscheduleJobs(List<TriggerKey> list) throws SchedulerException {
        try {
            return this.getRemoteScheduler().unscheduleJobs(list);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean deleteJob(JobKey jobKey) throws SchedulerException {
        try {
            return this.getRemoteScheduler().deleteJob(jobKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean unscheduleJob(TriggerKey triggerKey) throws SchedulerException {
        try {
            return this.getRemoteScheduler().unscheduleJob(triggerKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public Date rescheduleJob(TriggerKey triggerKey, Trigger trigger) throws SchedulerException {
        try {
            return this.getRemoteScheduler().rescheduleJob(triggerKey, trigger);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void triggerJob(JobKey jobKey) throws SchedulerException {
        this.triggerJob(jobKey, null);
    }

    @Override
    public void triggerJob(JobKey jobKey, JobDataMap jobDataMap) throws SchedulerException {
        try {
            this.getRemoteScheduler().triggerJob(jobKey, jobDataMap);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void pauseTrigger(TriggerKey triggerKey) throws SchedulerException {
        try {
            this.getRemoteScheduler().pauseTrigger(triggerKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void pauseTriggers(GroupMatcher<TriggerKey> groupMatcher) throws SchedulerException {
        try {
            this.getRemoteScheduler().pauseTriggers(groupMatcher);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void pauseJob(JobKey jobKey) throws SchedulerException {
        try {
            this.getRemoteScheduler().pauseJob(jobKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void pauseJobs(GroupMatcher<JobKey> groupMatcher) throws SchedulerException {
        try {
            this.getRemoteScheduler().pauseJobs(groupMatcher);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void resumeTrigger(TriggerKey triggerKey) throws SchedulerException {
        try {
            this.getRemoteScheduler().resumeTrigger(triggerKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void resumeTriggers(GroupMatcher<TriggerKey> groupMatcher) throws SchedulerException {
        try {
            this.getRemoteScheduler().resumeTriggers(groupMatcher);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void resumeJob(JobKey jobKey) throws SchedulerException {
        try {
            this.getRemoteScheduler().resumeJob(jobKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void resumeJobs(GroupMatcher<JobKey> groupMatcher) throws SchedulerException {
        try {
            this.getRemoteScheduler().resumeJobs(groupMatcher);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void pauseAll() throws SchedulerException {
        try {
            this.getRemoteScheduler().pauseAll();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void resumeAll() throws SchedulerException {
        try {
            this.getRemoteScheduler().resumeAll();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public List<String> getJobGroupNames() throws SchedulerException {
        try {
            return this.getRemoteScheduler().getJobGroupNames();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> groupMatcher) throws SchedulerException {
        try {
            return this.getRemoteScheduler().getJobKeys(groupMatcher);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public List<? extends Trigger> getTriggersOfJob(JobKey jobKey) throws SchedulerException {
        try {
            return this.getRemoteScheduler().getTriggersOfJob(jobKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public List<String> getTriggerGroupNames() throws SchedulerException {
        try {
            return this.getRemoteScheduler().getTriggerGroupNames();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> groupMatcher) throws SchedulerException {
        try {
            return this.getRemoteScheduler().getTriggerKeys(groupMatcher);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public JobDetail getJobDetail(JobKey jobKey) throws SchedulerException {
        try {
            return this.getRemoteScheduler().getJobDetail(jobKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean checkExists(JobKey jobKey) throws SchedulerException {
        try {
            return this.getRemoteScheduler().checkExists(jobKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean checkExists(TriggerKey triggerKey) throws SchedulerException {
        try {
            return this.getRemoteScheduler().checkExists(triggerKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void clear() throws SchedulerException {
        try {
            this.getRemoteScheduler().clear();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public Trigger getTrigger(TriggerKey triggerKey) throws SchedulerException {
        try {
            return this.getRemoteScheduler().getTrigger(triggerKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public Trigger.TriggerState getTriggerState(TriggerKey triggerKey) throws SchedulerException {
        try {
            return this.getRemoteScheduler().getTriggerState(triggerKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void addCalendar(String string, Calendar calendar, boolean bl, boolean bl2) throws SchedulerException {
        try {
            this.getRemoteScheduler().addCalendar(string, calendar, bl, bl2);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean deleteCalendar(String string) throws SchedulerException {
        try {
            return this.getRemoteScheduler().deleteCalendar(string);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public Calendar getCalendar(String string) throws SchedulerException {
        try {
            return this.getRemoteScheduler().getCalendar(string);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public List<String> getCalendarNames() throws SchedulerException {
        try {
            return this.getRemoteScheduler().getCalendarNames();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public Set<String> getPausedTriggerGroups() throws SchedulerException {
        try {
            return this.getRemoteScheduler().getPausedTriggerGroups();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public ListenerManager getListenerManager() throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public boolean interrupt(JobKey jobKey) throws UnableToInterruptJobException {
        try {
            return this.getRemoteScheduler().interrupt(jobKey);
        }
        catch (RemoteException remoteException) {
            throw new UnableToInterruptJobException(this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException));
        }
        catch (SchedulerException schedulerException) {
            throw new UnableToInterruptJobException(schedulerException);
        }
    }

    @Override
    public boolean interrupt(String string) throws UnableToInterruptJobException {
        try {
            return this.getRemoteScheduler().interrupt(string);
        }
        catch (RemoteException remoteException) {
            throw new UnableToInterruptJobException(this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException));
        }
        catch (SchedulerException schedulerException) {
            throw new UnableToInterruptJobException(schedulerException);
        }
    }

    @Override
    public void setJobFactory(JobFactory jobFactory) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }
}

