/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ListenerManager;
import org.quartz.Matcher;
import org.quartz.SchedulerListener;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.matchers.EverythingMatcher;

public class ListenerManagerImpl
implements ListenerManager {
    private Map<String, JobListener> globalJobListeners = new LinkedHashMap<String, JobListener>(10);
    private Map<String, TriggerListener> globalTriggerListeners = new LinkedHashMap<String, TriggerListener>(10);
    private Map<String, List<Matcher<JobKey>>> globalJobListenersMatchers = new LinkedHashMap<String, List<Matcher<JobKey>>>(10);
    private Map<String, List<Matcher<TriggerKey>>> globalTriggerListenersMatchers = new LinkedHashMap<String, List<Matcher<TriggerKey>>>(10);
    private ArrayList<SchedulerListener> schedulerListeners = new ArrayList(10);

    @Override
    public void addJobListener(JobListener jobListener, Matcher<JobKey> ... matcherArray) {
        this.addJobListener(jobListener, Arrays.asList(matcherArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJobListener(JobListener jobListener, List<Matcher<JobKey>> list) {
        if (jobListener.getName() == null || jobListener.getName().length() == 0) {
            throw new IllegalArgumentException("JobListener name cannot be empty.");
        }
        Map<String, JobListener> map = this.globalJobListeners;
        synchronized (map) {
            this.globalJobListeners.put(jobListener.getName(), jobListener);
            LinkedList<Matcher<JobKey>> linkedList = new LinkedList<Matcher<JobKey>>();
            if (list != null && list.size() > 0) {
                linkedList.addAll(list);
            } else {
                linkedList.add(EverythingMatcher.allJobs());
            }
            this.globalJobListenersMatchers.put(jobListener.getName(), linkedList);
        }
    }

    @Override
    public void addJobListener(JobListener jobListener) {
        this.addJobListener(jobListener, (Matcher<JobKey>)EverythingMatcher.allJobs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJobListener(JobListener jobListener, Matcher<JobKey> matcher) {
        if (jobListener.getName() == null || jobListener.getName().length() == 0) {
            throw new IllegalArgumentException("JobListener name cannot be empty.");
        }
        Map<String, JobListener> map = this.globalJobListeners;
        synchronized (map) {
            this.globalJobListeners.put(jobListener.getName(), jobListener);
            LinkedList<Matcher<JobKey>> linkedList = new LinkedList<Matcher<JobKey>>();
            if (matcher != null) {
                linkedList.add(matcher);
            } else {
                linkedList.add(EverythingMatcher.allJobs());
            }
            this.globalJobListenersMatchers.put(jobListener.getName(), linkedList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addJobListenerMatcher(String string, Matcher<JobKey> matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("Null value not acceptable.");
        }
        Map<String, JobListener> map = this.globalJobListeners;
        synchronized (map) {
            List<Matcher<JobKey>> list = this.globalJobListenersMatchers.get(string);
            if (list == null) {
                return false;
            }
            list.add(matcher);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeJobListenerMatcher(String string, Matcher<JobKey> matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("Non-null value not acceptable.");
        }
        Map<String, JobListener> map = this.globalJobListeners;
        synchronized (map) {
            List<Matcher<JobKey>> list = this.globalJobListenersMatchers.get(string);
            if (list == null) {
                return false;
            }
            return list.remove(matcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Matcher<JobKey>> getJobListenerMatchers(String string) {
        Map<String, JobListener> map = this.globalJobListeners;
        synchronized (map) {
            List<Matcher<JobKey>> list = this.globalJobListenersMatchers.get(string);
            if (list == null) {
                return null;
            }
            return Collections.unmodifiableList(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setJobListenerMatchers(String string, List<Matcher<JobKey>> list) {
        if (list == null) {
            throw new IllegalArgumentException("Non-null value not acceptable.");
        }
        Map<String, JobListener> map = this.globalJobListeners;
        synchronized (map) {
            List<Matcher<JobKey>> list2 = this.globalJobListenersMatchers.get(string);
            if (list2 == null) {
                return false;
            }
            this.globalJobListenersMatchers.put(string, list);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeJobListener(String string) {
        Map<String, JobListener> map = this.globalJobListeners;
        synchronized (map) {
            return this.globalJobListeners.remove(string) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JobListener> getJobListeners() {
        Map<String, JobListener> map = this.globalJobListeners;
        synchronized (map) {
            return Collections.unmodifiableList(new LinkedList<JobListener>(this.globalJobListeners.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobListener getJobListener(String string) {
        Map<String, JobListener> map = this.globalJobListeners;
        synchronized (map) {
            return this.globalJobListeners.get(string);
        }
    }

    @Override
    public void addTriggerListener(TriggerListener triggerListener, Matcher<TriggerKey> ... matcherArray) {
        this.addTriggerListener(triggerListener, Arrays.asList(matcherArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTriggerListener(TriggerListener triggerListener, List<Matcher<TriggerKey>> list) {
        if (triggerListener.getName() == null || triggerListener.getName().length() == 0) {
            throw new IllegalArgumentException("TriggerListener name cannot be empty.");
        }
        Map<String, TriggerListener> map = this.globalTriggerListeners;
        synchronized (map) {
            this.globalTriggerListeners.put(triggerListener.getName(), triggerListener);
            LinkedList<Matcher<TriggerKey>> linkedList = new LinkedList<Matcher<TriggerKey>>();
            if (list != null && list.size() > 0) {
                linkedList.addAll(list);
            } else {
                linkedList.add(EverythingMatcher.allTriggers());
            }
            this.globalTriggerListenersMatchers.put(triggerListener.getName(), linkedList);
        }
    }

    @Override
    public void addTriggerListener(TriggerListener triggerListener) {
        this.addTriggerListener(triggerListener, (Matcher<TriggerKey>)EverythingMatcher.allTriggers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTriggerListener(TriggerListener triggerListener, Matcher<TriggerKey> matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("Null value not acceptable for matcher.");
        }
        if (triggerListener.getName() == null || triggerListener.getName().length() == 0) {
            throw new IllegalArgumentException("TriggerListener name cannot be empty.");
        }
        Map<String, TriggerListener> map = this.globalTriggerListeners;
        synchronized (map) {
            this.globalTriggerListeners.put(triggerListener.getName(), triggerListener);
            LinkedList<Matcher<TriggerKey>> linkedList = new LinkedList<Matcher<TriggerKey>>();
            linkedList.add(matcher);
            this.globalTriggerListenersMatchers.put(triggerListener.getName(), linkedList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addTriggerListenerMatcher(String string, Matcher<TriggerKey> matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("Non-null value not acceptable.");
        }
        Map<String, TriggerListener> map = this.globalTriggerListeners;
        synchronized (map) {
            List<Matcher<TriggerKey>> list = this.globalTriggerListenersMatchers.get(string);
            if (list == null) {
                return false;
            }
            list.add(matcher);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTriggerListenerMatcher(String string, Matcher<TriggerKey> matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("Non-null value not acceptable.");
        }
        Map<String, TriggerListener> map = this.globalTriggerListeners;
        synchronized (map) {
            List<Matcher<TriggerKey>> list = this.globalTriggerListenersMatchers.get(string);
            if (list == null) {
                return false;
            }
            return list.remove(matcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Matcher<TriggerKey>> getTriggerListenerMatchers(String string) {
        Map<String, TriggerListener> map = this.globalTriggerListeners;
        synchronized (map) {
            List<Matcher<TriggerKey>> list = this.globalTriggerListenersMatchers.get(string);
            if (list == null) {
                return null;
            }
            return Collections.unmodifiableList(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setTriggerListenerMatchers(String string, List<Matcher<TriggerKey>> list) {
        if (list == null) {
            throw new IllegalArgumentException("Non-null value not acceptable.");
        }
        Map<String, TriggerListener> map = this.globalTriggerListeners;
        synchronized (map) {
            List<Matcher<TriggerKey>> list2 = this.globalTriggerListenersMatchers.get(string);
            if (list2 == null) {
                return false;
            }
            this.globalTriggerListenersMatchers.put(string, list);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTriggerListener(String string) {
        Map<String, TriggerListener> map = this.globalTriggerListeners;
        synchronized (map) {
            return this.globalTriggerListeners.remove(string) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TriggerListener> getTriggerListeners() {
        Map<String, TriggerListener> map = this.globalTriggerListeners;
        synchronized (map) {
            return Collections.unmodifiableList(new LinkedList<TriggerListener>(this.globalTriggerListeners.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TriggerListener getTriggerListener(String string) {
        Map<String, TriggerListener> map = this.globalTriggerListeners;
        synchronized (map) {
            return this.globalTriggerListeners.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSchedulerListener(SchedulerListener schedulerListener) {
        ArrayList<SchedulerListener> arrayList = this.schedulerListeners;
        synchronized (arrayList) {
            this.schedulerListeners.add(schedulerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSchedulerListener(SchedulerListener schedulerListener) {
        ArrayList<SchedulerListener> arrayList = this.schedulerListeners;
        synchronized (arrayList) {
            return this.schedulerListeners.remove(schedulerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SchedulerListener> getSchedulerListeners() {
        ArrayList<SchedulerListener> arrayList = this.schedulerListeners;
        synchronized (arrayList) {
            return Collections.unmodifiableList(new ArrayList<SchedulerListener>(this.schedulerListeners));
        }
    }
}

