/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.util;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.annotations.common.util.StringHelper;

public final class ReflectHelper {
    public static final Class[] NO_PARAM_SIGNATURE;
    public static final Object[] NO_PARAMS;
    public static final Class[] SINGLE_OBJECT_PARAM_SIGNATURE;
    private static final Method OBJECT_EQUALS;
    private static final Method OBJECT_HASHCODE;

    private ReflectHelper() {
    }

    public static Method extractEqualsMethod(Class clazz) throws NoSuchMethodException {
        return clazz.getMethod("equals", SINGLE_OBJECT_PARAM_SIGNATURE);
    }

    public static Method extractHashCodeMethod(Class clazz) throws NoSuchMethodException {
        return clazz.getMethod("hashCode", NO_PARAM_SIGNATURE);
    }

    public static boolean overridesEquals(Class clazz) {
        Method method;
        try {
            method = ReflectHelper.extractEqualsMethod(clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        return !OBJECT_EQUALS.equals(method);
    }

    public static boolean overridesHashCode(Class clazz) {
        Method method;
        try {
            method = ReflectHelper.extractHashCodeMethod(clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        return !OBJECT_HASHCODE.equals(method);
    }

    public static Class classForName(String string, Class clazz) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Class.forName(string, true, clazz.getClassLoader());
    }

    public static Class classForName(String string) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Class.forName(string);
    }

    public static boolean isPublic(Class clazz, Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(clazz.getModifiers());
    }

    public static Object getConstantValue(String string) {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(StringHelper.qualifier(string));
        }
        catch (Throwable throwable) {
            return null;
        }
        try {
            return clazz.getField(StringHelper.unqualify(string)).get(null);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean isAbstractClass(Class clazz) {
        int n = clazz.getModifiers();
        return Modifier.isAbstract(n) || Modifier.isInterface(n);
    }

    public static boolean isFinalClass(Class clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public static Method getMethod(Class clazz, Method method) {
        try {
            return clazz.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        Method method;
        Method method2;
        NO_PARAM_SIGNATURE = new Class[0];
        NO_PARAMS = new Object[0];
        SINGLE_OBJECT_PARAM_SIGNATURE = new Class[]{Object.class};
        try {
            method2 = ReflectHelper.extractEqualsMethod(Object.class);
            method = ReflectHelper.extractHashCodeMethod(Object.class);
        }
        catch (Exception exception) {
            throw new AssertionFailure("Could not find Object.equals() or Object.hashCode()", exception);
        }
        OBJECT_EQUALS = method2;
        OBJECT_HASHCODE = method;
    }
}

