/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.reflection.java.generics;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

class TypeFactory {
    TypeFactory() {
    }

    static ParameterizedType createParameterizedType(final Type type, final Type[] typeArray, final Type type2) {
        return new ParameterizedType(){

            public Type[] getActualTypeArguments() {
                return typeArray;
            }

            public Type getRawType() {
                return type;
            }

            public Type getOwnerType() {
                return type2;
            }

            public boolean equals(Object object) {
                if (!(object instanceof ParameterizedType)) {
                    return false;
                }
                ParameterizedType parameterizedType = (ParameterizedType)object;
                return Arrays.equals(this.getActualTypeArguments(), parameterizedType.getActualTypeArguments()) && TypeFactory.safeEquals(this.getRawType(), parameterizedType.getRawType()) && TypeFactory.safeEquals(this.getOwnerType(), parameterizedType.getOwnerType());
            }

            public int hashCode() {
                return TypeFactory.safeHashCode(this.getActualTypeArguments()) ^ TypeFactory.safeHashCode(this.getRawType()) ^ TypeFactory.safeHashCode(this.getOwnerType());
            }
        };
    }

    static Type createArrayType(Type type) {
        if (type instanceof Class) {
            return Array.newInstance((Class)type, 0).getClass();
        }
        return TypeFactory.createGenericArrayType(type);
    }

    private static GenericArrayType createGenericArrayType(final Type type) {
        return new GenericArrayType(){

            public Type getGenericComponentType() {
                return type;
            }

            public boolean equals(Object object) {
                if (!(object instanceof GenericArrayType)) {
                    return false;
                }
                GenericArrayType genericArrayType = (GenericArrayType)object;
                return TypeFactory.safeEquals(this.getGenericComponentType(), genericArrayType.getGenericComponentType());
            }

            public int hashCode() {
                return TypeFactory.safeHashCode(this.getGenericComponentType());
            }
        };
    }

    private static boolean safeEquals(Type type, Type type2) {
        if (type == null) {
            return type2 == null;
        }
        return type.equals(type2);
    }

    private static int safeHashCode(Object object) {
        if (object == null) {
            return 1;
        }
        return object.hashCode();
    }
}

