/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.identity;

import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;

@ManagedObject(value="Identity Extension")
public class IdentityExtension
extends AbstractExtension {
    private String id;

    public String getParam(String string) {
        return this.getConfig().getParameter(string, "?");
    }

    @Override
    public String getName() {
        return "identity";
    }

    @Override
    public void incomingFrame(Frame frame) {
        this.nextIncomingFrame(frame);
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
        this.nextOutgoingFrame(frame, writeCallback, batchMode);
    }

    @Override
    public void setConfig(ExtensionConfig extensionConfig) {
        super.setConfig(extensionConfig);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(extensionConfig.getName());
        stringBuilder.append("@").append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[");
        boolean bl = false;
        for (String string : extensionConfig.getParameterKeys()) {
            if (bl) {
                stringBuilder.append(';');
            }
            stringBuilder.append(string).append('=').append(QuotedStringTokenizer.quoteIfNeeded(extensionConfig.getParameter(string, ""), ";="));
            bl = true;
        }
        stringBuilder.append("]");
        this.id = stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.id;
    }
}

