/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.util.zip.DataFormatException;
import org.eclipse.jetty.websocket.api.BadPayloadException;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.extensions.compress.ByteAccumulator;
import org.eclipse.jetty.websocket.common.extensions.compress.CompressExtension;

public class DeflateFrameExtension
extends CompressExtension {
    @Override
    public String getName() {
        return "deflate-frame";
    }

    @Override
    int getRsvUseMode() {
        return 0;
    }

    @Override
    int getTailDropMode() {
        return 1;
    }

    @Override
    public void incomingFrame(Frame frame) {
        if (frame.getType().isControl() || !frame.isRsv1() || !frame.hasPayload()) {
            this.nextIncomingFrame(frame);
            return;
        }
        try (ByteAccumulator byteAccumulator = this.newByteAccumulator();){
            this.decompress(byteAccumulator, frame.getPayload());
            this.decompress(byteAccumulator, TAIL_BYTES_BUF.slice());
            this.forwardIncoming(frame, byteAccumulator);
        }
        catch (DataFormatException dataFormatException) {
            throw new BadPayloadException(dataFormatException);
        }
    }
}

