/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.net.HttpCookie;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.util.QuoteUtil;

public class UpgradeRequestAdapter
implements UpgradeRequest {
    private URI requestURI;
    private List<String> subProtocols = new ArrayList<String>(1);
    private List<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>(1);
    private List<HttpCookie> cookies = new ArrayList<HttpCookie>(1);
    private Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>(1);
    private Object session;
    private String httpVersion;
    private String method;
    private String host;
    private boolean secure;

    protected UpgradeRequestAdapter() {
    }

    public UpgradeRequestAdapter(String string) {
        this(URI.create(string));
    }

    public UpgradeRequestAdapter(URI uRI) {
        this.setRequestURI(uRI);
    }

    @Override
    public void addExtensions(ExtensionConfig ... extensionConfigArray) {
        Collections.addAll(this.extensions, extensionConfigArray);
    }

    @Override
    public void addExtensions(String ... stringArray) {
        for (String string : stringArray) {
            this.extensions.add(ExtensionConfig.parse(string));
        }
    }

    @Override
    public void clearHeaders() {
        this.headers.clear();
    }

    @Override
    public List<HttpCookie> getCookies() {
        return this.cookies;
    }

    @Override
    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    @Override
    public String getHeader(String string) {
        List<String> list = this.headers.get(string);
        if (list == null) {
            return null;
        }
        int n = list.size();
        if (n <= 0) {
            return null;
        }
        if (n == 1) {
            return list.get(0);
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : list) {
            if (bl) {
                stringBuilder.append(", ");
            }
            QuoteUtil.quoteIfNeeded(stringBuilder, string2, "\"'\\\n\r\t\f\b%+ ;=");
            bl = true;
        }
        return stringBuilder.toString();
    }

    @Override
    public int getHeaderInt(String string) {
        List<String> list = this.headers.get(string);
        if (list == null) {
            return -1;
        }
        int n = list.size();
        if (n <= 0) {
            return -1;
        }
        if (n == 1) {
            return Integer.parseInt(list.get(0));
        }
        throw new NumberFormatException("Cannot convert multi-value header into int");
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public List<String> getHeaders(String string) {
        return this.headers.get(string);
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getHttpVersion() {
        return this.httpVersion;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getOrigin() {
        return this.getHeader("Origin");
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public String getProtocolVersion() {
        String string = this.getHeader("Sec-WebSocket-Version");
        if (string == null) {
            return "13";
        }
        return string;
    }

    @Override
    public String getQueryString() {
        return this.requestURI.getQuery();
    }

    @Override
    public URI getRequestURI() {
        return this.requestURI;
    }

    @Override
    public Object getSession() {
        return this.session;
    }

    @Override
    public List<String> getSubProtocols() {
        return this.subProtocols;
    }

    @Override
    public Principal getUserPrincipal() {
        return null;
    }

    @Override
    public boolean hasSubProtocol(String string) {
        for (String string2 : this.subProtocols) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOrigin(String string) {
        return string.equalsIgnoreCase(this.getOrigin());
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public void setCookies(List<HttpCookie> list) {
        this.cookies.clear();
        if (list != null && !list.isEmpty()) {
            this.cookies.addAll(list);
        }
    }

    @Override
    public void setExtensions(List<ExtensionConfig> list) {
        this.extensions.clear();
        if (list != null) {
            this.extensions.addAll(list);
        }
    }

    @Override
    public void setHeader(String string, List<String> list) {
        this.headers.put(string, list);
    }

    @Override
    public void setHeader(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        this.setHeader(string, arrayList);
    }

    @Override
    public void setHeaders(Map<String, List<String>> map) {
        this.clearHeaders();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String string = entry.getKey();
            List<String> list = entry.getValue();
            this.setHeader(string, list);
        }
    }

    @Override
    public void setHttpVersion(String string) {
        this.httpVersion = string;
    }

    @Override
    public void setMethod(String string) {
        this.method = string;
    }

    protected void setParameterMap(Map<String, List<String>> map) {
        this.parameters.clear();
        this.parameters.putAll(map);
    }

    @Override
    public void setRequestURI(URI uRI) {
        this.requestURI = uRI;
        String string = uRI.getScheme();
        if ("ws".equalsIgnoreCase(string)) {
            this.secure = false;
        } else if ("wss".equalsIgnoreCase(string)) {
            this.secure = true;
        } else {
            throw new IllegalArgumentException("URI scheme must be 'ws' or 'wss'");
        }
        this.host = this.requestURI.getHost();
        this.parameters.clear();
    }

    @Override
    public void setSession(Object object) {
        this.session = object;
    }

    @Override
    public void setSubProtocols(List<String> list) {
        this.subProtocols.clear();
        if (list != null) {
            this.subProtocols.addAll(list);
        }
    }

    @Override
    public void setSubProtocols(String ... stringArray) {
        this.subProtocols.clear();
        Collections.addAll(this.subProtocols, stringArray);
    }
}

