/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.WebSocketSessionListener;

public class SessionTracker
extends AbstractLifeCycle
implements WebSocketSessionListener,
Dumpable {
    private final Set<WebSocketSession> sessions = Collections.newSetFromMap(new ConcurrentHashMap());

    public Set<WebSocketSession> getSessions() {
        return Collections.unmodifiableSet(new HashSet<WebSocketSession>(this.sessions));
    }

    @Override
    public void onSessionCreated(WebSocketSession webSocketSession) {
        LifeCycle.start(webSocketSession);
        this.sessions.add(webSocketSession);
    }

    @Override
    public void onSessionClosed(WebSocketSession webSocketSession) {
        this.sessions.remove(webSocketSession);
        LifeCycle.stop(webSocketSession);
    }

    @Override
    protected void doStop() throws Exception {
        for (WebSocketSession webSocketSession : this.sessions) {
            LifeCycle.stop(webSocketSession);
        }
        super.doStop();
    }

    @ManagedAttribute(value="Total number of active WebSocket Sessions")
    public int getNumSessions() {
        return this.sessions.size();
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        Dumpable.dumpObjects(appendable, string, this, this.sessions);
    }
}

