/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.ProtocolException;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Extension;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.OpCode;

public class Generator {
    public static final int MAX_HEADER_LENGTH = 28;
    private final WebSocketBehavior behavior;
    private final ByteBufferPool bufferPool;
    private final boolean validating;
    private final boolean readOnly;
    private byte flagsInUse = 0;

    public Generator(WebSocketPolicy webSocketPolicy, ByteBufferPool byteBufferPool) {
        this(webSocketPolicy, byteBufferPool, true, false);
    }

    public Generator(WebSocketPolicy webSocketPolicy, ByteBufferPool byteBufferPool, boolean bl) {
        this(webSocketPolicy, byteBufferPool, bl, false);
    }

    public Generator(WebSocketPolicy webSocketPolicy, ByteBufferPool byteBufferPool, boolean bl, boolean bl2) {
        this.behavior = webSocketPolicy.getBehavior();
        this.bufferPool = byteBufferPool;
        this.validating = bl;
        this.readOnly = bl2;
    }

    public void assertFrameValid(Frame frame) {
        if (!this.validating) {
            return;
        }
        if (frame.isRsv1() && !this.isRsv1InUse()) {
            throw new ProtocolException("RSV1 not allowed to be set");
        }
        if (frame.isRsv2() && !this.isRsv2InUse()) {
            throw new ProtocolException("RSV2 not allowed to be set");
        }
        if (frame.isRsv3() && !this.isRsv3InUse()) {
            throw new ProtocolException("RSV3 not allowed to be set");
        }
        if (OpCode.isControlFrame(frame.getOpCode())) {
            ByteBuffer byteBuffer;
            if (frame.getPayloadLength() > 125) {
                throw new ProtocolException("Invalid control frame payload length");
            }
            if (!frame.isFin()) {
                throw new ProtocolException("Control Frames must be FIN=true");
            }
            if (frame.getOpCode() == 8 && (byteBuffer = frame.getPayload()) != null) {
                new CloseInfo(byteBuffer, true);
            }
        }
    }

    public void configureFromExtensions(List<? extends Extension> list) {
        this.flagsInUse = 0;
        for (Extension extension : list) {
            if (extension.isRsv1User()) {
                this.flagsInUse = (byte)(this.flagsInUse | 0x40);
            }
            if (extension.isRsv2User()) {
                this.flagsInUse = (byte)(this.flagsInUse | 0x20);
            }
            if (!extension.isRsv3User()) continue;
            this.flagsInUse = (byte)(this.flagsInUse | 0x10);
        }
    }

    public ByteBuffer generateHeaderBytes(Frame frame) {
        ByteBuffer byteBuffer = this.bufferPool.acquire(28, true);
        this.generateHeaderBytes(frame, byteBuffer);
        return byteBuffer;
    }

    public void generateHeaderBytes(Frame frame, ByteBuffer byteBuffer) {
        int n = BufferUtil.flipToFill(byteBuffer);
        this.assertFrameValid(frame);
        byte by = 0;
        if (frame.isFin()) {
            by = (byte)(by | 0x80);
        }
        if (frame.isRsv1()) {
            by = (byte)(by | 0x40);
        }
        if (frame.isRsv2()) {
            by = (byte)(by | 0x20);
        }
        if (frame.isRsv3()) {
            by = (byte)(by | 0x10);
        }
        byte by2 = frame.getOpCode();
        if (frame.getOpCode() == 0) {
            by2 = 0;
        }
        by = (byte)(by | by2 & 0xF);
        byteBuffer.put(by);
        by = frame.isMasked() ? (byte)-128 : 0;
        int n2 = frame.getPayloadLength();
        if (n2 > 65535) {
            by = (byte)(by | 0x7F);
            byteBuffer.put(by);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)(n2 >> 24 & 0xFF));
            byteBuffer.put((byte)(n2 >> 16 & 0xFF));
            byteBuffer.put((byte)(n2 >> 8 & 0xFF));
            byteBuffer.put((byte)(n2 & 0xFF));
        } else if (n2 >= 126) {
            by = (byte)(by | 0x7E);
            byteBuffer.put(by);
            byteBuffer.put((byte)(n2 >> 8));
            byteBuffer.put((byte)(n2 & 0xFF));
        } else {
            by = (byte)(by | n2 & 0x7F);
            byteBuffer.put(by);
        }
        if (frame.isMasked() && !this.readOnly) {
            byte[] byArray = frame.getMask();
            byteBuffer.put(byArray);
            int n3 = 0;
            for (byte n4 : byArray) {
                n3 = (n3 << 8) + (n4 & 0xFF);
            }
            Object object = frame.getPayload();
            if (object != null && ((Buffer)object).remaining() > 0) {
                int n4;
                int n6 = 0;
                int n7 = ((Buffer)object).position();
                int n5 = ((Buffer)object).limit();
                while ((n4 = n5 - n7) > 0) {
                    if (n4 >= 4) {
                        ((ByteBuffer)object).putInt(n7, ((ByteBuffer)object).getInt(n7) ^ n3);
                        n7 += 4;
                        continue;
                    }
                    ((ByteBuffer)object).put(n7, (byte)(((ByteBuffer)object).get(n7) ^ byArray[n6 & 3]));
                    ++n7;
                    ++n6;
                }
            }
        }
        BufferUtil.flipToFlush(byteBuffer, n);
    }

    public void generateWholeFrame(Frame frame, ByteBuffer byteBuffer) {
        byteBuffer.put(this.generateHeaderBytes(frame));
        if (frame.hasPayload()) {
            if (this.readOnly) {
                byteBuffer.put(frame.getPayload().slice());
            } else {
                byteBuffer.put(frame.getPayload());
            }
        }
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public void setRsv1InUse(boolean bl) {
        if (this.readOnly) {
            throw new RuntimeException("Not allowed to modify read-only frame");
        }
        this.flagsInUse = (byte)(this.flagsInUse & 0xBF | (bl ? 64 : 0));
    }

    public void setRsv2InUse(boolean bl) {
        if (this.readOnly) {
            throw new RuntimeException("Not allowed to modify read-only frame");
        }
        this.flagsInUse = (byte)(this.flagsInUse & 0xDF | (bl ? 32 : 0));
    }

    public void setRsv3InUse(boolean bl) {
        if (this.readOnly) {
            throw new RuntimeException("Not allowed to modify read-only frame");
        }
        this.flagsInUse = (byte)(this.flagsInUse & 0xEF | (bl ? 16 : 0));
    }

    public boolean isRsv1InUse() {
        return (this.flagsInUse & 0x40) != 0;
    }

    public boolean isRsv2InUse() {
        return (this.flagsInUse & 0x20) != 0;
    }

    public boolean isRsv3InUse() {
        return (this.flagsInUse & 0x10) != 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Generator[");
        stringBuilder.append((Object)this.behavior);
        if (this.validating) {
            stringBuilder.append(",validating");
        }
        if (this.isRsv1InUse()) {
            stringBuilder.append(",+rsv1");
        }
        if (this.isRsv2InUse()) {
            stringBuilder.append(",+rsv2");
        }
        if (this.isRsv3InUse()) {
            stringBuilder.append(",+rsv3");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

