/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.io.IOException;
import java.net.CookieStore;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.HttpClientProvider;
import org.eclipse.jetty.websocket.client.WebSocketUpgradeRequest;
import org.eclipse.jetty.websocket.client.io.ConnectionManager;
import org.eclipse.jetty.websocket.client.io.UpgradeListener;
import org.eclipse.jetty.websocket.client.masks.Masker;
import org.eclipse.jetty.websocket.client.masks.RandomMasker;
import org.eclipse.jetty.websocket.common.SessionFactory;
import org.eclipse.jetty.websocket.common.SessionTracker;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.WebSocketSessionFactory;
import org.eclipse.jetty.websocket.common.WebSocketSessionListener;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.common.extensions.WebSocketExtensionFactory;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;

public class WebSocketClient
extends ContainerLifeCycle
implements WebSocketContainerScope {
    private static final Logger LOG = Log.getLogger(WebSocketClient.class);
    private final HttpClient httpClient;
    private final Supplier<DecoratedObjectFactory> objectFactorySupplier;
    private final ClassLoader classloader;
    private final WebSocketPolicy policy;
    private final WebSocketExtensionFactory extensionRegistry;
    private final SessionTracker sessionTracker = new SessionTracker();
    private final List<WebSocketSessionListener> sessionListeners = new ArrayList<WebSocketSessionListener>();
    private EventDriverFactory eventDriverFactory;
    private SessionFactory sessionFactory;
    private boolean stopAtShutdown = true;

    public WebSocketClient() {
        this(HttpClientProvider.get(null), null);
    }

    public WebSocketClient(HttpClient httpClient) {
        this(httpClient, null);
    }

    public WebSocketClient(HttpClient httpClient, DecoratedObjectFactory decoratedObjectFactory) {
        this.classloader = Thread.currentThread().getContextClassLoader();
        this.httpClient = Objects.requireNonNull(httpClient, "HttpClient");
        this.addBean(httpClient);
        this.addBean(this.sessionTracker);
        this.addSessionListener(this.sessionTracker);
        this.policy = WebSocketPolicy.newClientPolicy();
        DecoratedObjectFactory decoratedObjectFactory2 = decoratedObjectFactory == null ? new DecoratedObjectFactory() : decoratedObjectFactory;
        this.objectFactorySupplier = () -> decoratedObjectFactory2;
        this.extensionRegistry = new WebSocketExtensionFactory(this);
        this.addBean(this.extensionRegistry);
        this.eventDriverFactory = new EventDriverFactory(this);
        this.sessionFactory = new WebSocketSessionFactory(this);
    }

    @Deprecated
    public WebSocketClient(SslContextFactory sslContextFactory) {
        this(WebSocketClient.newHttpClient(sslContextFactory, null, null), null);
    }

    @Deprecated
    public WebSocketClient(Executor executor) {
        this(WebSocketClient.newHttpClient(null, executor, null), null);
    }

    @Deprecated
    public WebSocketClient(ByteBufferPool byteBufferPool) {
        this(WebSocketClient.newHttpClient(null, null, byteBufferPool), null);
    }

    @Deprecated
    public WebSocketClient(SslContextFactory sslContextFactory, Executor executor) {
        this(WebSocketClient.newHttpClient(sslContextFactory, executor, null), null);
    }

    @Deprecated
    public WebSocketClient(WebSocketContainerScope webSocketContainerScope) {
        this(WebSocketClient.newHttpClient(webSocketContainerScope.getSslContextFactory(), webSocketContainerScope.getExecutor(), webSocketContainerScope.getBufferPool()), webSocketContainerScope.getObjectFactory());
    }

    @Deprecated
    public WebSocketClient(WebSocketContainerScope webSocketContainerScope, SslContextFactory sslContextFactory) {
        this(WebSocketClient.newHttpClient(sslContextFactory, webSocketContainerScope.getExecutor(), webSocketContainerScope.getBufferPool()), webSocketContainerScope.getObjectFactory());
    }

    @Deprecated
    public WebSocketClient(SslContextFactory sslContextFactory, Executor executor, ByteBufferPool byteBufferPool) {
        this(WebSocketClient.newHttpClient(sslContextFactory, executor, byteBufferPool), null);
    }

    @Deprecated
    public WebSocketClient(WebSocketContainerScope webSocketContainerScope, EventDriverFactory eventDriverFactory, SessionFactory sessionFactory) {
        this(webSocketContainerScope, eventDriverFactory, sessionFactory, HttpClientProvider.get(webSocketContainerScope));
    }

    public WebSocketClient(WebSocketContainerScope webSocketContainerScope, EventDriverFactory eventDriverFactory, SessionFactory sessionFactory, HttpClient httpClient) {
        this.classloader = Thread.currentThread().getContextClassLoader();
        this.httpClient = httpClient == null ? HttpClientProvider.get(webSocketContainerScope) : httpClient;
        this.addBean(this.httpClient);
        this.addBean(this.sessionTracker);
        this.addSessionListener(this.sessionTracker);
        this.policy = webSocketContainerScope.getPolicy().delegateAs(WebSocketBehavior.CLIENT);
        this.objectFactorySupplier = webSocketContainerScope::getObjectFactory;
        this.extensionRegistry = new WebSocketExtensionFactory(this);
        this.addBean(this.extensionRegistry);
        this.eventDriverFactory = eventDriverFactory == null ? new EventDriverFactory(this) : eventDriverFactory;
        this.sessionFactory = sessionFactory == null ? new WebSocketSessionFactory(this) : sessionFactory;
    }

    private static HttpClient newHttpClient(SslContextFactory sslContextFactory, Executor executor, ByteBufferPool byteBufferPool) {
        HttpClient httpClient = new HttpClient(sslContextFactory);
        httpClient.setExecutor(executor);
        httpClient.setByteBufferPool(byteBufferPool);
        return httpClient;
    }

    public Future<Session> connect(Object object, URI uRI) throws IOException {
        ClientUpgradeRequest clientUpgradeRequest = new ClientUpgradeRequest(uRI);
        clientUpgradeRequest.setRequestURI(uRI);
        clientUpgradeRequest.setLocalEndpoint(object);
        return this.connect(object, uRI, clientUpgradeRequest);
    }

    public Future<Session> connect(Object object, URI uRI, ClientUpgradeRequest clientUpgradeRequest) throws IOException {
        return this.connect(object, uRI, clientUpgradeRequest, null);
    }

    public Future<Session> connect(Object object, URI uRI, ClientUpgradeRequest clientUpgradeRequest, UpgradeListener upgradeListener) throws IOException {
        if (!this.isStarted()) {
            throw new IllegalStateException(WebSocketClient.class.getSimpleName() + "@" + this.hashCode() + " is not started");
        }
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("WebSocket URI must be absolute");
        }
        if (StringUtil.isBlank(uRI.getScheme())) {
            throw new IllegalArgumentException("WebSocket URI must include a scheme");
        }
        String string = uRI.getScheme().toLowerCase(Locale.ENGLISH);
        if (!"ws".equals(string) && !"wss".equals(string)) {
            throw new IllegalArgumentException("WebSocket URI scheme only supports [ws] and [wss], not [" + string + "]");
        }
        if ("wss".equals(string) && this.httpClient.getSslContextFactory() == null) {
            throw new IllegalStateException("HttpClient has no SslContextFactory, wss:// URI's are not supported in this configuration");
        }
        clientUpgradeRequest.setRequestURI(uRI);
        clientUpgradeRequest.setLocalEndpoint(object);
        for (ExtensionConfig object2 : clientUpgradeRequest.getExtensions()) {
            if (this.extensionRegistry.isAvailable(object2.getName())) continue;
            throw new IllegalArgumentException("Requested extension [" + object2.getName() + "] is not installed");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("connect websocket {} to {}", object, uRI);
        }
        this.init();
        WebSocketUpgradeRequest webSocketUpgradeRequest = new WebSocketUpgradeRequest(this, this.httpClient, clientUpgradeRequest);
        webSocketUpgradeRequest.timeout(clientUpgradeRequest.getTimeout(), TimeUnit.MILLISECONDS);
        webSocketUpgradeRequest.setUpgradeListener(upgradeListener);
        for (Request.Listener listener : this.getBeans(Request.Listener.class)) {
            webSocketUpgradeRequest.listener(listener);
        }
        return webSocketUpgradeRequest.sendAsync();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    public void setEventDriverFactory(EventDriverFactory eventDriverFactory) {
        this.eventDriverFactory = eventDriverFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    protected void doStart() throws Exception {
        Objects.requireNonNull(this.httpClient, "Provided HttpClient is null");
        super.doStart();
        if (!this.httpClient.isRunning()) {
            throw new IllegalStateException("HttpClient is not running (did you forget to start it?): " + this.httpClient);
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping {}", this);
        }
        ShutdownThread.deregister(this);
        this.sessionTracker.stop();
        this.extensionRegistry.stop();
        super.doStop();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopped {}", this);
        }
    }

    @Deprecated
    public boolean isDispatchIO() {
        return this.httpClient.isDispatchIO();
    }

    @Deprecated
    public long getAsyncWriteTimeout() {
        return this.getPolicy().getAsyncWriteTimeout();
    }

    public SocketAddress getBindAddress() {
        return this.httpClient.getBindAddress();
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.httpClient.getByteBufferPool();
    }

    @Deprecated
    public ConnectionManager getConnectionManager() {
        throw new UnsupportedOperationException("ConnectionManager is no longer supported");
    }

    public long getConnectTimeout() {
        return this.httpClient.getConnectTimeout();
    }

    public CookieStore getCookieStore() {
        return this.httpClient.getCookieStore();
    }

    public EventDriverFactory getEventDriverFactory() {
        return this.eventDriverFactory;
    }

    @Override
    public Executor getExecutor() {
        return this.httpClient.getExecutor();
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionRegistry;
    }

    @Deprecated
    public Masker getMasker() {
        return new RandomMasker();
    }

    public int getMaxBinaryMessageBufferSize() {
        return this.getPolicy().getMaxBinaryMessageBufferSize();
    }

    public long getMaxBinaryMessageSize() {
        return this.getPolicy().getMaxBinaryMessageSize();
    }

    public long getMaxIdleTimeout() {
        return this.getPolicy().getIdleTimeout();
    }

    public int getMaxTextMessageBufferSize() {
        return this.getPolicy().getMaxTextMessageBufferSize();
    }

    public long getMaxTextMessageSize() {
        return this.getPolicy().getMaxTextMessageSize();
    }

    @Override
    public DecoratedObjectFactory getObjectFactory() {
        return this.objectFactorySupplier.get();
    }

    public Set<WebSocketSession> getOpenSessions() {
        return this.sessionTracker.getSessions();
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public Scheduler getScheduler() {
        return this.httpClient.getScheduler();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public SslContextFactory getSslContextFactory() {
        return this.httpClient.getSslContextFactory();
    }

    @Override
    public void addSessionListener(WebSocketSessionListener webSocketSessionListener) {
        this.sessionListeners.add(webSocketSessionListener);
    }

    @Override
    public void removeSessionListener(WebSocketSessionListener webSocketSessionListener) {
        this.sessionListeners.remove(webSocketSessionListener);
    }

    @Override
    public Collection<WebSocketSessionListener> getSessionListeners() {
        return this.sessionListeners;
    }

    private synchronized void init() {
        if (this.isStopAtShutdown() && !ShutdownThread.isRegistered(this)) {
            ShutdownThread.register(this);
        }
    }

    @Deprecated
    protected ConnectionManager newConnectionManager() {
        throw new UnsupportedOperationException("ConnectionManager is no longer supported");
    }

    public void setAsyncWriteTimeout(long l) {
        this.getPolicy().setAsyncWriteTimeout(l);
    }

    @Deprecated
    public void setBindAdddress(SocketAddress socketAddress) {
        this.setBindAddress(socketAddress);
    }

    public void setBindAddress(SocketAddress socketAddress) {
        this.httpClient.setBindAddress(socketAddress);
    }

    public void setBufferPool(ByteBufferPool byteBufferPool) {
        this.httpClient.setByteBufferPool(byteBufferPool);
    }

    public void setConnectTimeout(long l) {
        this.httpClient.setConnectTimeout(l);
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.httpClient.setCookieStore(cookieStore);
    }

    @Deprecated
    public void setDaemon(boolean bl) {
    }

    @Deprecated
    public void setDispatchIO(boolean bl) {
        this.httpClient.setDispatchIO(bl);
    }

    public void setExecutor(Executor executor) {
        this.httpClient.setExecutor(executor);
    }

    @Deprecated
    public void setMasker(Masker masker) {
    }

    public void setMaxBinaryMessageBufferSize(int n) {
        this.getPolicy().setMaxBinaryMessageBufferSize(n);
    }

    public void setMaxIdleTimeout(long l) {
        this.getPolicy().setIdleTimeout(l);
        this.httpClient.setIdleTimeout(l);
    }

    public void setMaxTextMessageBufferSize(int n) {
        this.getPolicy().setMaxTextMessageBufferSize(n);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public synchronized void setStopAtShutdown(boolean bl) {
        if (bl) {
            if (!this.stopAtShutdown && this.isStarted() && !ShutdownThread.isRegistered(this)) {
                ShutdownThread.register(this);
            }
        } else {
            ShutdownThread.deregister(this);
        }
        this.stopAtShutdown = bl;
    }

    public boolean isStopAtShutdown() {
        return this.stopAtShutdown;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WebSocketClient)) {
            return false;
        }
        WebSocketClient webSocketClient = (WebSocketClient)object;
        return Objects.equals(this.httpClient, webSocketClient.httpClient) && Objects.equals(this.policy, webSocketClient.policy);
    }

    public int hashCode() {
        return Objects.hash(this.httpClient, this.policy);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("WebSocketClient@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[httpClient=").append(this.httpClient);
        stringBuilder.append(",openSessions.size=");
        stringBuilder.append(this.getOpenSessions().size());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

