/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread.strategy;

import java.util.concurrent.Executor;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Locker;

public class ExecuteProduceConsume
implements ExecutionStrategy,
Runnable {
    private static final Logger LOG = Log.getLogger(ExecuteProduceConsume.class);
    private final Locker _locker = new Locker();
    private final Runnable _runProduce = new RunProduce();
    private final ExecutionStrategy.Producer _producer;
    private final Executor _executor;
    private boolean _idle = true;
    private boolean _execute;
    private boolean _producing;
    private boolean _pending;

    public ExecuteProduceConsume(ExecutionStrategy.Producer producer, Executor executor) {
        this._producer = producer;
        this._executor = executor;
    }

    @Override
    public void produce() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} execute", this);
        }
        boolean bl = false;
        try (Locker.Lock lock = this._locker.lock();){
            if (this._idle) {
                if (this._producing) {
                    throw new IllegalStateException();
                }
                this._producing = true;
                bl = true;
                this._idle = false;
            } else {
                this._execute = true;
            }
        }
        if (bl) {
            this.produceConsume();
        }
    }

    @Override
    public void dispatch() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} spawning", this);
        }
        boolean bl = false;
        try (Locker.Lock lock = this._locker.lock();){
            if (this._idle) {
                bl = true;
            } else {
                this._execute = true;
            }
        }
        if (bl) {
            this._executor.execute(this._runProduce);
        }
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} run", this);
        }
        boolean bl = false;
        try (Locker.Lock lock = this._locker.lock();){
            this._pending = false;
            if (!this._idle && !this._producing) {
                this._producing = true;
                bl = true;
            }
        }
        if (bl) {
            this.produceConsume();
        }
    }

    private void produceConsume() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} produce enter", this);
        }
        while (true) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} producing", this);
            }
            Runnable runnable = this._producer.produce();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} produced {}", this, runnable);
            }
            boolean bl = false;
            Locker.Lock lock = this._locker.lock();
            try {
                this._producing = false;
                if (runnable == null) {
                    if (this._execute) {
                        this._idle = false;
                        this._producing = true;
                        this._execute = false;
                        continue;
                    }
                    this._idle = true;
                    break;
                }
                if (!this._pending) {
                    this._pending = Invocable.getInvocationType(runnable) != Invocable.InvocationType.NON_BLOCKING;
                    bl = this._pending;
                }
                this._execute = false;
            }
            finally {
                if (lock == null) continue;
                lock.close();
                continue;
            }
            if (bl) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} dispatch", this);
                }
                this._executor.execute(this);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} run {}", this, runnable);
            }
            if (runnable != null) {
                runnable.run();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} ran {}", this, runnable);
            }
            lock = this._locker.lock();
            try {
                if (this._producing || this._idle) break;
                this._producing = true;
                continue;
            }
            finally {
                if (lock == null) continue;
                lock.close();
                continue;
            }
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} produce exit", this);
        }
    }

    public Boolean isIdle() {
        try (Locker.Lock lock = this._locker.lock();){
            Boolean bl = this._idle;
            return bl;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EPC ");
        try (Locker.Lock lock = this._locker.lock();){
            stringBuilder.append(this._idle ? "Idle/" : "");
            stringBuilder.append(this._producing ? "Prod/" : "");
            stringBuilder.append(this._pending ? "Pend/" : "");
            stringBuilder.append(this._execute ? "Exec/" : "");
        }
        stringBuilder.append(this._producer);
        return stringBuilder.toString();
    }

    private class RunProduce
    implements Runnable {
        private RunProduce() {
        }

        @Override
        public void run() {
            ExecuteProduceConsume.this.produce();
        }
    }
}

