/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.security;

import java.security.GeneralSecurityException;
import java.security.InvalidParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class CertificateValidator {
    private static final Logger LOG = Log.getLogger(CertificateValidator.class);
    private static AtomicLong __aliasCount = new AtomicLong();
    private KeyStore _trustStore;
    private Collection<? extends CRL> _crls;
    private int _maxCertPathLength = -1;
    private boolean _enableCRLDP = false;
    private boolean _enableOCSP = false;
    private String _ocspResponderURL;

    public CertificateValidator(KeyStore keyStore, Collection<? extends CRL> collection) {
        if (keyStore == null) {
            throw new InvalidParameterException("TrustStore must be specified for CertificateValidator.");
        }
        this._trustStore = keyStore;
        this._crls = collection;
    }

    public void validate(KeyStore keyStore) throws CertificateException {
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                this.validate(keyStore, string);
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw new CertificateException("Unable to retrieve aliases from keystore", keyStoreException);
        }
    }

    public String validate(KeyStore keyStore, String string) throws CertificateException {
        String string2 = null;
        if (string != null) {
            try {
                this.validate(keyStore, keyStore.getCertificate(string));
            }
            catch (KeyStoreException keyStoreException) {
                LOG.debug(keyStoreException);
                throw new CertificateException("Unable to validate certificate for alias [" + string + "]: " + keyStoreException.getMessage(), keyStoreException);
            }
            string2 = string;
        }
        return string2;
    }

    public void validate(KeyStore keyStore, Certificate certificate) throws CertificateException {
        Certificate[] certificateArray = null;
        if (certificate != null && certificate instanceof X509Certificate) {
            ((X509Certificate)certificate).checkValidity();
            String string = null;
            try {
                if (keyStore == null) {
                    throw new InvalidParameterException("Keystore cannot be null");
                }
                string = keyStore.getCertificateAlias(certificate);
                if (string == null) {
                    string = "JETTY" + String.format("%016X", __aliasCount.incrementAndGet());
                    keyStore.setCertificateEntry(string, certificate);
                }
                if ((certificateArray = keyStore.getCertificateChain(string)) == null || certificateArray.length == 0) {
                    throw new IllegalStateException("Unable to retrieve certificate chain");
                }
            }
            catch (KeyStoreException keyStoreException) {
                LOG.debug(keyStoreException);
                throw new CertificateException("Unable to validate certificate" + (string == null ? "" : " for alias [" + string + "]") + ": " + keyStoreException.getMessage(), keyStoreException);
            }
            this.validate(certificateArray);
        }
    }

    public void validate(Certificate[] certificateArray) throws CertificateException {
        try {
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            for (Certificate certificate : certificateArray) {
                if (certificate == null) continue;
                if (!(certificate instanceof X509Certificate)) {
                    throw new IllegalStateException("Invalid certificate type in chain");
                }
                arrayList.add((X509Certificate)certificate);
            }
            if (arrayList.isEmpty()) {
                throw new IllegalStateException("Invalid certificate chain");
            }
            X509CertSelector x509CertSelector = new X509CertSelector();
            x509CertSelector.setCertificate((X509Certificate)arrayList.get(0));
            PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(this._trustStore, (CertSelector)x509CertSelector);
            pKIXBuilderParameters.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(arrayList)));
            pKIXBuilderParameters.setMaxPathLength(this._maxCertPathLength);
            pKIXBuilderParameters.setRevocationEnabled(true);
            if (this._crls != null && !this._crls.isEmpty()) {
                pKIXBuilderParameters.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(this._crls)));
            }
            if (this._enableOCSP) {
                Security.setProperty("ocsp.enable", "true");
            }
            if (this._enableCRLDP) {
                System.setProperty("com.sun.security.enableCRLDP", "true");
            }
            CertPathBuilderResult certPathBuilderResult = CertPathBuilder.getInstance("PKIX").build(pKIXBuilderParameters);
            CertPathValidator.getInstance("PKIX").validate(certPathBuilderResult.getCertPath(), pKIXBuilderParameters);
        }
        catch (GeneralSecurityException generalSecurityException) {
            LOG.debug(generalSecurityException);
            throw new CertificateException("Unable to validate certificate: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    public KeyStore getTrustStore() {
        return this._trustStore;
    }

    public Collection<? extends CRL> getCrls() {
        return this._crls;
    }

    public int getMaxCertPathLength() {
        return this._maxCertPathLength;
    }

    public void setMaxCertPathLength(int n) {
        this._maxCertPathLength = n;
    }

    public boolean isEnableCRLDP() {
        return this._enableCRLDP;
    }

    public void setEnableCRLDP(boolean bl) {
        this._enableCRLDP = bl;
    }

    public boolean isEnableOCSP() {
        return this._enableOCSP;
    }

    public void setEnableOCSP(boolean bl) {
        this._enableOCSP = bl;
    }

    public String getOcspResponderURL() {
        return this._ocspResponderURL;
    }

    public void setOcspResponderURL(String string) {
        this._ocspResponderURL = string;
    }
}

