/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.jetty.util.resource.Resource;

public class ResourceCollection
extends Resource {
    private Resource[] _resources;

    public ResourceCollection() {
        this._resources = new Resource[0];
    }

    public ResourceCollection(Resource ... resourceArray) {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (Resource resource : resourceArray) {
            if (resource == null) continue;
            if (resource instanceof ResourceCollection) {
                Collections.addAll(arrayList, ((ResourceCollection)resource).getResources());
                continue;
            }
            arrayList.add(resource);
        }
        this._resources = arrayList.toArray(new Resource[0]);
        for (Resource resource : this._resources) {
            this.assertResourceValid(resource);
        }
    }

    public ResourceCollection(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this._resources = null;
            return;
        }
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        try {
            for (String string : stringArray) {
                if (string == null || string.length() == 0) {
                    throw new IllegalArgumentException("empty/null resource path not supported");
                }
                Resource resource = Resource.newResource(string);
                this.assertResourceValid(resource);
                arrayList.add(resource);
            }
            if (arrayList.isEmpty()) {
                this._resources = null;
                return;
            }
            this._resources = arrayList.toArray(new Resource[0]);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public ResourceCollection(String string) {
        this.setResourcesAsCSV(string);
    }

    public Resource[] getResources() {
        return this._resources;
    }

    public void setResources(Resource[] resourceArray) {
        if (resourceArray == null || resourceArray.length == 0) {
            this._resources = null;
            return;
        }
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (Resource resource : resourceArray) {
            this.assertResourceValid(resource);
            arrayList.add(resource);
        }
        if (arrayList.isEmpty()) {
            this._resources = null;
            return;
        }
        this._resources = arrayList.toArray(new Resource[0]);
    }

    public void setResourcesAsCSV(String string) {
        if (string == null) {
            throw new IllegalArgumentException("CSV String is null");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            throw new IllegalArgumentException("ResourceCollection@setResourcesAsCSV(String)  argument must be a string containing one or more comma-separated resource strings.");
        }
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.length() == 0) continue;
                Resource resource = Resource.newResource(string2);
                this.assertResourceValid(resource);
                arrayList.add(resource);
            }
            if (arrayList.isEmpty()) {
                this._resources = null;
                return;
            }
            this._resources = arrayList.toArray(new Resource[0]);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Resource addPath(String string) throws IOException {
        int n;
        this.assertResourcesSet();
        if (string == null) {
            throw new MalformedURLException();
        }
        if (string.length() == 0 || "/".equals(string)) {
            return this;
        }
        Resource resource = null;
        ArrayList<Resource> arrayList = null;
        for (n = 0; n < this._resources.length; ++n) {
            resource = this._resources[n].addPath(string);
            if (!resource.exists()) continue;
            if (resource.isDirectory()) break;
            return resource;
        }
        ++n;
        while (n < this._resources.length) {
            Resource resource2 = this._resources[n].addPath(string);
            if (resource2.exists() && resource2.isDirectory()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Resource>();
                }
                if (resource != null) {
                    arrayList.add(resource);
                    resource = null;
                }
                arrayList.add(resource2);
            }
            ++n;
        }
        if (resource != null) {
            return resource;
        }
        if (arrayList != null) {
            return new ResourceCollection(arrayList.toArray(new Resource[0]));
        }
        throw new MalformedURLException();
    }

    @Override
    public boolean delete() throws SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean exists() {
        this.assertResourcesSet();
        return true;
    }

    @Override
    public File getFile() throws IOException {
        this.assertResourcesSet();
        for (Resource resource : this._resources) {
            File file = resource.getFile();
            if (file == null) continue;
            return file;
        }
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.assertResourcesSet();
        for (Resource resource : this._resources) {
            InputStream inputStream = resource.getInputStream();
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    @Override
    public ReadableByteChannel getReadableByteChannel() throws IOException {
        this.assertResourcesSet();
        for (Resource resource : this._resources) {
            ReadableByteChannel readableByteChannel = resource.getReadableByteChannel();
            if (readableByteChannel == null) continue;
            return readableByteChannel;
        }
        return null;
    }

    @Override
    public String getName() {
        this.assertResourcesSet();
        for (Resource resource : this._resources) {
            String string = resource.getName();
            if (string == null) continue;
            return string;
        }
        return null;
    }

    @Override
    public URL getURL() {
        this.assertResourcesSet();
        for (Resource resource : this._resources) {
            URL uRL = resource.getURL();
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }

    @Override
    public boolean isDirectory() {
        this.assertResourcesSet();
        return true;
    }

    @Override
    public long lastModified() {
        this.assertResourcesSet();
        for (Resource resource : this._resources) {
            long l = resource.lastModified();
            if (l == -1L) continue;
            return l;
        }
        return -1L;
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public String[] list() {
        this.assertResourcesSet();
        HashSet hashSet = new HashSet();
        for (Resource resource : this._resources) {
            String[] stringArray = resource.list();
            if (stringArray == null) continue;
            Collections.addAll(hashSet, stringArray);
        }
        Object[] objectArray = hashSet.toArray(new String[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    @Override
    public void close() {
        this.assertResourcesSet();
        for (Resource resource : this._resources) {
            resource.close();
        }
    }

    @Override
    public boolean renameTo(Resource resource) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyTo(File file) throws IOException {
        this.assertResourcesSet();
        int n = this._resources.length;
        while (n-- > 0) {
            this._resources[n].copyTo(file);
        }
    }

    public String toString() {
        if (this._resources == null || this._resources.length == 0) {
            return "[]";
        }
        return String.valueOf(Arrays.asList(this._resources));
    }

    @Override
    public boolean isContainedIn(Resource resource) {
        return false;
    }

    private void assertResourcesSet() {
        if (this._resources == null || this._resources.length == 0) {
            throw new IllegalStateException("*resources* not set.");
        }
    }

    private void assertResourceValid(Resource resource) {
        if (resource == null) {
            throw new IllegalStateException("Null resource not supported");
        }
        if (!resource.exists() || !resource.isDirectory()) {
            throw new IllegalArgumentException(resource + " is not an existing directory.");
        }
    }
}

