/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.FileResource;
import org.eclipse.jetty.util.resource.Resource;

public class PathResource
extends Resource {
    private static final Logger LOG = Log.getLogger(PathResource.class);
    private static final LinkOption[] NO_FOLLOW_LINKS = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    private static final LinkOption[] FOLLOW_LINKS = new LinkOption[0];
    private final Path path;
    private final Path alias;
    private final URI uri;
    private final boolean belongsToDefaultFileSystem;

    private Path checkAliasPath() {
        Path path;
        Path path2 = this.path;
        if (!URIUtil.equalsIgnoreEncodings(this.uri, this.path.toUri())) {
            try {
                return Paths.get(this.uri).toRealPath(FOLLOW_LINKS);
            }
            catch (IOException iOException) {
                LOG.ignore(iOException);
            }
        }
        if (!path2.isAbsolute()) {
            path2 = this.path.toAbsolutePath();
        }
        if (!PathResource.isSameName(path2, path = this.path.normalize())) {
            return path;
        }
        try {
            Path path3;
            if (Files.isSymbolicLink(this.path)) {
                return this.path.getParent().resolve(Files.readSymbolicLink(this.path));
            }
            if (Files.exists(this.path, new LinkOption[0]) && !PathResource.isSameName(path2, path3 = path2.toRealPath(FOLLOW_LINKS))) {
                return path3;
            }
        }
        catch (IOException iOException) {
            LOG.ignore(iOException);
        }
        catch (Exception exception) {
            LOG.warn("bad alias ({} {}) for {}", exception.getClass().getName(), exception.getMessage(), this.path);
        }
        return null;
    }

    public static boolean isSameName(Path path, Path path2) {
        int n;
        int n2 = path.getNameCount();
        if (n2 != (n = path2.getNameCount())) {
            return false;
        }
        int n3 = n;
        while (n3-- > 0) {
            if (path.getName(n3).toString().equals(path2.getName(n3).toString())) continue;
            return false;
        }
        return true;
    }

    public PathResource(File file) {
        this(file.toPath());
    }

    public PathResource(Path path) {
        Path path2;
        block2: {
            path2 = path;
            try {
                path2 = path.toRealPath(NO_FOLLOW_LINKS);
            }
            catch (IOError | IOException throwable) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Unable to get real/canonical path for {}", path, throwable);
            }
        }
        this.path = path2;
        this.assertValidPath(path);
        this.uri = this.path.toUri();
        this.alias = this.checkAliasPath();
        this.belongsToDefaultFileSystem = this.path.getFileSystem() == FileSystems.getDefault();
    }

    private PathResource(PathResource pathResource, String string) {
        this.path = pathResource.path.getFileSystem().getPath(pathResource.path.toString(), string);
        if (this.isDirectory() && !string.endsWith("/")) {
            string = string + "/";
        }
        this.uri = URIUtil.addPath(pathResource.uri, string);
        this.alias = this.checkAliasPath();
        this.belongsToDefaultFileSystem = this.path.getFileSystem() == FileSystems.getDefault();
    }

    public PathResource(URI uRI) throws IOException {
        Path path;
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("not an absolute uri");
        }
        if (!uRI.getScheme().equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("not file: scheme");
        }
        try {
            path = Paths.get(uRI);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            LOG.ignore(exception);
            throw new IOException("Unable to build Path from: " + uRI, exception);
        }
        this.path = path.toAbsolutePath();
        this.uri = path.toUri();
        this.alias = this.checkAliasPath();
        this.belongsToDefaultFileSystem = this.path.getFileSystem() == FileSystems.getDefault();
    }

    public PathResource(URL uRL) throws IOException, URISyntaxException {
        this(uRL.toURI());
    }

    @Override
    public boolean isSame(Resource resource) {
        block4: {
            try {
                if (resource instanceof PathResource) {
                    Path path = ((PathResource)resource).getPath();
                    return Files.isSameFile(this.getPath(), path);
                }
                if (resource instanceof FileResource) {
                    Path path = ((FileResource)resource).getFile().toPath();
                    return Files.isSameFile(this.getPath(), path);
                }
            }
            catch (IOException iOException) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("ignored", iOException);
            }
        }
        return false;
    }

    @Override
    public Resource addPath(String string) throws IOException {
        if (URIUtil.canonicalPath(string) == null) {
            throw new MalformedURLException(string);
        }
        if ("/".equals(string)) {
            return this;
        }
        return new PathResource(this, string);
    }

    private void assertValidPath(Path path) {
        String string = path.toString();
        int n = StringUtil.indexOfControlChars(string);
        if (n >= 0) {
            throw new InvalidPathException(string, "Invalid Character at index " + n);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean delete() throws SecurityException {
        try {
            return Files.deleteIfExists(this.path);
        }
        catch (IOException iOException) {
            LOG.ignore(iOException);
            return false;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PathResource pathResource = (PathResource)object;
        if (this.path == null) {
            return pathResource.path == null;
        }
        return this.path.equals(pathResource.path);
    }

    @Override
    public boolean exists() {
        return Files.exists(this.path, NO_FOLLOW_LINKS);
    }

    @Override
    public File getFile() throws IOException {
        if (!this.belongsToDefaultFileSystem) {
            return null;
        }
        return this.path.toFile();
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.path, StandardOpenOption.READ);
    }

    @Override
    public String getName() {
        return this.path.toAbsolutePath().toString();
    }

    @Override
    public ReadableByteChannel getReadableByteChannel() throws IOException {
        return this.newSeekableByteChannel();
    }

    public SeekableByteChannel newSeekableByteChannel() throws IOException {
        return Files.newByteChannel(this.path, StandardOpenOption.READ);
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public URL getURL() {
        try {
            return this.path.toUri().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.path == null ? 0 : this.path.hashCode());
        return n2;
    }

    @Override
    public boolean isContainedIn(Resource resource) throws MalformedURLException {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.path, FOLLOW_LINKS);
    }

    @Override
    public long lastModified() {
        try {
            FileTime fileTime = Files.getLastModifiedTime(this.path, FOLLOW_LINKS);
            return fileTime.toMillis();
        }
        catch (IOException iOException) {
            LOG.ignore(iOException);
            return 0L;
        }
    }

    @Override
    public long length() {
        try {
            return Files.size(this.path);
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    @Override
    public boolean isAlias() {
        return this.alias != null;
    }

    public Path getAliasPath() {
        return this.alias;
    }

    @Override
    public URI getAlias() {
        return this.alias == null ? null : this.alias.toUri();
    }

    @Override
    public String[] list() {
        String[] stringArray;
        block10: {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.path);
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Path stringArray2 : directoryStream) {
                    String string = stringArray2.getFileName().toString();
                    if (Files.isDirectory(stringArray2, new LinkOption[0])) {
                        string = string + "/";
                    }
                    arrayList.add(string);
                }
                int n = arrayList.size();
                stringArray = arrayList.toArray(new String[n]);
                if (directoryStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | DirectoryIteratorException exception) {
                    LOG.debug(exception);
                    return null;
                }
            }
            directoryStream.close();
        }
        return stringArray;
    }

    @Override
    public boolean renameTo(Resource resource) throws SecurityException {
        if (resource instanceof PathResource) {
            PathResource pathResource = (PathResource)resource;
            try {
                Path path = Files.move(this.path, pathResource.path, new CopyOption[0]);
                return Files.exists(path, NO_FOLLOW_LINKS);
            }
            catch (IOException iOException) {
                LOG.ignore(iOException);
                return false;
            }
        }
        return false;
    }

    @Override
    public void copyTo(File file) throws IOException {
        if (this.isDirectory()) {
            IO.copyDir(this.path.toFile(), file);
        } else {
            Files.copy(this.path, file.toPath(), new CopyOption[0]);
        }
    }

    @Override
    public void writeTo(OutputStream outputStream, long l, long l2) throws IOException {
        long l3 = l2;
        if (l2 < 0L) {
            l3 = Files.size(this.path) - l;
        }
        try (SeekableByteChannel seekableByteChannel = Files.newByteChannel(this.path, StandardOpenOption.READ);){
            int n;
            ByteBuffer byteBuffer = BufferUtil.allocate(65536);
            this.skipTo(seekableByteChannel, byteBuffer, l);
            for (long i = 0L; i < l3; i += (long)n) {
                BufferUtil.clearToFill(byteBuffer);
                int n2 = (int)Math.min(65536L, l3 - i);
                byteBuffer.limit(n2);
                n = seekableByteChannel.read(byteBuffer);
                BufferUtil.flipToFlush(byteBuffer, 0);
                BufferUtil.writeTo(byteBuffer, outputStream);
            }
        }
    }

    private void skipTo(SeekableByteChannel seekableByteChannel, ByteBuffer byteBuffer, long l) throws IOException {
        block6: {
            try {
                if (seekableByteChannel.position() != l) {
                    seekableByteChannel.position(l);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                int n = 3;
                if (l <= 0L) break block6;
                long l2 = 0L;
                int n2 = 3;
                while (n2 > 0 && l2 < l) {
                    BufferUtil.clearToFill(byteBuffer);
                    int n3 = (int)Math.min(65536L, l - l2);
                    byteBuffer.limit(n3);
                    long l3 = seekableByteChannel.read(byteBuffer);
                    if (l3 == 0L) {
                        --n2;
                        continue;
                    }
                    if (l3 > 0L) {
                        l2 += l3;
                        n2 = 3;
                        continue;
                    }
                    throw new IOException("EOF reached before SeekableByteChannel skip destination");
                }
                if (n2 > 0) break block6;
                throw new IOException("No progress made to reach SeekableByteChannel skip position " + l);
            }
        }
    }

    public String toString() {
        return this.uri.toASCIIString();
    }
}

