/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.util.ByteArrayOutputStream2;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.Utf8StringBuffer;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class UrlEncoded
extends MultiMap<String>
implements Cloneable {
    static final Logger LOG;
    public static final Charset ENCODING;

    public UrlEncoded(UrlEncoded urlEncoded) {
        super(urlEncoded);
    }

    public UrlEncoded() {
    }

    public UrlEncoded(String string) {
        UrlEncoded.decodeTo(string, (MultiMap<String>)this, ENCODING);
    }

    public void decode(String string) {
        UrlEncoded.decodeTo(string, (MultiMap<String>)this, ENCODING);
    }

    public void decode(String string, Charset charset) {
        UrlEncoded.decodeTo(string, (MultiMap<String>)this, charset);
    }

    public String encode() {
        return this.encode(ENCODING, false);
    }

    public String encode(Charset charset) {
        return this.encode(charset, false);
    }

    public synchronized String encode(Charset charset, boolean bl) {
        return UrlEncoded.encode(this, charset, bl);
    }

    public static String encode(MultiMap<String> multiMap, Charset charset, boolean bl) {
        if (charset == null) {
            charset = ENCODING;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        boolean bl2 = false;
        for (Map.Entry entry : multiMap.entrySet()) {
            String string = (String)entry.getKey();
            List list = (List)entry.getValue();
            int n = list.size();
            if (bl2) {
                stringBuilder.append('&');
            }
            if (n == 0) {
                stringBuilder.append(UrlEncoded.encodeString(string, charset));
                if (bl) {
                    stringBuilder.append('=');
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuilder.append('&');
                    }
                    String string2 = (String)list.get(i);
                    stringBuilder.append(UrlEncoded.encodeString(string, charset));
                    if (string2 != null) {
                        String string3 = string2;
                        if (string3.length() > 0) {
                            stringBuilder.append('=');
                            stringBuilder.append(UrlEncoded.encodeString(string3, charset));
                            continue;
                        }
                        if (!bl) continue;
                        stringBuilder.append('=');
                        continue;
                    }
                    if (!bl) continue;
                    stringBuilder.append('=');
                }
            }
            bl2 = true;
        }
        return stringBuilder.toString();
    }

    public static void decodeTo(String string, MultiMap<String> multiMap, String string2) {
        UrlEncoded.decodeTo(string, multiMap, string2 == null ? null : Charset.forName(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(String string, MultiMap<String> multiMap, Charset charset) {
        if (charset == null) {
            charset = ENCODING;
        }
        if (StandardCharsets.UTF_8.equals(charset)) {
            UrlEncoded.decodeUtf8To(string, 0, string.length(), multiMap);
            return;
        }
        MultiMap<String> multiMap2 = multiMap;
        synchronized (multiMap2) {
            String string2;
            int n;
            String string3 = null;
            int n2 = -1;
            boolean bl = false;
            block9: for (n = 0; n < string.length(); ++n) {
                char c = string.charAt(n);
                switch (c) {
                    case '&': {
                        int n3 = n - n2 - 1;
                        string2 = n3 == 0 ? "" : (bl ? UrlEncoded.decodeString(string, n2 + 1, n3, charset) : string.substring(n2 + 1, n));
                        n2 = n;
                        bl = false;
                        if (string3 != null) {
                            multiMap.add(string3, string2);
                        } else if (string2 != null && string2.length() > 0) {
                            multiMap.add(string2, "");
                        }
                        string3 = null;
                        string2 = null;
                        continue block9;
                    }
                    case '=': {
                        if (string3 != null) continue block9;
                        string3 = bl ? UrlEncoded.decodeString(string, n2 + 1, n - n2 - 1, charset) : string.substring(n2 + 1, n);
                        n2 = n;
                        bl = false;
                        continue block9;
                    }
                    case '+': {
                        bl = true;
                        continue block9;
                    }
                    case '%': {
                        bl = true;
                    }
                }
            }
            if (string3 != null) {
                n = string.length() - n2 - 1;
                string2 = n == 0 ? "" : (bl ? UrlEncoded.decodeString(string, n2 + 1, n, charset) : string.substring(n2 + 1));
                multiMap.add(string3, string2);
            } else if (n2 < string.length()) {
                String string4 = string3 = bl ? UrlEncoded.decodeString(string, n2 + 1, string.length() - n2 - 1, charset) : string.substring(n2 + 1);
                if (string3 != null && string3.length() > 0) {
                    multiMap.add(string3, "");
                }
            }
        }
    }

    public static void decodeUtf8To(String string, MultiMap<String> multiMap) {
        UrlEncoded.decodeUtf8To(string, 0, string.length(), multiMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(String string, int n, int n2, MultiMap<String> multiMap) {
        Utf8StringBuilder utf8StringBuilder = new Utf8StringBuilder();
        MultiMap<String> multiMap2 = multiMap;
        synchronized (multiMap2) {
            String string2 = null;
            String string3 = null;
            int n3 = n + n2;
            block9: for (int i = n; i < n3; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '&': {
                        string3 = utf8StringBuilder.toReplacedString();
                        utf8StringBuilder.reset();
                        if (string2 != null) {
                            multiMap.add(string2, string3);
                        } else if (string3 != null && string3.length() > 0) {
                            multiMap.add(string3, "");
                        }
                        string2 = null;
                        string3 = null;
                        continue block9;
                    }
                    case '=': {
                        if (string2 != null) {
                            utf8StringBuilder.append(c);
                            continue block9;
                        }
                        string2 = utf8StringBuilder.toReplacedString();
                        utf8StringBuilder.reset();
                        continue block9;
                    }
                    case '+': {
                        utf8StringBuilder.append((byte)32);
                        continue block9;
                    }
                    case '%': {
                        if (i + 2 < n3) {
                            char c2 = string.charAt(++i);
                            char c3 = string.charAt(++i);
                            utf8StringBuilder.append(UrlEncoded.decodeHexByte(c2, c3));
                            continue block9;
                        }
                        throw new Utf8Appendable.NotUtf8Exception("Incomplete % encoding");
                    }
                    default: {
                        utf8StringBuilder.append(c);
                    }
                }
            }
            if (string2 != null) {
                string3 = utf8StringBuilder.toReplacedString();
                utf8StringBuilder.reset();
                multiMap.add(string2, string3);
            } else if (utf8StringBuilder.length() > 0) {
                multiMap.add(utf8StringBuilder.toReplacedString(), "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decode88591To(InputStream inputStream, MultiMap<String> multiMap, int n, int n2) throws IOException {
        MultiMap<String> multiMap2 = multiMap;
        synchronized (multiMap2) {
            int n3;
            StringBuilder stringBuilder = new StringBuilder();
            String string = null;
            String string2 = null;
            int n4 = 0;
            while ((n3 = inputStream.read()) >= 0) {
                switch ((char)n3) {
                    case '&': {
                        string2 = stringBuilder.length() == 0 ? "" : stringBuilder.toString();
                        stringBuilder.setLength(0);
                        if (string != null) {
                            multiMap.add(string, string2);
                        } else if (string2.length() > 0) {
                            multiMap.add(string2, "");
                        }
                        string = null;
                        string2 = null;
                        UrlEncoded.checkMaxKeys(multiMap, n2);
                        break;
                    }
                    case '=': {
                        if (string != null) {
                            stringBuilder.append((char)n3);
                            break;
                        }
                        string = stringBuilder.toString();
                        stringBuilder.setLength(0);
                        break;
                    }
                    case '+': {
                        stringBuilder.append(' ');
                        break;
                    }
                    case '%': {
                        int n5 = inputStream.read();
                        int n6 = inputStream.read();
                        stringBuilder.append(UrlEncoded.decodeHexChar(n5, n6));
                        break;
                    }
                    default: {
                        stringBuilder.append((char)n3);
                    }
                }
                UrlEncoded.checkMaxLength(++n4, n);
            }
            if (string != null) {
                string2 = stringBuilder.length() == 0 ? "" : stringBuilder.toString();
                stringBuilder.setLength(0);
                multiMap.add(string, string2);
            } else if (stringBuilder.length() > 0) {
                multiMap.add(stringBuilder.toString(), "");
            }
            UrlEncoded.checkMaxKeys(multiMap, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(InputStream inputStream, MultiMap<String> multiMap, int n, int n2) throws IOException {
        MultiMap<String> multiMap2 = multiMap;
        synchronized (multiMap2) {
            int n3;
            Utf8StringBuilder utf8StringBuilder = new Utf8StringBuilder();
            String string = null;
            String string2 = null;
            int n4 = 0;
            while ((n3 = inputStream.read()) >= 0) {
                switch ((char)n3) {
                    case '&': {
                        string2 = utf8StringBuilder.toReplacedString();
                        utf8StringBuilder.reset();
                        if (string != null) {
                            multiMap.add(string, string2);
                        } else if (string2 != null && string2.length() > 0) {
                            multiMap.add(string2, "");
                        }
                        string = null;
                        string2 = null;
                        UrlEncoded.checkMaxKeys(multiMap, n2);
                        break;
                    }
                    case '=': {
                        if (string != null) {
                            utf8StringBuilder.append((byte)n3);
                            break;
                        }
                        string = utf8StringBuilder.toReplacedString();
                        utf8StringBuilder.reset();
                        break;
                    }
                    case '+': {
                        utf8StringBuilder.append((byte)32);
                        break;
                    }
                    case '%': {
                        char c = (char)inputStream.read();
                        char c2 = (char)inputStream.read();
                        utf8StringBuilder.append(UrlEncoded.decodeHexByte(c, c2));
                        break;
                    }
                    default: {
                        utf8StringBuilder.append((byte)n3);
                    }
                }
                UrlEncoded.checkMaxLength(++n4, n);
            }
            if (string != null) {
                string2 = utf8StringBuilder.toReplacedString();
                utf8StringBuilder.reset();
                multiMap.add(string, string2);
            } else if (utf8StringBuilder.length() > 0) {
                multiMap.add(utf8StringBuilder.toReplacedString(), "");
            }
            UrlEncoded.checkMaxKeys(multiMap, n2);
        }
    }

    public static void decodeUtf16To(InputStream inputStream, MultiMap<String> multiMap, int n, int n2) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_16);
        StringWriter stringWriter = new StringWriter(8192);
        IO.copy(inputStreamReader, stringWriter, (long)n);
        UrlEncoded.decodeTo(stringWriter.getBuffer().toString(), multiMap, StandardCharsets.UTF_16);
    }

    public static void decodeTo(InputStream inputStream, MultiMap<String> multiMap, String string, int n, int n2) throws IOException {
        if (string == null) {
            if (ENCODING.equals(StandardCharsets.UTF_8)) {
                UrlEncoded.decodeUtf8To(inputStream, multiMap, n, n2);
            } else {
                UrlEncoded.decodeTo(inputStream, multiMap, ENCODING, n, n2);
            }
        } else if ("utf-8".equalsIgnoreCase(string)) {
            UrlEncoded.decodeUtf8To(inputStream, multiMap, n, n2);
        } else if ("iso-8859-1".equalsIgnoreCase(string)) {
            UrlEncoded.decode88591To(inputStream, multiMap, n, n2);
        } else if ("utf-16".equalsIgnoreCase(string)) {
            UrlEncoded.decodeUtf16To(inputStream, multiMap, n, n2);
        } else {
            UrlEncoded.decodeTo(inputStream, multiMap, Charset.forName(string), n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(InputStream inputStream, MultiMap<String> multiMap, Charset charset, int n, int n2) throws IOException {
        if (charset == null) {
            charset = ENCODING;
        }
        if (StandardCharsets.UTF_8.equals(charset)) {
            UrlEncoded.decodeUtf8To(inputStream, multiMap, n, n2);
            return;
        }
        if (StandardCharsets.ISO_8859_1.equals(charset)) {
            UrlEncoded.decode88591To(inputStream, multiMap, n, n2);
            return;
        }
        if (StandardCharsets.UTF_16.equals(charset)) {
            UrlEncoded.decodeUtf16To(inputStream, multiMap, n, n2);
            return;
        }
        MultiMap<String> multiMap2 = multiMap;
        synchronized (multiMap2) {
            String string = null;
            String string2 = null;
            int n3 = 0;
            try (ByteArrayOutputStream2 byteArrayOutputStream2 = new ByteArrayOutputStream2();){
                int n4;
                int n5 = 0;
                while ((n4 = inputStream.read()) > 0) {
                    switch ((char)n4) {
                        case '&': {
                            n5 = byteArrayOutputStream2.size();
                            string2 = n5 == 0 ? "" : byteArrayOutputStream2.toString(charset);
                            byteArrayOutputStream2.setCount(0);
                            if (string != null) {
                                multiMap.add(string, string2);
                            } else if (string2 != null && string2.length() > 0) {
                                multiMap.add(string2, "");
                            }
                            string = null;
                            string2 = null;
                            UrlEncoded.checkMaxKeys(multiMap, n2);
                            break;
                        }
                        case '=': {
                            if (string != null) {
                                byteArrayOutputStream2.write(n4);
                                break;
                            }
                            n5 = byteArrayOutputStream2.size();
                            string = n5 == 0 ? "" : byteArrayOutputStream2.toString(charset);
                            byteArrayOutputStream2.setCount(0);
                            break;
                        }
                        case '+': {
                            byteArrayOutputStream2.write(32);
                            break;
                        }
                        case '%': {
                            int n6 = inputStream.read();
                            int n7 = inputStream.read();
                            byteArrayOutputStream2.write(UrlEncoded.decodeHexChar(n6, n7));
                            break;
                        }
                        default: {
                            byteArrayOutputStream2.write(n4);
                        }
                    }
                    UrlEncoded.checkMaxLength(++n3, n);
                }
                n5 = byteArrayOutputStream2.size();
                if (string != null) {
                    string2 = n5 == 0 ? "" : byteArrayOutputStream2.toString(charset);
                    byteArrayOutputStream2.setCount(0);
                    multiMap.add(string, string2);
                } else if (n5 > 0) {
                    multiMap.add(byteArrayOutputStream2.toString(charset), "");
                }
                UrlEncoded.checkMaxKeys(multiMap, n2);
            }
        }
    }

    private static void checkMaxKeys(MultiMap<String> multiMap, int n) {
        int n2 = multiMap.size();
        if (n >= 0 && n2 > n) {
            throw new IllegalStateException(String.format("Form with too many keys [%d > %d]", n2, n));
        }
    }

    private static void checkMaxLength(int n, int n2) {
        if (n2 >= 0 && n > n2) {
            throw new IllegalStateException("Form is larger than max length " + n2);
        }
    }

    public static String decodeString(String string) {
        return UrlEncoded.decodeString(string, 0, string.length(), ENCODING);
    }

    public static String decodeString(String string, int n, int n2, Charset charset) {
        if (charset == null || StandardCharsets.UTF_8.equals(charset)) {
            Utf8Appendable utf8Appendable = null;
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(n + i);
                if (c < '\u0000' || c > '\u00ff') {
                    if (utf8Appendable == null) {
                        utf8Appendable = new Utf8StringBuffer(n2);
                        ((Utf8StringBuffer)utf8Appendable).getStringBuffer().append(string, n, n + i + 1);
                        continue;
                    }
                    ((Utf8StringBuffer)utf8Appendable).getStringBuffer().append(c);
                    continue;
                }
                if (c == '+') {
                    if (utf8Appendable == null) {
                        utf8Appendable = new Utf8StringBuffer(n2);
                        ((Utf8StringBuffer)utf8Appendable).getStringBuffer().append(string, n, n + i);
                    }
                    ((Utf8StringBuffer)utf8Appendable).getStringBuffer().append(' ');
                    continue;
                }
                if (c == '%') {
                    if (utf8Appendable == null) {
                        utf8Appendable = new Utf8StringBuffer(n2);
                        ((Utf8StringBuffer)utf8Appendable).getStringBuffer().append(string, n, n + i);
                    }
                    if (i + 2 < n2) {
                        int n3 = n + i + 1;
                        i += 2;
                        byte by = (byte)TypeUtil.parseInt(string, n3, 2, 16);
                        utf8Appendable.append(by);
                        continue;
                    }
                    ((Utf8StringBuffer)utf8Appendable).getStringBuffer().append('\ufffd');
                    i = n2;
                    continue;
                }
                if (utf8Appendable == null) continue;
                ((Utf8StringBuffer)utf8Appendable).getStringBuffer().append(c);
            }
            if (utf8Appendable == null) {
                if (n == 0 && string.length() == n2) {
                    return string;
                }
                return string.substring(n, n + n2);
            }
            return utf8Appendable.toReplacedString();
        }
        StringBuffer stringBuffer = null;
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(n + i);
            if (c < '\u0000' || c > '\u00ff') {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n2);
                    stringBuffer.append(string, n, n + i + 1);
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (c == '+') {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n2);
                    stringBuffer.append(string, n, n + i);
                }
                stringBuffer.append(' ');
                continue;
            }
            if (c == '%') {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n2);
                    stringBuffer.append(string, n, n + i);
                }
                byte[] byArray = new byte[n2];
                int n4 = 0;
                while (c >= '\u0000' && c <= '\u00ff') {
                    if (c == '%') {
                        if (i + 2 < n2) {
                            int n5 = n + i + 1;
                            i += 3;
                            byArray[n4] = (byte)TypeUtil.parseInt(string, n5, 2, 16);
                            ++n4;
                        } else {
                            byArray[n4++] = 63;
                            i = n2;
                        }
                    } else if (c == '+') {
                        byArray[n4++] = 32;
                        ++i;
                    } else {
                        byArray[n4++] = (byte)c;
                        ++i;
                    }
                    if (i >= n2) break;
                    c = string.charAt(n + i);
                }
                --i;
                stringBuffer.append(new String(byArray, 0, n4, charset));
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        if (stringBuffer == null) {
            if (n == 0 && string.length() == n2) {
                return string;
            }
            return string.substring(n, n + n2);
        }
        return stringBuffer.toString();
    }

    private static char decodeHexChar(int n, int n2) {
        try {
            return (char)((TypeUtil.convertHexDigit(n) << 4) + TypeUtil.convertHexDigit(n2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Not valid encoding '%" + (char)n + (char)n2 + "'");
        }
    }

    private static byte decodeHexByte(char c, char c2) {
        try {
            return (byte)((TypeUtil.convertHexDigit(c) << 4) + TypeUtil.convertHexDigit(c2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Not valid encoding '%" + c + c2 + "'");
        }
    }

    public static String encodeString(String string) {
        return UrlEncoded.encodeString(string, ENCODING);
    }

    public static String encodeString(String string, Charset charset) {
        if (charset == null) {
            charset = ENCODING;
        }
        byte[] byArray = null;
        byArray = string.getBytes(charset);
        int n = byArray.length;
        byte[] byArray2 = new byte[byArray.length * 3];
        int n2 = 0;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            if (by == 32) {
                bl = false;
                byArray2[n2++] = 43;
                continue;
            }
            if (by >= 97 && by <= 122 || by >= 65 && by <= 90 || by >= 48 && by <= 57 || by == 45 || by == 46 || by == 95 || by == 126) {
                byArray2[n2++] = by;
                continue;
            }
            bl = false;
            byArray2[n2++] = 37;
            byte by2 = (byte)((by & 0xF0) >> 4);
            byArray2[n2++] = by2 >= 10 ? (byte)(65 + by2 - 10) : (byte)(48 + by2);
            by2 = (byte)(by & 0xF);
            byArray2[n2++] = by2 >= 10 ? (byte)(65 + by2 - 10) : (byte)(48 + by2);
        }
        if (bl) {
            return string;
        }
        return new String(byArray2, 0, n2, charset);
    }

    @Override
    public Object clone() {
        return new UrlEncoded(this);
    }

    static {
        Charset charset;
        LOG = Log.getLogger(UrlEncoded.class);
        try {
            String string = System.getProperty("org.eclipse.jetty.util.UrlEncoding.charset");
            charset = string == null ? StandardCharsets.UTF_8 : Charset.forName(string);
        }
        catch (Exception exception) {
            LOG.warn(exception);
            charset = StandardCharsets.UTF_8;
        }
        ENCODING = charset;
    }
}

