/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class TopologicalSort<T> {
    private final Map<T, Set<T>> _dependencies = new HashMap<T, Set<T>>();

    public void addDependency(T t, T t2) {
        Set<T> set = this._dependencies.get(t);
        if (set == null) {
            set = new HashSet<T>();
            this._dependencies.put(t, set);
        }
        set.add(t2);
    }

    public void sort(T[] TArray) {
        ArrayList arrayList = new ArrayList();
        HashSet hashSet = new HashSet();
        InitialOrderComparator<T> initialOrderComparator = new InitialOrderComparator<T>(TArray);
        for (T t : TArray) {
            this.visit(t, hashSet, arrayList, initialOrderComparator);
        }
        arrayList.toArray(TArray);
    }

    public void sort(Collection<T> collection) {
        ArrayList arrayList = new ArrayList();
        HashSet hashSet = new HashSet();
        InitialOrderComparator<T> initialOrderComparator = new InitialOrderComparator<T>(collection);
        for (T t : collection) {
            this.visit(t, hashSet, arrayList, initialOrderComparator);
        }
        collection.clear();
        collection.addAll(arrayList);
    }

    private void visit(T t, Set<T> set, List<T> list, Comparator<T> comparator) {
        if (!set.contains(t)) {
            set.add(t);
            Set<T> set2 = this._dependencies.get(t);
            if (set2 != null) {
                TreeSet<T> treeSet = new TreeSet<T>(comparator);
                treeSet.addAll(set2);
                try {
                    for (Object e : treeSet) {
                        this.visit(e, set, list, comparator);
                    }
                }
                catch (CyclicException cyclicException) {
                    throw new CyclicException(t, cyclicException);
                }
            }
            list.add(t);
        } else if (!list.contains(t)) {
            throw new CyclicException(t);
        }
    }

    public String toString() {
        return "TopologicalSort " + this._dependencies;
    }

    private static class CyclicException
    extends IllegalStateException {
        CyclicException(Object object) {
            super("cyclic at " + object);
        }

        CyclicException(Object object, CyclicException cyclicException) {
            super("cyclic at " + object, cyclicException);
        }
    }

    private static class InitialOrderComparator<T>
    implements Comparator<T> {
        private final Map<T, Integer> _indexes = new HashMap<T, Integer>();

        InitialOrderComparator(T[] TArray) {
            int n = 0;
            for (T t : TArray) {
                this._indexes.put(t, n++);
            }
        }

        InitialOrderComparator(Collection<T> collection) {
            int n = 0;
            for (T t : collection) {
                this._indexes.put(t, n++);
            }
        }

        @Override
        public int compare(T t, T t2) {
            Integer n = this._indexes.get(t);
            Integer n2 = this._indexes.get(t2);
            if (n == null || n2 == null || n.equals(t2)) {
                return 0;
            }
            if (n < n2) {
                return -1;
            }
            return 1;
        }
    }
}

