/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.List;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.NetworkTrafficListener;
import org.eclipse.jetty.io.SocketChannelEndPoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class NetworkTrafficSocketChannelEndPoint
extends SocketChannelEndPoint {
    private static final Logger LOG = Log.getLogger(NetworkTrafficSocketChannelEndPoint.class);
    private final List<NetworkTrafficListener> listeners;

    public NetworkTrafficSocketChannelEndPoint(SelectableChannel selectableChannel, ManagedSelector managedSelector, SelectionKey selectionKey, Scheduler scheduler, long l, List<NetworkTrafficListener> list) {
        super(selectableChannel, managedSelector, selectionKey, scheduler);
        this.setIdleTimeout(l);
        this.listeners = list;
    }

    @Override
    public int fill(ByteBuffer byteBuffer) throws IOException {
        int n = super.fill(byteBuffer);
        this.notifyIncoming(byteBuffer, n);
        return n;
    }

    @Override
    public boolean flush(ByteBuffer ... byteBufferArray) throws IOException {
        boolean bl = true;
        for (ByteBuffer byteBuffer : byteBufferArray) {
            if (!byteBuffer.hasRemaining()) continue;
            int n = byteBuffer.position();
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            bl = super.flush(byteBuffer);
            int n2 = byteBuffer.position() - n;
            byteBuffer2.limit(byteBuffer2.position() + n2);
            this.notifyOutgoing(byteBuffer2);
            if (!bl) break;
        }
        return bl;
    }

    @Override
    public void onOpen() {
        super.onOpen();
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (NetworkTrafficListener networkTrafficListener : this.listeners) {
                try {
                    networkTrafficListener.opened(this.getSocket());
                }
                catch (Exception exception) {
                    LOG.warn(exception);
                }
            }
        }
    }

    @Override
    public void onClose() {
        super.onClose();
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (NetworkTrafficListener networkTrafficListener : this.listeners) {
                try {
                    networkTrafficListener.closed(this.getSocket());
                }
                catch (Exception exception) {
                    LOG.warn(exception);
                }
            }
        }
    }

    public void notifyIncoming(ByteBuffer byteBuffer, int n) {
        if (this.listeners != null && !this.listeners.isEmpty() && n > 0) {
            for (NetworkTrafficListener networkTrafficListener : this.listeners) {
                try {
                    ByteBuffer byteBuffer2 = byteBuffer.asReadOnlyBuffer();
                    networkTrafficListener.incoming(this.getSocket(), byteBuffer2);
                }
                catch (Exception exception) {
                    LOG.warn(exception);
                }
            }
        }
    }

    public void notifyOutgoing(ByteBuffer byteBuffer) {
        if (this.listeners != null && !this.listeners.isEmpty() && byteBuffer.hasRemaining()) {
            Socket socket = this.getSocket();
            for (NetworkTrafficListener networkTrafficListener : this.listeners) {
                try {
                    networkTrafficListener.outgoing(socket, byteBuffer);
                }
                catch (Exception exception) {
                    LOG.warn(exception);
                }
            }
        }
    }
}

