/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferAccumulator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.NullByteBufferPool;

public class ByteBufferOutputStream2
extends OutputStream {
    private final ByteBufferAccumulator _accumulator;
    private int _size = 0;

    public ByteBufferOutputStream2() {
        this(null, false);
    }

    public ByteBufferOutputStream2(ByteBufferPool byteBufferPool, boolean bl) {
        this._accumulator = new ByteBufferAccumulator(byteBufferPool == null ? new NullByteBufferPool() : byteBufferPool, bl);
    }

    public ByteBufferPool getByteBufferPool() {
        return this._accumulator.getByteBufferPool();
    }

    public ByteBuffer takeByteBuffer() {
        return this._accumulator.takeByteBuffer();
    }

    public ByteBuffer toByteBuffer() {
        return this._accumulator.toByteBuffer();
    }

    public byte[] toByteArray() {
        return this._accumulator.toByteArray();
    }

    public int size() {
        return this._size;
    }

    @Override
    public void write(int n) {
        this.write(new byte[]{(byte)n}, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this._size += n2;
        this._accumulator.copyBytes(byArray, n, n2);
    }

    public void write(ByteBuffer byteBuffer) {
        this._size += byteBuffer.remaining();
        this._accumulator.copyBuffer(byteBuffer);
    }

    public void writeTo(ByteBuffer byteBuffer) {
        this._accumulator.writeTo(byteBuffer);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this._accumulator.writeTo(outputStream);
    }

    @Override
    public void close() {
        this._accumulator.close();
        this._size = 0;
    }

    public synchronized String toString() {
        return String.format("%s@%x{size=%d, byteAccumulator=%s}", this.getClass().getSimpleName(), this.hashCode(), this._size, this._accumulator);
    }
}

