/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.http.pathmap.AbstractPathSpec;
import org.eclipse.jetty.http.pathmap.MatchedPath;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.PathSpecGroup;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class UriTemplatePathSpec
extends AbstractPathSpec {
    private static final Logger LOG = Log.getLogger(UriTemplatePathSpec.class);
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{(.*)\\}");
    private static final String VARIABLE_RESERVED = ":/?#[]@!$&'()*+,;=";
    private static final String VARIABLE_SYMBOLS = "-._";
    private static final Set<String> FORBIDDEN_SEGMENTS = new HashSet<String>();
    private final String _declaration;
    private final PathSpecGroup _group;
    private final int _pathDepth;
    private final int _specLength;
    private final Pattern _pattern;
    private final String[] _variables;
    private final String _logicalDeclaration;

    public UriTemplatePathSpec(String string) {
        String j;
        String[] stringArray;
        Objects.requireNonNull(string, "Path Param Spec cannot be null");
        if ("".equals(string) || "/".equals(string)) {
            this._declaration = "/";
            this._group = PathSpecGroup.EXACT;
            this._pathDepth = 1;
            this._specLength = 1;
            this._pattern = Pattern.compile("^/$");
            this._variables = new String[0];
            this._logicalDeclaration = "/";
            return;
        }
        if (string.charAt(0) != '/') {
            throw new IllegalArgumentException("Syntax Error: path spec \"" + string + "\" must start with '/'");
        }
        for (String charSequence2 : FORBIDDEN_SEGMENTS) {
            if (!string.contains(charSequence2)) continue;
            throw new IllegalArgumentException("Syntax Error: segment " + charSequence2 + " is forbidden in path spec: " + string);
        }
        String string3 = string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('^');
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = string.substring(1).split("/");
        char[] cArray = new char[stringArray2.length];
        StringBuilder stringBuilder2 = new StringBuilder();
        int n = stringArray2.length;
        for (int pattern = 0; pattern < stringArray2.length; ++pattern) {
            String n2 = stringArray2[pattern];
            stringArray = VARIABLE_PATTERN.matcher(n2);
            if (stringArray.matches()) {
                j = stringArray.group(1);
                if (arrayList.contains(j)) {
                    throw new IllegalArgumentException("Syntax Error: variable " + j + " is duplicated in path spec: " + string);
                }
                UriTemplatePathSpec.assertIsValidVariableLiteral(j, string3);
                cArray[pattern] = 118;
                stringBuilder2.append("/*");
                arrayList.add(j);
                stringBuilder.append("/([^/]+)");
                continue;
            }
            if (stringArray.find(0)) {
                throw new IllegalArgumentException("Syntax Error: variable " + stringArray.group() + " must exist as entire path segment: " + string);
            }
            if (n2.indexOf(123) >= 0 || n2.indexOf(125) >= 0) {
                throw new IllegalArgumentException("Syntax Error: invalid path segment /" + n2 + "/ variable declaration incomplete: " + string);
            }
            if (n2.indexOf(42) >= 0) {
                throw new IllegalArgumentException("Syntax Error: path segment /" + n2 + "/ contains a wildcard symbol (not supported by this uri-template implementation): " + string);
            }
            cArray[pattern] = 101;
            stringBuilder2.append('/').append(n2);
            stringBuilder.append('/');
            for (int i = 0; i < n2.length(); ++i) {
                char pathSpecGroup = n2.charAt(i);
                if (pathSpecGroup == '.' || pathSpecGroup == '[' || pathSpecGroup == ']' || pathSpecGroup == '\\') {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(pathSpecGroup);
            }
        }
        if (string.charAt(string.length() - 1) == '/') {
            stringBuilder.append('/');
            stringBuilder2.append('/');
        }
        stringBuilder.append('$');
        Pattern pattern = Pattern.compile(stringBuilder.toString());
        int n2 = arrayList.size();
        stringArray = arrayList.toArray(new String[n2]);
        j = String.valueOf(cArray);
        PathSpecGroup pathSpecGroup = Pattern.matches("^e*$", j) ? PathSpecGroup.EXACT : (Pattern.matches("^e*v+", j) ? PathSpecGroup.PREFIX_GLOB : (Pattern.matches("^v+e+", j) ? PathSpecGroup.SUFFIX_GLOB : PathSpecGroup.MIDDLE_GLOB));
        this._declaration = string3;
        this._group = pathSpecGroup;
        this._pathDepth = n;
        this._specLength = string3.length();
        this._pattern = pattern;
        this._variables = stringArray;
        this._logicalDeclaration = stringBuilder2.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating UriTemplatePathSpec[{}] (regex: \"{}\", signature: [{}], group: {}, variables: [{}])", new Object[]{this._declaration, stringBuilder, j, this._group, String.join((CharSequence)", ", this._variables)});
        }
    }

    private static void assertIsValidVariableLiteral(String string, String string2) {
        boolean bl;
        int n = string.length();
        int n2 = 0;
        boolean bl2 = bl = n > 0;
        while (bl && n2 < n) {
            int n3 = string.codePointAt(n2);
            n2 += Character.charCount(n3);
            if (UriTemplatePathSpec.isValidBasicLiteralCodepoint(n3, string2) || Character.isSupplementaryCodePoint(n3)) continue;
            if (n3 == 37) {
                if (n2 + 2 > n) {
                    bl = false;
                    continue;
                }
                n3 = TypeUtil.convertHexDigit(string.codePointAt(n2++)) << 4;
                if (UriTemplatePathSpec.isValidBasicLiteralCodepoint(n3 |= TypeUtil.convertHexDigit(string.codePointAt(n2++)), string2)) continue;
            }
            bl = false;
        }
        if (!bl) {
            throw new IllegalArgumentException("Syntax Error: variable {" + string + "} an invalid variable name: " + string2);
        }
    }

    private static boolean isValidBasicLiteralCodepoint(int n, String string) {
        if (n >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57) {
            return true;
        }
        if (VARIABLE_SYMBOLS.indexOf(n) >= 0) {
            return true;
        }
        if (VARIABLE_RESERVED.indexOf(n) >= 0) {
            LOG.warn("Detected URI Template reserved symbol [{}] in path spec \"{}\"", Character.valueOf((char)n), string);
            return false;
        }
        return false;
    }

    @Override
    public int compareTo(PathSpec pathSpec) {
        if (pathSpec instanceof UriTemplatePathSpec) {
            UriTemplatePathSpec uriTemplatePathSpec = (UriTemplatePathSpec)pathSpec;
            return uriTemplatePathSpec._logicalDeclaration.compareTo(this._logicalDeclaration);
        }
        return super.compareTo(pathSpec);
    }

    public Map<String, String> getPathParams(String string) {
        Matcher matcher = this.getMatcher(string);
        if (matcher.matches()) {
            if (this._group == PathSpecGroup.EXACT) {
                return Collections.emptyMap();
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n = matcher.groupCount();
            for (int i = 1; i <= n; ++i) {
                hashMap.put(this._variables[i - 1], matcher.group(i));
            }
            return hashMap;
        }
        return null;
    }

    protected Matcher getMatcher(String string) {
        int n = string.indexOf(63);
        if (n >= 0) {
            return this._pattern.matcher(string.substring(0, n));
        }
        return this._pattern.matcher(string);
    }

    @Override
    public int getSpecLength() {
        return this._specLength;
    }

    @Override
    public PathSpecGroup getGroup() {
        return this._group;
    }

    @Override
    public int getPathDepth() {
        return this._pathDepth;
    }

    @Override
    public String getPathInfo(String string) {
        Matcher matcher;
        if (this._group == PathSpecGroup.PREFIX_GLOB && (matcher = this.getMatcher(string)).matches() && matcher.groupCount() >= 1) {
            String string2 = matcher.group(1);
            if ("".equals(string2)) {
                return "/";
            }
            return string2;
        }
        return null;
    }

    @Override
    public String getPathMatch(String string) {
        Matcher matcher = this.getMatcher(string);
        if (matcher.matches()) {
            int n;
            if (this._group == PathSpecGroup.PREFIX_GLOB && matcher.groupCount() >= 1 && (n = matcher.start(1)) > 0) {
                if (string.charAt(n - 1) == '/') {
                    --n;
                }
                return string.substring(0, n);
            }
            return string;
        }
        return null;
    }

    @Override
    public String getDeclaration() {
        return this._declaration;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public String getSuffix() {
        return null;
    }

    public Pattern getPattern() {
        return this._pattern;
    }

    @Override
    public boolean matches(String string) {
        return this.getMatcher(string).matches();
    }

    @Override
    public MatchedPath matched(String string) {
        Matcher matcher = this.getMatcher(string);
        if (matcher.matches()) {
            return new UriTemplateMatchedPath(this, string, matcher);
        }
        return null;
    }

    public int getVariableCount() {
        return this._variables.length;
    }

    public String[] getVariables() {
        return this._variables;
    }

    static {
        FORBIDDEN_SEGMENTS.add("/./");
        FORBIDDEN_SEGMENTS.add("/../");
        FORBIDDEN_SEGMENTS.add("//");
    }

    private static class UriTemplateMatchedPath
    implements MatchedPath {
        private final UriTemplatePathSpec pathSpec;
        private final String path;
        private final Matcher matcher;

        public UriTemplateMatchedPath(UriTemplatePathSpec uriTemplatePathSpec, String string, Matcher matcher) {
            this.pathSpec = uriTemplatePathSpec;
            this.path = string;
            this.matcher = matcher;
        }

        @Override
        public String getPathMatch() {
            int n;
            if (this.pathSpec.getGroup() == PathSpecGroup.PREFIX_GLOB && this.matcher.groupCount() >= 1 && (n = this.matcher.start(1)) > 0) {
                if (this.path.charAt(n - 1) == '/') {
                    --n;
                }
                return this.path.substring(0, n);
            }
            return this.path;
        }

        @Override
        public String getPathInfo() {
            if (this.pathSpec.getGroup() == PathSpecGroup.PREFIX_GLOB && this.matcher.groupCount() >= 1) {
                String string = this.matcher.group(1);
                if ("".equals(string)) {
                    return "/";
                }
                return string;
            }
            return null;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[pathSpec=" + this.pathSpec + ", path=\"" + this.path + "\", matcher=" + this.matcher + ']';
        }
    }
}

