/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Part;
import org.eclipse.jetty.http.MultiPartParser;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ByteArrayOutputStream2;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class MultiPartFormInputStream {
    private static final Logger LOG = Log.getLogger(MultiPartFormInputStream.class);
    private static final int DEFAULT_MAX_FORM_KEYS = 1000;
    private static final MultiMap<Part> EMPTY_MAP = new MultiMap(Collections.emptyMap());
    private final EnumSet<NonCompliance> _nonComplianceWarnings = EnumSet.noneOf(NonCompliance.class);
    private final MultiMap<Part> _parts;
    private final int _maxParts;
    private int _numParts = 0;
    private InputStream _in;
    private MultipartConfigElement _config;
    private String _contentType;
    private Throwable _err;
    private File _tmpDir;
    private File _contextTmpDir;
    private boolean _writeFilesWithFilenames;
    private boolean _parsed;
    private int _bufferSize = 16384;

    public EnumSet<NonCompliance> getNonComplianceWarnings() {
        return this._nonComplianceWarnings;
    }

    public MultiPartFormInputStream(InputStream inputStream, String string, MultipartConfigElement multipartConfigElement, File file) {
        this(inputStream, string, multipartConfigElement, file, 1000);
    }

    public MultiPartFormInputStream(InputStream inputStream, String string, MultipartConfigElement multipartConfigElement, File file, int n) {
        this._contentType = string;
        this._config = multipartConfigElement;
        this._contextTmpDir = file;
        this._maxParts = n;
        if (this._contextTmpDir == null) {
            this._contextTmpDir = new File(System.getProperty("java.io.tmpdir"));
        }
        if (this._config == null) {
            this._config = new MultipartConfigElement(this._contextTmpDir.getAbsolutePath());
        }
        MultiMap<Object> multiMap = new MultiMap();
        if (inputStream instanceof ServletInputStream && ((ServletInputStream)inputStream).isFinished()) {
            multiMap = EMPTY_MAP;
            this._parsed = true;
        }
        if (!this._parsed) {
            this._in = new BufferedInputStream(inputStream);
        }
        this._parts = multiMap;
    }

    public boolean isEmpty() {
        if (this._parts == null) {
            return true;
        }
        Collection collection = this._parts.values();
        for (List list : collection) {
            if (list.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public Collection<Part> getParsedParts() {
        if (this._parts == null) {
            return Collections.emptyList();
        }
        Collection collection = this._parts.values();
        ArrayList<Part> arrayList = new ArrayList<Part>();
        for (List list : collection) {
            List list2 = LazyList.getList(list, false);
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public void deleteParts() {
        MultiException multiException = null;
        for (List list : this._parts.values()) {
            for (Part part : list) {
                try {
                    ((MultiPart)part).cleanUp();
                }
                catch (Exception exception) {
                    if (multiException == null) {
                        multiException = new MultiException();
                    }
                    multiException.add(exception);
                }
            }
        }
        this._parts.clear();
        if (multiException != null) {
            multiException.ifExceptionThrowRuntime();
        }
    }

    public Collection<Part> getParts() throws IOException {
        if (!this._parsed) {
            this.parse();
        }
        this.throwIfError();
        if (this._parts.isEmpty()) {
            return Collections.emptyList();
        }
        Collection collection = this._parts.values();
        ArrayList<Part> arrayList = new ArrayList<Part>();
        for (List list : collection) {
            List list2 = LazyList.getList(list, false);
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public Part getPart(String string) throws IOException {
        if (!this._parsed) {
            this.parse();
        }
        this.throwIfError();
        return this._parts.getValue(string, 0);
    }

    protected void throwIfError() throws IOException {
        if (this._err != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("MultiPart parsing failure ", this._err);
            }
            this._err.addSuppressed(new Throwable());
            if (this._err instanceof IOException) {
                throw (IOException)this._err;
            }
            if (this._err instanceof IllegalStateException) {
                throw (IllegalStateException)this._err;
            }
            throw new IllegalStateException(this._err);
        }
    }

    protected void parse() {
        block14: {
            if (this._parsed) {
                return;
            }
            this._parsed = true;
            MultiPartParser multiPartParser = null;
            Handler handler = new Handler();
            try {
                block13: {
                    Object object;
                    if (this._contentType == null || !this._contentType.startsWith("multipart/form-data")) {
                        return;
                    }
                    this._tmpDir = this._config.getLocation() == null ? this._contextTmpDir : ("".equals(this._config.getLocation()) ? this._contextTmpDir : (((File)(object = new File(this._config.getLocation()))).isAbsolute() ? object : new File(this._contextTmpDir, this._config.getLocation())));
                    if (!this._tmpDir.exists()) {
                        this._tmpDir.mkdirs();
                    }
                    object = "";
                    int n = this._contentType.indexOf("boundary=");
                    if (n >= 0) {
                        int n2 = this._contentType.indexOf(";", n);
                        n2 = n2 < 0 ? this._contentType.length() : n2;
                        object = QuotedStringTokenizer.unquote(MultiPartFormInputStream.value(this._contentType.substring(n, n2)).trim());
                    }
                    multiPartParser = new MultiPartParser(handler, (String)object);
                    byte[] byArray = new byte[this._bufferSize];
                    long l = 0L;
                    while (true) {
                        int n3;
                        if ((n3 = this._in.read(byArray)) > 0) {
                            if (this._config.getMaxRequestSize() > 0L && (l += (long)n3) > this._config.getMaxRequestSize()) {
                                this._err = new IllegalStateException("Request exceeds maxRequestSize (" + this._config.getMaxRequestSize() + ")");
                                return;
                            }
                            ByteBuffer byteBuffer = BufferUtil.toBuffer(byArray);
                            byteBuffer.limit(n3);
                            if (!multiPartParser.parse(byteBuffer, false)) {
                                if (!byteBuffer.hasRemaining()) continue;
                                throw new IllegalStateException("Buffer did not fully consume");
                            }
                            break block13;
                        }
                        if (n3 == -1) break;
                    }
                    multiPartParser.parse(BufferUtil.EMPTY_BUFFER, true);
                }
                if (this._err != null) {
                    return;
                }
                if (multiPartParser.getState() != MultiPartParser.State.END) {
                    this._err = multiPartParser.getState() == MultiPartParser.State.PREAMBLE ? new IOException("Missing initial multi part boundary") : new IOException("Incomplete Multipart");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parsing Complete {} err={}", multiPartParser, this._err);
                }
            }
            catch (Throwable throwable) {
                this._err = throwable;
                if (multiPartParser == null) break block14;
                multiPartParser.parse(BufferUtil.EMPTY_BUFFER, true);
            }
        }
    }

    @Deprecated
    public void setDeleteOnExit(boolean bl) {
    }

    public void setWriteFilesWithFilenames(boolean bl) {
        this._writeFilesWithFilenames = bl;
    }

    public boolean isWriteFilesWithFilenames() {
        return this._writeFilesWithFilenames;
    }

    @Deprecated
    public boolean isDeleteOnExit() {
        return false;
    }

    private static String value(String string) {
        int n = string.indexOf(61);
        String string2 = string.substring(n + 1).trim();
        return QuotedStringTokenizer.unquoteOnly(string2);
    }

    private static String filenameValue(String string) {
        int n = string.indexOf(61);
        String string2 = string.substring(n + 1).trim();
        if (string2.matches(".??[a-z,A-Z]\\:\\\\[^\\\\].*")) {
            char c;
            char c2 = string2.charAt(0);
            if (c2 == '\"' || c2 == '\'') {
                string2 = string2.substring(1);
            }
            if ((c = string2.charAt(string2.length() - 1)) == '\"' || c == '\'') {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
        return QuotedStringTokenizer.unquoteOnly(string2, true);
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int n) {
        this._bufferSize = n;
    }

    class Handler
    implements MultiPartParser.Handler {
        private MultiPart _part = null;
        private String contentDisposition = null;
        private String contentType = null;
        private MultiMap<String> headers = new MultiMap();

        Handler() {
        }

        @Override
        public boolean messageComplete() {
            return true;
        }

        @Override
        public void parsedField(String string, String string2) {
            this.headers.put(StringUtil.asciiToLowerCase(string), string2);
            if (string.equalsIgnoreCase("content-disposition")) {
                this.contentDisposition = string2;
            } else if (string.equalsIgnoreCase("content-type")) {
                this.contentType = string2;
            }
            if (string.equalsIgnoreCase("content-transfer-encoding") && !"8bit".equalsIgnoreCase(string2) && !"binary".equalsIgnoreCase(string2)) {
                MultiPartFormInputStream.this._nonComplianceWarnings.add(NonCompliance.TRANSFER_ENCODING);
            }
        }

        @Override
        public boolean headerComplete() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("headerComplete {}", this);
            }
            try {
                boolean bl = false;
                if (this.contentDisposition == null) {
                    throw new IOException("Missing content-disposition");
                }
                QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(this.contentDisposition, ";", false, true);
                String string = null;
                String string2 = null;
                while (quotedStringTokenizer.hasMoreTokens()) {
                    String string3 = quotedStringTokenizer.nextToken().trim();
                    String string4 = StringUtil.asciiToLowerCase(string3);
                    if (string4.startsWith("form-data")) {
                        bl = true;
                        continue;
                    }
                    if (string4.startsWith("name=")) {
                        string = MultiPartFormInputStream.value(string3);
                        continue;
                    }
                    if (!string4.startsWith("filename=")) continue;
                    string2 = MultiPartFormInputStream.filenameValue(string3);
                }
                if (!bl) {
                    throw new IOException("Part not form-data");
                }
                if (string == null) {
                    throw new IOException("No name in part");
                }
                this._part = new MultiPart(string, string2);
                this._part.setHeaders(this.headers);
                this._part.setContentType(this.contentType);
                MultiPartFormInputStream.this._parts.add(string, this._part);
                try {
                    this._part.open();
                }
                catch (IOException iOException) {
                    MultiPartFormInputStream.this._err = iOException;
                    return true;
                }
            }
            catch (Exception exception) {
                MultiPartFormInputStream.this._err = exception;
                return true;
            }
            return false;
        }

        @Override
        public boolean content(ByteBuffer byteBuffer, boolean bl) {
            if (this._part == null) {
                return false;
            }
            if (BufferUtil.hasContent(byteBuffer)) {
                try {
                    this._part.write(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                }
                catch (IOException iOException) {
                    MultiPartFormInputStream.this._err = iOException;
                    return true;
                }
            }
            if (bl) {
                try {
                    this._part.close();
                }
                catch (IOException iOException) {
                    MultiPartFormInputStream.this._err = iOException;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void startPart() {
            this.reset();
            MultiPartFormInputStream.this._numParts++;
            if (MultiPartFormInputStream.this._maxParts >= 0 && MultiPartFormInputStream.this._numParts > MultiPartFormInputStream.this._maxParts) {
                throw new IllegalStateException(String.format("Form with too many parts [%d > %d]", MultiPartFormInputStream.this._numParts, MultiPartFormInputStream.this._maxParts));
            }
        }

        @Override
        public void earlyEOF() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Early EOF {}", MultiPartFormInputStream.this);
            }
            try {
                if (this._part != null) {
                    this._part.close();
                }
            }
            catch (IOException iOException) {
                LOG.warn("part could not be closed", iOException);
            }
        }

        public void reset() {
            this._part = null;
            this.contentDisposition = null;
            this.contentType = null;
            this.headers = new MultiMap();
        }
    }

    public class MultiPart
    implements Part {
        protected String _name;
        protected String _filename;
        protected File _file;
        protected OutputStream _out;
        protected ByteArrayOutputStream2 _bout;
        protected String _contentType;
        protected MultiMap<String> _headers;
        protected long _size = 0L;
        protected boolean _temporary = true;

        public MultiPart(String string, String string2) {
            this._name = string;
            this._filename = string2;
        }

        public String toString() {
            return String.format("Part{n=%s,fn=%s,ct=%s,s=%d,tmp=%b,file=%s}", this._name, this._filename, this._contentType, this._size, this._temporary, this._file);
        }

        protected void setContentType(String string) {
            this._contentType = string;
        }

        protected void open() throws IOException {
            if (MultiPartFormInputStream.this.isWriteFilesWithFilenames() && this._filename != null && !this._filename.trim().isEmpty()) {
                this.createFile();
            } else {
                this._bout = new ByteArrayOutputStream2();
                this._out = this._bout;
            }
        }

        protected void close() throws IOException {
            this._out.close();
        }

        protected void write(int n) throws IOException {
            if (MultiPartFormInputStream.this._config.getMaxFileSize() > 0L && this._size + 1L > MultiPartFormInputStream.this._config.getMaxFileSize()) {
                throw new IllegalStateException("Multipart Mime part " + this._name + " exceeds max filesize");
            }
            if (MultiPartFormInputStream.this._config.getFileSizeThreshold() > 0 && this._size + 1L > (long)MultiPartFormInputStream.this._config.getFileSizeThreshold() && this._file == null) {
                this.createFile();
            }
            this._out.write(n);
            ++this._size;
        }

        protected void write(byte[] byArray, int n, int n2) throws IOException {
            if (MultiPartFormInputStream.this._config.getMaxFileSize() > 0L && this._size + (long)n2 > MultiPartFormInputStream.this._config.getMaxFileSize()) {
                throw new IllegalStateException("Multipart Mime part " + this._name + " exceeds max filesize");
            }
            if (MultiPartFormInputStream.this._config.getFileSizeThreshold() > 0 && this._size + (long)n2 > (long)MultiPartFormInputStream.this._config.getFileSizeThreshold() && this._file == null) {
                this.createFile();
            }
            this._out.write(byArray, n, n2);
            this._size += (long)n2;
        }

        protected void createFile() throws IOException {
            Path path = MultiPartFormInputStream.this._tmpDir.toPath();
            Path path2 = Files.createTempFile(path, "MultiPart", "", new FileAttribute[0]);
            this._file = path2.toFile();
            OutputStream outputStream = Files.newOutputStream(path2, StandardOpenOption.WRITE);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            if (this._size > 0L && this._out != null) {
                this._out.flush();
                this._bout.writeTo(bufferedOutputStream);
                this._out.close();
            }
            this._bout = null;
            this._out = bufferedOutputStream;
        }

        protected void setHeaders(MultiMap<String> multiMap) {
            this._headers = multiMap;
        }

        public String getContentType() {
            return this._contentType;
        }

        public String getHeader(String string) {
            if (string == null) {
                return null;
            }
            return this._headers.getValue(StringUtil.asciiToLowerCase(string), 0);
        }

        public Collection<String> getHeaderNames() {
            return this._headers.keySet();
        }

        public Collection<String> getHeaders(String string) {
            List<String> list = this._headers.getValues(string);
            return list == null ? Collections.emptyList() : list;
        }

        public InputStream getInputStream() throws IOException {
            if (this._file != null) {
                return new BufferedInputStream(new FileInputStream(this._file));
            }
            return new ByteArrayInputStream(this._bout.getBuf(), 0, this._bout.size());
        }

        public String getSubmittedFileName() {
            return this.getContentDispositionFilename();
        }

        public byte[] getBytes() {
            if (this._bout != null) {
                return this._bout.toByteArray();
            }
            return null;
        }

        public String getName() {
            return this._name;
        }

        public long getSize() {
            return this._size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(String string) throws IOException {
            block9: {
                if (this._file == null) {
                    this._temporary = false;
                    this._file = new File(MultiPartFormInputStream.this._tmpDir, string);
                    try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this._file));){
                        this._bout.writeTo(bufferedOutputStream);
                        bufferedOutputStream.flush();
                        break block9;
                    }
                    finally {
                        this._bout = null;
                    }
                }
                this._temporary = false;
                Path path = this._file.toPath();
                Path path2 = path.resolveSibling(string);
                Files.move(path, path2, StandardCopyOption.REPLACE_EXISTING);
                this._file = path2.toFile();
            }
        }

        public void delete() throws IOException {
            if (this._file != null && this._file.exists() && !this._file.delete()) {
                throw new IOException("Could Not Delete File");
            }
        }

        public void cleanUp() throws IOException {
            if (this._temporary) {
                this.delete();
            }
        }

        public File getFile() {
            return this._file;
        }

        public String getContentDispositionFilename() {
            return this._filename;
        }
    }

    public static enum NonCompliance {
        TRANSFER_ENCODING("https://tools.ietf.org/html/rfc7578#section-4.7");

        final String _rfcRef;

        private NonCompliance(String string2) {
            this._rfcRef = string2;
        }

        public String getURL() {
            return this._rfcRef;
        }
    }
}

