/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.client.AsyncContentProvider;
import org.eclipse.jetty.client.Synchronizable;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.util.AbstractTypedContentProvider;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class MultiPartContentProvider
extends AbstractTypedContentProvider
implements AsyncContentProvider,
Closeable {
    private static final Logger LOG = Log.getLogger(MultiPartContentProvider.class);
    private static final byte[] COLON_SPACE_BYTES = new byte[]{58, 32};
    private static final byte[] CR_LF_BYTES = new byte[]{13, 10};
    private final List<Part> parts = new ArrayList<Part>();
    private final ByteBuffer firstBoundary;
    private final ByteBuffer middleBoundary;
    private final ByteBuffer onlyBoundary;
    private final ByteBuffer lastBoundary;
    private final AtomicBoolean closed = new AtomicBoolean();
    private AsyncContentProvider.Listener listener;
    private long length = -1L;

    public MultiPartContentProvider() {
        this(MultiPartContentProvider.makeBoundary());
    }

    public MultiPartContentProvider(String string) {
        super("multipart/form-data; boundary=" + string);
        String string2 = "--" + string + "\r\n";
        this.firstBoundary = ByteBuffer.wrap(string2.getBytes(StandardCharsets.US_ASCII));
        String string3 = "\r\n" + string2;
        this.middleBoundary = ByteBuffer.wrap(string3.getBytes(StandardCharsets.US_ASCII));
        String string4 = "--" + string + "--\r\n";
        this.onlyBoundary = ByteBuffer.wrap(string4.getBytes(StandardCharsets.US_ASCII));
        String string5 = "\r\n" + string4;
        this.lastBoundary = ByteBuffer.wrap(string5.getBytes(StandardCharsets.US_ASCII));
    }

    private static String makeBoundary() {
        StringBuilder stringBuilder = new StringBuilder("JettyHttpClientBoundary");
        stringBuilder.append(Long.toString(System.identityHashCode(stringBuilder), 36));
        stringBuilder.append(Long.toString(System.identityHashCode(Thread.currentThread()), 36));
        stringBuilder.append(Long.toString(System.nanoTime(), 36));
        return stringBuilder.toString();
    }

    public void addFieldPart(String string, ContentProvider contentProvider, HttpFields httpFields) {
        this.addPart(new Part(string, null, "text/plain", contentProvider, httpFields));
    }

    public void addFilePart(String string, String string2, ContentProvider contentProvider, HttpFields httpFields) {
        this.addPart(new Part(string, string2, "application/octet-stream", contentProvider, httpFields));
    }

    private void addPart(Part part) {
        this.parts.add(part);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Added {}", part);
        }
    }

    @Override
    public void setListener(AsyncContentProvider.Listener listener) {
        this.listener = listener;
        if (this.closed.get()) {
            this.length = this.calculateLength();
        }
    }

    private long calculateLength() {
        if (this.parts.isEmpty()) {
            return this.onlyBoundary.remaining();
        }
        long l = 0L;
        for (int i = 0; i < this.parts.size(); ++i) {
            l += i == 0 ? (long)this.firstBoundary.remaining() : (long)this.middleBoundary.remaining();
            Part part = this.parts.get(i);
            long l2 = part.length;
            l += l2;
            if (l2 >= 0L) continue;
            l = -1L;
            break;
        }
        if (l > 0L) {
            l += (long)this.lastBoundary.remaining();
        }
        return l;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return new MultiPartIterator();
    }

    @Override
    public void close() {
        this.closed.compareAndSet(false, true);
    }

    private static enum State {
        FIRST_BOUNDARY,
        HEADERS,
        CONTENT,
        MIDDLE_BOUNDARY,
        LAST_BOUNDARY,
        COMPLETE;

    }

    private class MultiPartIterator
    implements Iterator<ByteBuffer>,
    Synchronizable,
    Callback,
    Closeable {
        private Iterator<ByteBuffer> iterator;
        private int index;
        private State state = State.FIRST_BOUNDARY;

        private MultiPartIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.state != State.COMPLETE;
        }

        @Override
        public ByteBuffer next() {
            while (true) {
                switch (this.state) {
                    case FIRST_BOUNDARY: {
                        if (MultiPartContentProvider.this.parts.isEmpty()) {
                            this.state = State.COMPLETE;
                            return MultiPartContentProvider.this.onlyBoundary.slice();
                        }
                        this.state = State.HEADERS;
                        return MultiPartContentProvider.this.firstBoundary.slice();
                    }
                    case HEADERS: {
                        Part part = (Part)MultiPartContentProvider.this.parts.get(this.index);
                        ContentProvider contentProvider = part.content;
                        if (contentProvider instanceof AsyncContentProvider) {
                            ((AsyncContentProvider)contentProvider).setListener(MultiPartContentProvider.this.listener);
                        }
                        this.iterator = contentProvider.iterator();
                        this.state = State.CONTENT;
                        return part.headers.slice();
                    }
                    case CONTENT: {
                        if (this.iterator.hasNext()) {
                            return this.iterator.next();
                        }
                        ++this.index;
                        if (this.index < MultiPartContentProvider.this.parts.size()) {
                            this.state = State.MIDDLE_BOUNDARY;
                            if (!(this.iterator instanceof Closeable)) break;
                            IO.close((Closeable)((Object)this.iterator));
                            break;
                        }
                        this.state = State.LAST_BOUNDARY;
                        break;
                    }
                    case MIDDLE_BOUNDARY: {
                        this.state = State.HEADERS;
                        return MultiPartContentProvider.this.middleBoundary.slice();
                    }
                    case LAST_BOUNDARY: {
                        this.state = State.COMPLETE;
                        return MultiPartContentProvider.this.lastBoundary.slice();
                    }
                    case COMPLETE: {
                        throw new NoSuchElementException();
                    }
                }
            }
        }

        @Override
        public Object getLock() {
            if (this.iterator instanceof Synchronizable) {
                return ((Synchronizable)((Object)this.iterator)).getLock();
            }
            return this;
        }

        @Override
        public void succeeded() {
            if (this.state == State.CONTENT && this.iterator instanceof Callback) {
                ((Callback)((Object)this.iterator)).succeeded();
            }
        }

        @Override
        public void failed(Throwable throwable) {
            if (this.state == State.CONTENT && this.iterator instanceof Callback) {
                ((Callback)((Object)this.iterator)).failed(throwable);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.iterator instanceof Closeable) {
                ((Closeable)((Object)this.iterator)).close();
            }
        }
    }

    private static class Part {
        private final String name;
        private final String fileName;
        private final String contentType;
        private final ContentProvider content;
        private final HttpFields fields;
        private final ByteBuffer headers;
        private final long length;

        private Part(String string, String string2, String string3, ContentProvider contentProvider, HttpFields httpFields) {
            this.name = string;
            this.fileName = string2;
            this.contentType = string3;
            this.content = contentProvider;
            this.fields = httpFields;
            this.headers = this.headers();
            this.length = contentProvider.getLength() < 0L ? -1L : (long)this.headers.remaining() + contentProvider.getLength();
        }

        private ByteBuffer headers() {
            try {
                String string;
                String string2 = "Content-Disposition: form-data; name=\"" + this.name + "\"";
                if (this.fileName != null) {
                    string2 = string2 + "; filename=\"" + this.fileName + "\"";
                }
                string2 = string2 + "\r\n";
                String string3 = string = this.fields == null ? null : this.fields.get(HttpHeader.CONTENT_TYPE);
                if (string == null) {
                    string = this.content instanceof ContentProvider.Typed ? ((ContentProvider.Typed)this.content).getContentType() : this.contentType;
                }
                string = "Content-Type: " + string + "\r\n";
                if (this.fields == null || this.fields.size() == 0) {
                    String string4 = string2;
                    string4 = string4 + string;
                    string4 = string4 + "\r\n";
                    return ByteBuffer.wrap(string4.getBytes(StandardCharsets.UTF_8));
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((this.fields.size() + 1) * string2.length());
                byteArrayOutputStream.write(string2.getBytes(StandardCharsets.UTF_8));
                byteArrayOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
                for (HttpField httpField : this.fields) {
                    if (HttpHeader.CONTENT_TYPE.equals((Object)httpField.getHeader())) continue;
                    byteArrayOutputStream.write(httpField.getName().getBytes(StandardCharsets.US_ASCII));
                    byteArrayOutputStream.write(COLON_SPACE_BYTES);
                    String string5 = httpField.getValue();
                    if (string5 != null) {
                        byteArrayOutputStream.write(string5.getBytes(StandardCharsets.UTF_8));
                    }
                    byteArrayOutputStream.write(CR_LF_BYTES);
                }
                byteArrayOutputStream.write(CR_LF_BYTES);
                return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                throw new RuntimeIOException(iOException);
            }
        }

        public String toString() {
            return String.format("%s@%x[name=%s,fileName=%s,length=%d,headers=%s]", this.getClass().getSimpleName(), this.hashCode(), this.name, this.fileName, this.content.getLength(), this.fields);
        }
    }
}

