/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class InputStreamContentProvider
implements ContentProvider,
Callback,
Closeable {
    private static final Logger LOG = Log.getLogger(InputStreamContentProvider.class);
    private final InputStreamContentProviderIterator iterator = new InputStreamContentProviderIterator();
    private final InputStream stream;
    private final int bufferSize;
    private final boolean autoClose;

    public InputStreamContentProvider(InputStream inputStream) {
        this(inputStream, 4096);
    }

    public InputStreamContentProvider(InputStream inputStream, int n) {
        this(inputStream, n, true);
    }

    public InputStreamContentProvider(InputStream inputStream, int n, boolean bl) {
        this.stream = inputStream;
        this.bufferSize = n;
        this.autoClose = bl;
    }

    @Override
    public long getLength() {
        return -1L;
    }

    protected ByteBuffer onRead(byte[] byArray, int n, int n2) {
        if (n2 <= 0) {
            return BufferUtil.EMPTY_BUFFER;
        }
        return ByteBuffer.wrap(byArray, n, n2);
    }

    protected void onReadFailure(Throwable throwable) {
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return this.iterator;
    }

    @Override
    public void close() {
        if (this.autoClose) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                LOG.ignore(iOException);
            }
        }
    }

    @Override
    public void failed(Throwable throwable) {
        this.close();
    }

    private class InputStreamContentProviderIterator
    implements Iterator<ByteBuffer>,
    Closeable {
        private Throwable failure;
        private ByteBuffer buffer;
        private Boolean hasNext;

        private InputStreamContentProviderIterator() {
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.hasNext != null) {
                    return this.hasNext;
                }
                byte[] byArray = new byte[InputStreamContentProvider.this.bufferSize];
                int n = InputStreamContentProvider.this.stream.read(byArray);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Read {} bytes from {}", n, InputStreamContentProvider.this.stream);
                }
                if (n > 0) {
                    this.hasNext = Boolean.TRUE;
                    this.buffer = InputStreamContentProvider.this.onRead(byArray, 0, n);
                    return true;
                }
                if (n < 0) {
                    this.hasNext = Boolean.FALSE;
                    this.buffer = null;
                    this.close();
                    return false;
                }
                this.hasNext = Boolean.TRUE;
                this.buffer = BufferUtil.EMPTY_BUFFER;
                return true;
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(throwable);
                }
                if (this.failure == null) {
                    this.failure = throwable;
                    InputStreamContentProvider.this.onReadFailure(throwable);
                    this.hasNext = Boolean.TRUE;
                    this.buffer = null;
                    this.close();
                    return true;
                }
                throw new IllegalStateException();
            }
        }

        @Override
        public ByteBuffer next() {
            if (this.failure != null) {
                this.hasNext = Boolean.FALSE;
                this.buffer = null;
                throw (NoSuchElementException)new NoSuchElementException().initCause(this.failure);
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ByteBuffer byteBuffer = this.buffer;
            if (byteBuffer == null) {
                this.hasNext = Boolean.FALSE;
                this.buffer = null;
                throw new NoSuchElementException();
            }
            this.hasNext = null;
            this.buffer = null;
            return byteBuffer;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            InputStreamContentProvider.this.close();
        }
    }
}

