/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.util.Fields;

public class FormContentProvider
extends StringContentProvider {
    public FormContentProvider(Fields fields) {
        this(fields, StandardCharsets.UTF_8);
    }

    public FormContentProvider(Fields fields, Charset charset) {
        super("application/x-www-form-urlencoded", FormContentProvider.convert(fields, charset), charset);
    }

    public static String convert(Fields fields) {
        return FormContentProvider.convert(fields, StandardCharsets.UTF_8);
    }

    public static String convert(Fields fields, Charset charset) {
        StringBuilder stringBuilder = new StringBuilder(fields.getSize() * 32);
        for (Fields.Field field : fields) {
            for (String string : field.getValues()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("&");
                }
                stringBuilder.append(FormContentProvider.encode(field.getName(), charset)).append("=").append(FormContentProvider.encode(string, charset));
            }
        }
        return stringBuilder.toString();
    }

    private static String encode(String string, Charset charset) {
        try {
            return URLEncoder.encode(string, charset.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedCharsetException(charset.name());
        }
    }
}

