/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jetty.client.util.AbstractTypedContentProvider;

public class ByteBufferContentProvider
extends AbstractTypedContentProvider {
    private final ByteBuffer[] buffers;
    private final int length;

    public ByteBufferContentProvider(ByteBuffer ... byteBufferArray) {
        this("application/octet-stream", byteBufferArray);
    }

    public ByteBufferContentProvider(String string, ByteBuffer ... byteBufferArray) {
        super(string);
        this.buffers = byteBufferArray;
        int n = 0;
        for (ByteBuffer byteBuffer : byteBufferArray) {
            n += byteBuffer.remaining();
        }
        this.length = n;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public boolean isReproducible() {
        return true;
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return new Iterator<ByteBuffer>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < ByteBufferContentProvider.this.buffers.length;
            }

            @Override
            public ByteBuffer next() {
                try {
                    ByteBuffer byteBuffer = ByteBufferContentProvider.this.buffers[this.index];
                    ((ByteBufferContentProvider)ByteBufferContentProvider.this).buffers[this.index] = byteBuffer.slice();
                    ++this.index;
                    return byteBuffer;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new NoSuchElementException();
                }
            }
        };
    }
}

