/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.BufferUtil;

public abstract class BufferingResponseListener
extends Response.Listener.Adapter {
    private final int maxLength;
    private ByteBuffer buffer;
    private String mediaType;
    private String encoding;

    public BufferingResponseListener() {
        this(0x200000);
    }

    public BufferingResponseListener(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid max length " + n);
        }
        this.maxLength = n;
    }

    @Override
    public void onHeaders(Response response) {
        super.onHeaders(response);
        Request request = response.getRequest();
        HttpFields httpFields = response.getHeaders();
        long l = httpFields.getLongField(HttpHeader.CONTENT_LENGTH.asString());
        if (HttpMethod.HEAD.is(request.getMethod())) {
            l = 0L;
        }
        if (l > (long)this.maxLength) {
            response.abort(new IllegalArgumentException("Buffering capacity " + this.maxLength + " exceeded"));
            return;
        }
        String string = httpFields.get(HttpHeader.CONTENT_TYPE);
        if (string != null) {
            int n;
            String string2 = string;
            String string3 = "charset=";
            int n2 = string.toLowerCase(Locale.ENGLISH).indexOf(string3);
            if (n2 > 0) {
                string2 = string.substring(0, n2);
                String string4 = string.substring(n2 + string3.length());
                int n3 = string4.indexOf(59);
                if (n3 > 0) {
                    string4 = string4.substring(0, n3).trim();
                }
                int n4 = string4.length() - 1;
                if (string4.charAt(0) == '\"' && string4.charAt(n4) == '\"') {
                    string4 = string4.substring(1, n4).trim();
                }
                this.encoding = string4;
            }
            if ((n = string2.indexOf(59)) > 0) {
                string2 = string2.substring(0, n).trim();
            }
            this.mediaType = string2;
        }
    }

    @Override
    public void onContent(Response response, ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (n > BufferUtil.space(this.buffer)) {
            int n2;
            int n3 = n2 = this.buffer == null ? 0 : this.buffer.remaining();
            if (n2 + n > this.maxLength) {
                response.abort(new IllegalArgumentException("Buffering capacity " + this.maxLength + " exceeded"));
            }
            int n4 = this.buffer == null ? n : this.buffer.capacity() + n;
            int n5 = Math.min(Integer.highestOneBit(n4) << 1, this.maxLength);
            this.buffer = BufferUtil.ensureCapacity(this.buffer, n5);
        }
        BufferUtil.append(this.buffer, byteBuffer);
    }

    @Override
    public abstract void onComplete(Result var1);

    public String getMediaType() {
        return this.mediaType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public byte[] getContent() {
        if (this.buffer == null) {
            return new byte[0];
        }
        return BufferUtil.toArray(this.buffer);
    }

    public String getContentAsString() {
        String string = this.encoding;
        if (string == null) {
            return this.getContentAsString(StandardCharsets.UTF_8);
        }
        return this.getContentAsString(string);
    }

    public String getContentAsString(String string) {
        if (this.buffer == null) {
            return null;
        }
        return BufferUtil.toString(this.buffer, Charset.forName(string));
    }

    public String getContentAsString(Charset charset) {
        if (this.buffer == null) {
            return null;
        }
        return BufferUtil.toString(this.buffer, charset);
    }

    public InputStream getContentAsInputStream() {
        if (this.buffer == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.remaining());
    }
}

