/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class AuthenticationProtocolHandler
implements ProtocolHandler {
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 16384;
    public static final Logger LOG = Log.getLogger(AuthenticationProtocolHandler.class);
    private final HttpClient client;
    private final int maxContentLength;
    private final ResponseNotifier notifier;
    private static final Pattern CHALLENGE_PATTERN = Pattern.compile("(?<schemeOnly>[!#$%&'*+\\-.^_`|~0-9A-Za-z]+)|(?:(?<scheme>[!#$%&'*+\\-.^_`|~0-9A-Za-z]+)\\s+)?(?:(?<token68>[a-zA-Z0-9\\-._~+/]+=*)|(?<paramName>[!#$%&'*+\\-.^_`|~0-9A-Za-z]+)\\s*=\\s*(?:(?<paramValue>.*)))");

    protected AuthenticationProtocolHandler(HttpClient httpClient, int n) {
        this.client = httpClient;
        this.maxContentLength = n;
        this.notifier = new ResponseNotifier();
    }

    protected HttpClient getHttpClient() {
        return this.client;
    }

    protected abstract HttpHeader getAuthenticateHeader();

    protected abstract HttpHeader getAuthorizationHeader();

    protected abstract URI getAuthenticationURI(Request var1);

    protected abstract String getAuthenticationAttribute();

    @Override
    public Response.Listener getResponseListener() {
        return new AuthenticationListener();
    }

    protected List<Authentication.HeaderInfo> getHeaderInfo(String string) throws IllegalArgumentException {
        ArrayList<Authentication.HeaderInfo> arrayList = new ArrayList<Authentication.HeaderInfo>();
        for (String string2 : new QuotedCSV(true, string)) {
            Matcher matcher = CHALLENGE_PATTERN.matcher(string2);
            if (!matcher.matches()) continue;
            if (matcher.group("schemeOnly") != null) {
                arrayList.add(new Authentication.HeaderInfo(this.getAuthorizationHeader(), matcher.group(1), new HashMap<String, String>()));
                continue;
            }
            if (matcher.group("scheme") != null) {
                arrayList.add(new Authentication.HeaderInfo(this.getAuthorizationHeader(), matcher.group("scheme"), new HashMap<String, String>()));
            }
            if (arrayList.isEmpty()) {
                throw new IllegalArgumentException("Parameters without auth-scheme");
            }
            Map<String, String> map = ((Authentication.HeaderInfo)arrayList.get(arrayList.size() - 1)).getParameters();
            if (matcher.group("paramName") != null) {
                String string3 = QuotedCSV.unquote(matcher.group("paramValue"));
                map.put(matcher.group("paramName"), string3);
                continue;
            }
            if (matcher.group("token68") == null) continue;
            if (!map.isEmpty()) {
                throw new IllegalArgumentException("token68 after auth-params");
            }
            map.put("base64", matcher.group("token68"));
        }
        return arrayList;
    }

    private class AfterAuthenticationListener
    extends Response.Listener.Adapter {
        private final Authentication.Result authenticationResult;

        private AfterAuthenticationListener(Authentication.Result result) {
            this.authenticationResult = result;
        }

        @Override
        public void onSuccess(Response response) {
            int n = response.getStatus();
            if (HttpStatus.isSuccess(n) || HttpStatus.isRedirection(n)) {
                AuthenticationProtocolHandler.this.client.getAuthenticationStore().addAuthenticationResult(this.authenticationResult);
            }
        }
    }

    private class AuthenticationListener
    extends BufferingResponseListener {
        private AuthenticationListener() {
            super(AuthenticationProtocolHandler.this.maxContentLength);
        }

        @Override
        public void onComplete(Result result) {
            HttpRequest httpRequest = (HttpRequest)result.getRequest();
            HttpContentResponse httpContentResponse = new HttpContentResponse(result.getResponse(), this.getContent(), this.getMediaType(), this.getEncoding());
            if (result.getResponseFailure() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication challenge failed {}", result.getFailure());
                }
                this.forwardFailureComplete(httpRequest, result.getRequestFailure(), httpContentResponse, result.getResponseFailure());
                return;
            }
            String string = AuthenticationProtocolHandler.this.getAuthenticationAttribute();
            HttpConversation httpConversation = httpRequest.getConversation();
            if (httpConversation.getAttribute(string) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Bad credentials for {}", httpRequest);
                }
                this.forwardSuccessComplete(httpRequest, httpContentResponse);
                return;
            }
            HttpHeader httpHeader = AuthenticationProtocolHandler.this.getAuthenticateHeader();
            List<Authentication.HeaderInfo> list = this.parseAuthenticateHeader(httpContentResponse, httpHeader);
            if (list.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication challenge without {} header", new Object[]{httpHeader});
                }
                this.forwardFailureComplete(httpRequest, result.getRequestFailure(), httpContentResponse, new HttpResponseException("HTTP protocol violation: Authentication challenge without " + (Object)((Object)httpHeader) + " header", httpContentResponse));
                return;
            }
            Authentication authentication = null;
            Authentication.HeaderInfo object = null;
            URI uRI = this.resolveURI(httpRequest, AuthenticationProtocolHandler.this.getAuthenticationURI(httpRequest));
            if (uRI != null) {
                for (Authentication.HeaderInfo object2 : list) {
                    authentication = AuthenticationProtocolHandler.this.client.getAuthenticationStore().findAuthentication(object2.getType(), uRI, object2.getRealm());
                    if (authentication == null) continue;
                    object = object2;
                    break;
                }
            }
            if (authentication == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No authentication available for {}", httpRequest);
                }
                this.forwardSuccessComplete(httpRequest, httpContentResponse);
                return;
            }
            ContentProvider contentProvider = httpRequest.getContent();
            if (contentProvider != null && !contentProvider.isReproducible()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request content not reproducible for {}", httpRequest);
                }
                this.forwardSuccessComplete(httpRequest, httpContentResponse);
                return;
            }
            try {
                Authentication.Result throwable = authentication.authenticate(httpRequest, httpContentResponse, object, httpConversation);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication result {}", throwable);
                }
                if (throwable == null) {
                    this.forwardSuccessComplete(httpRequest, httpContentResponse);
                    return;
                }
                httpConversation.setAttribute(string, true);
                URI uRI2 = httpRequest.getURI();
                String string2 = null;
                if (uRI2 == null) {
                    uRI2 = this.resolveURI(httpRequest, null);
                    string2 = httpRequest.getPath();
                }
                Request request = AuthenticationProtocolHandler.this.client.copyRequest(httpRequest, uRI2);
                long l = httpRequest.getTimeoutAt();
                if (l < Long.MAX_VALUE) {
                    long afterAuthenticationListener = l - System.nanoTime();
                    if (afterAuthenticationListener > 0L) {
                        request.timeout(afterAuthenticationListener, TimeUnit.NANOSECONDS);
                    } else {
                        TimeoutException timeoutException = new TimeoutException("Total timeout " + httpRequest.getConversation().getTimeout() + " ms elapsed");
                        this.forwardFailureComplete(httpRequest, timeoutException, httpContentResponse, timeoutException);
                        return;
                    }
                }
                if (string2 != null) {
                    request.path(string2);
                }
                throwable.apply(request);
                this.copyIfAbsent(httpRequest, request, HttpHeader.AUTHORIZATION);
                this.copyIfAbsent(httpRequest, request, HttpHeader.PROXY_AUTHORIZATION);
                AfterAuthenticationListener afterAuthenticationListener = new AfterAuthenticationListener(throwable);
                Connection connection = (Connection)httpRequest.getAttributes().get(Connection.class.getName());
                if (connection != null) {
                    connection.send(request, afterAuthenticationListener);
                } else {
                    request.send(afterAuthenticationListener);
                }
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication failed", throwable);
                }
                this.forwardFailureComplete(httpRequest, null, httpContentResponse, throwable);
            }
        }

        private URI resolveURI(HttpRequest httpRequest, URI uRI) {
            if (uRI != null) {
                return uRI;
            }
            String string = httpRequest.getScheme() + "://" + httpRequest.getHost();
            int n = httpRequest.getPort();
            if (n > 0) {
                string = string + ":" + n;
            }
            return URI.create(string);
        }

        private void copyIfAbsent(HttpRequest httpRequest, Request request, HttpHeader httpHeader) {
            HttpField httpField = httpRequest.getHeaders().getField(httpHeader);
            if (httpField != null && !request.getHeaders().contains(httpHeader)) {
                request.getHeaders().put(httpField);
            }
        }

        private void forwardSuccessComplete(HttpRequest httpRequest, Response response) {
            HttpConversation httpConversation = httpRequest.getConversation();
            httpConversation.updateResponseListeners(null);
            AuthenticationProtocolHandler.this.notifier.forwardSuccessComplete(httpConversation.getResponseListeners(), httpRequest, response);
        }

        private void forwardFailureComplete(HttpRequest httpRequest, Throwable throwable, Response response, Throwable throwable2) {
            HttpConversation httpConversation = httpRequest.getConversation();
            httpConversation.updateResponseListeners(null);
            List<Response.ResponseListener> list = httpConversation.getResponseListeners();
            if (throwable2 == null) {
                AuthenticationProtocolHandler.this.notifier.forwardSuccess(list, response);
            } else {
                AuthenticationProtocolHandler.this.notifier.forwardFailure(list, response, throwable2);
            }
            AuthenticationProtocolHandler.this.notifier.notifyComplete(list, new Result(httpRequest, throwable, response, throwable2));
        }

        private List<Authentication.HeaderInfo> parseAuthenticateHeader(Response response, HttpHeader httpHeader) {
            ArrayList<Authentication.HeaderInfo> arrayList = new ArrayList<Authentication.HeaderInfo>();
            List<String> list = response.getHeaders().getValuesList(httpHeader);
            for (String string : list) {
                try {
                    arrayList.addAll(AuthenticationProtocolHandler.this.getHeaderInfo(string));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Failed to parse authentication header", illegalArgumentException);
                }
            }
            return arrayList;
        }
    }
}

