/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.swing;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.swing.XMLTableDefinition;

public class XMLTableModel
extends AbstractTableModel {
    private XMLTableDefinition definition;
    private Object source;
    private List rows;

    public XMLTableModel(Element element, Object object) {
        this(XMLTableDefinition.load(element), object);
    }

    public XMLTableModel(Document document, Object object) {
        this(XMLTableDefinition.load(document), object);
    }

    public XMLTableModel(XMLTableDefinition xMLTableDefinition, Object object) {
        this.definition = xMLTableDefinition;
        this.source = object;
    }

    public Object getRowValue(int n) {
        return this.getRows().get(n);
    }

    public List getRows() {
        if (this.rows == null) {
            this.rows = this.definition.getRowXPath().selectNodes(this.source);
        }
        return this.rows;
    }

    public Class getColumnClass(int n) {
        return this.definition.getColumnClass(n);
    }

    public int getColumnCount() {
        return this.definition.getColumnCount();
    }

    public String getColumnName(int n) {
        XPath xPath = this.definition.getColumnNameXPath(n);
        if (xPath != null) {
            System.out.println("Evaluating column xpath: " + xPath + " value: " + xPath.valueOf(this.source));
            return xPath.valueOf(this.source);
        }
        return this.definition.getColumnName(n);
    }

    public Object getValueAt(int n, int n2) {
        try {
            Object object = this.getRowValue(n);
            return this.definition.getValueAt(object, n2);
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    public int getRowCount() {
        return this.getRows().size();
    }

    public XMLTableDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(XMLTableDefinition xMLTableDefinition) {
        this.definition = xMLTableDefinition;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object object) {
        this.source = object;
        this.rows = null;
    }

    protected void handleException(Exception exception) {
        System.out.println("Caught: " + exception);
    }
}

