/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.jaxb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.ElementModifier;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXModifier;
import org.dom4j.io.XMLWriter;
import org.dom4j.jaxb.JAXBObjectModifier;
import org.dom4j.jaxb.JAXBRuntimeException;
import org.dom4j.jaxb.JAXBSupport;
import org.xml.sax.InputSource;

public class JAXBModifier
extends JAXBSupport {
    private SAXModifier modifier;
    private XMLWriter xmlWriter;
    private boolean pruneElements;
    private OutputFormat outputFormat;
    private HashMap modifiers = new HashMap();

    public JAXBModifier(String string) {
        super(string);
        this.outputFormat = new OutputFormat();
    }

    public JAXBModifier(String string, ClassLoader classLoader) {
        super(string, classLoader);
        this.outputFormat = new OutputFormat();
    }

    public JAXBModifier(String string, OutputFormat outputFormat) {
        super(string);
        this.outputFormat = outputFormat;
    }

    public JAXBModifier(String string, ClassLoader classLoader, OutputFormat outputFormat) {
        super(string, classLoader);
        this.outputFormat = outputFormat;
    }

    public Document modify(File file) throws DocumentException, IOException {
        return this.installModifier().modify(file);
    }

    public Document modify(File file, Charset charset) throws DocumentException, IOException {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), charset);
            return this.installModifier().modify(inputStreamReader);
        }
        catch (JAXBRuntimeException jAXBRuntimeException) {
            Throwable throwable = jAXBRuntimeException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DocumentException(fileNotFoundException.getMessage(), fileNotFoundException);
        }
    }

    public Document modify(InputSource inputSource) throws DocumentException, IOException {
        try {
            return this.installModifier().modify(inputSource);
        }
        catch (JAXBRuntimeException jAXBRuntimeException) {
            Throwable throwable = jAXBRuntimeException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public Document modify(InputStream inputStream) throws DocumentException, IOException {
        try {
            return this.installModifier().modify(inputStream);
        }
        catch (JAXBRuntimeException jAXBRuntimeException) {
            Throwable throwable = jAXBRuntimeException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public Document modify(InputStream inputStream, String string) throws DocumentException, IOException {
        try {
            return this.installModifier().modify(inputStream);
        }
        catch (JAXBRuntimeException jAXBRuntimeException) {
            Throwable throwable = jAXBRuntimeException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public Document modify(Reader reader) throws DocumentException, IOException {
        try {
            return this.installModifier().modify(reader);
        }
        catch (JAXBRuntimeException jAXBRuntimeException) {
            Throwable throwable = jAXBRuntimeException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public Document modify(Reader reader, String string) throws DocumentException, IOException {
        try {
            return this.installModifier().modify(reader);
        }
        catch (JAXBRuntimeException jAXBRuntimeException) {
            Throwable throwable = jAXBRuntimeException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public Document modify(String string) throws DocumentException, IOException {
        try {
            return this.installModifier().modify(string);
        }
        catch (JAXBRuntimeException jAXBRuntimeException) {
            Throwable throwable = jAXBRuntimeException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public Document modify(URL uRL) throws DocumentException, IOException {
        try {
            return this.installModifier().modify(uRL);
        }
        catch (JAXBRuntimeException jAXBRuntimeException) {
            Throwable throwable = jAXBRuntimeException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public void setOutput(File file) throws IOException {
        this.createXMLWriter().setOutputStream(new FileOutputStream(file));
    }

    public void setOutput(OutputStream outputStream) throws IOException {
        this.createXMLWriter().setOutputStream(outputStream);
    }

    public void setOutput(Writer writer) throws IOException {
        this.createXMLWriter().setWriter(writer);
    }

    public void addObjectModifier(String string, JAXBObjectModifier jAXBObjectModifier) {
        this.modifiers.put(string, jAXBObjectModifier);
    }

    public void removeObjectModifier(String string) {
        this.modifiers.remove(string);
        this.getModifier().removeModifier(string);
    }

    public void resetObjectModifiers() {
        this.modifiers.clear();
        this.getModifier().resetModifiers();
    }

    public boolean isPruneElements() {
        return this.pruneElements;
    }

    public void setPruneElements(boolean bl) {
        this.pruneElements = bl;
    }

    private SAXModifier installModifier() throws IOException {
        this.modifier = new SAXModifier(this.isPruneElements());
        this.modifier.resetModifiers();
        Iterator iterator = this.modifiers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            JAXBElementModifier jAXBElementModifier = new JAXBElementModifier(this, (JAXBObjectModifier)entry.getValue());
            this.getModifier().addModifier((String)entry.getKey(), jAXBElementModifier);
        }
        this.modifier.setXMLWriter(this.getXMLWriter());
        return this.modifier;
    }

    private SAXModifier getModifier() {
        if (this.modifier == null) {
            this.modifier = new SAXModifier(this.isPruneElements());
        }
        return this.modifier;
    }

    private XMLWriter getXMLWriter() {
        return this.xmlWriter;
    }

    private XMLWriter createXMLWriter() throws IOException {
        if (this.xmlWriter == null) {
            this.xmlWriter = new XMLWriter(this.outputFormat);
        }
        return this.xmlWriter;
    }

    private class JAXBElementModifier
    implements ElementModifier {
        private JAXBModifier jaxbModifier;
        private JAXBObjectModifier objectModifier;

        public JAXBElementModifier(JAXBModifier jAXBModifier2, JAXBObjectModifier jAXBObjectModifier) {
            this.jaxbModifier = jAXBModifier2;
            this.objectModifier = jAXBObjectModifier;
        }

        public Element modifyElement(Element element) throws Exception {
            javax.xml.bind.Element element2 = this.jaxbModifier.unmarshal(element);
            javax.xml.bind.Element element3 = this.objectModifier.modifyObject(element2);
            return this.jaxbModifier.marshal(element3);
        }
    }
}

