/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import org.dom4j.io.JAXPHelper;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class SAXHelper {
    private static boolean loggedWarning = true;

    protected SAXHelper() {
    }

    public static boolean setParserProperty(XMLReader xMLReader, String string, Object object) {
        try {
            xMLReader.setProperty(string, object);
            return true;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
        return false;
    }

    public static boolean setParserFeature(XMLReader xMLReader, String string, boolean bl) {
        try {
            xMLReader.setFeature(string, bl);
            return true;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
        return false;
    }

    public static XMLReader createXMLReader(boolean bl) throws SAXException {
        XMLReader xMLReader = null;
        if (xMLReader == null) {
            xMLReader = SAXHelper.createXMLReaderViaJAXP(bl, true);
        }
        if (xMLReader == null) {
            try {
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            catch (Exception exception) {
                if (SAXHelper.isVerboseErrorReporting()) {
                    System.out.println("Warning: Caught exception attempting to use SAX to load a SAX XMLReader ");
                    System.out.println("Warning: Exception was: " + exception);
                    System.out.println("Warning: I will print the stack trace then carry on using the default SAX parser");
                    exception.printStackTrace();
                }
                throw new SAXException(exception);
            }
        }
        if (xMLReader == null) {
            throw new SAXException("Couldn't create SAX reader");
        }
        return xMLReader;
    }

    protected static XMLReader createXMLReaderViaJAXP(boolean bl, boolean bl2) {
        try {
            return JAXPHelper.createXMLReader(bl, bl2);
        }
        catch (Throwable throwable) {
            if (!loggedWarning) {
                loggedWarning = true;
                if (SAXHelper.isVerboseErrorReporting()) {
                    System.out.println("Warning: Caught exception attempting to use JAXP to load a SAX XMLReader");
                    System.out.println("Warning: Exception was: " + throwable);
                    throwable.printStackTrace();
                }
            }
            return null;
        }
    }

    protected static boolean isVerboseErrorReporting() {
        try {
            String string = System.getProperty("org.dom4j.verbose");
            if (string != null && string.equalsIgnoreCase("true")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }
}

