/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileHeader;
import org.cryptomator.cryptolib.common.ByteBuffers;

public class EncryptingWritableByteChannel
implements WritableByteChannel {
    private final WritableByteChannel delegate;
    private final Cryptor cryptor;
    private final FileHeader header;
    private final ByteBuffer cleartextBuffer;
    private boolean firstWrite = true;
    private long chunkNumber = 0L;

    public EncryptingWritableByteChannel(WritableByteChannel writableByteChannel, Cryptor cryptor) {
        this.delegate = writableByteChannel;
        this.cryptor = cryptor;
        this.header = cryptor.fileHeaderCryptor().create();
        this.cleartextBuffer = ByteBuffer.allocate(cryptor.fileContentCryptor().cleartextChunkSize());
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public synchronized void close() throws IOException {
        this.writeHeaderOnFirstWrite();
        this.encryptAndFlushBuffer();
        this.delegate.close();
    }

    @Override
    public synchronized int write(ByteBuffer byteBuffer) throws IOException {
        this.writeHeaderOnFirstWrite();
        int n = 0;
        while (byteBuffer.hasRemaining()) {
            n += ByteBuffers.copy(byteBuffer, this.cleartextBuffer);
            if (this.cleartextBuffer.hasRemaining()) continue;
            this.encryptAndFlushBuffer();
        }
        return n;
    }

    private void writeHeaderOnFirstWrite() throws IOException {
        if (this.firstWrite) {
            this.delegate.write(this.cryptor.fileHeaderCryptor().encryptHeader(this.header));
        }
        this.firstWrite = false;
    }

    private void encryptAndFlushBuffer() throws IOException {
        this.cleartextBuffer.flip();
        if (this.cleartextBuffer.hasRemaining()) {
            ByteBuffer byteBuffer = this.cryptor.fileContentCryptor().encryptChunk(this.cleartextBuffer, this.chunkNumber++, this.header);
            this.delegate.write(byteBuffer);
        }
        this.cleartextBuffer.clear();
    }
}

