/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import org.cryptomator.cryptolib.common.CipherSupplier;

public class AesKeyWrap {
    public static byte[] wrap(SecretKey secretKey, SecretKey secretKey2) {
        try {
            Cipher cipher = CipherSupplier.RFC3394_KEYWRAP.forWrapping(secretKey);
            return cipher.wrap(secretKey2);
        }
        catch (InvalidKeyException | IllegalBlockSizeException generalSecurityException) {
            throw new IllegalArgumentException("Unable to wrap key.", generalSecurityException);
        }
    }

    public static SecretKey unwrap(SecretKey secretKey, byte[] byArray, String string) throws InvalidKeyException {
        return AesKeyWrap.unwrap(secretKey, byArray, string, 3);
    }

    static SecretKey unwrap(SecretKey secretKey, byte[] byArray, String string, int n) throws InvalidKeyException {
        Cipher cipher = CipherSupplier.RFC3394_KEYWRAP.forUnwrapping(secretKey);
        try {
            return (SecretKey)cipher.unwrap(byArray, string, n);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException("Invalid algorithm: " + string, noSuchAlgorithmException);
        }
    }
}

