/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.util.Objects;

class DelegatingFileStore
extends FileStore {
    private final FileStore delegate;

    public DelegatingFileStore(FileStore fileStore) {
        this.delegate = Objects.requireNonNull(fileStore);
    }

    @Override
    public String name() {
        return this.type() + "_" + this.delegate.name();
    }

    @Override
    public String type() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean isReadOnly() {
        return this.delegate.isReadOnly();
    }

    @Override
    public long getTotalSpace() throws IOException {
        return this.delegate.getTotalSpace();
    }

    @Override
    public long getUsableSpace() throws IOException {
        return this.delegate.getUsableSpace();
    }

    @Override
    public long getUnallocatedSpace() throws IOException {
        return this.delegate.getUnallocatedSpace();
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> clazz) {
        return this.delegate.supportsFileAttributeView(clazz);
    }

    @Override
    public boolean supportsFileAttributeView(String string) {
        return this.delegate.supportsFileAttributeView(string);
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> clazz) {
        return null;
    }

    @Override
    public Object getAttribute(String string) throws IOException {
        throw new UnsupportedOperationException();
    }
}

