/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.cryptomator.cryptofs.CryptoFileSystemImpl;
import org.cryptomator.cryptofs.CryptoFileSystemUri;

class CryptoPath
implements Path {
    private static final String CURRENT_DIR = ".";
    private static final String PARENT_DIR = "..";
    private final CryptoFileSystemImpl fileSystem;
    private final List<String> elements;
    private final boolean absolute;

    public CryptoPath(CryptoFileSystemImpl cryptoFileSystemImpl, List<String> list, boolean bl) {
        cryptoFileSystemImpl.assertOpen();
        this.fileSystem = cryptoFileSystemImpl;
        this.elements = Collections.unmodifiableList(list);
        this.absolute = bl;
    }

    public static CryptoPath castAndAssertAbsolute(Path path) {
        CryptoPath cryptoPath = CryptoPath.cast(path);
        if (!cryptoPath.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute but was " + path);
        }
        return cryptoPath;
    }

    public static CryptoPath cast(Path path) {
        if (path instanceof CryptoPath) {
            CryptoPath cryptoPath = (CryptoPath)path;
            cryptoPath.getFileSystem().assertOpen();
            return cryptoPath;
        }
        throw new ProviderMismatchException("Used a path from different provider: " + path);
    }

    @Override
    public CryptoFileSystemImpl getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        this.fileSystem.assertOpen();
        return this.absolute;
    }

    @Override
    public CryptoPath getRoot() {
        this.fileSystem.assertOpen();
        return this.absolute ? this.fileSystem.getRootPath() : null;
    }

    @Override
    public Path getFileName() {
        this.fileSystem.assertOpen();
        int n = this.getNameCount();
        if (n == 0) {
            return null;
        }
        return this.getName(n - 1);
    }

    @Override
    public CryptoPath getParent() {
        this.fileSystem.assertOpen();
        int n = this.getNameCount();
        if (n > 1) {
            List<String> list = this.elements.subList(0, n - 1);
            return this.copyWithElements(list);
        }
        if (n == 1) {
            return this.getRoot();
        }
        return null;
    }

    @Override
    public int getNameCount() {
        this.fileSystem.assertOpen();
        return this.elements.size();
    }

    @Override
    public Path getName(int n) {
        this.fileSystem.assertOpen();
        return this.subpath(n, n + 1);
    }

    @Override
    public CryptoPath subpath(int n, int n2) {
        this.fileSystem.assertOpen();
        return new CryptoPath(this.fileSystem, this.elements.subList(n, n2), false);
    }

    @Override
    public boolean startsWith(Path path) {
        boolean bl;
        this.fileSystem.assertOpen();
        CryptoPath cryptoPath = CryptoPath.cast(path);
        boolean bl2 = bl = this.isAbsolute() == cryptoPath.isAbsolute();
        if (bl && cryptoPath.elements.size() <= this.elements.size()) {
            return this.elements.subList(0, cryptoPath.elements.size()).equals(cryptoPath.elements);
        }
        return false;
    }

    @Override
    public boolean startsWith(String string) {
        this.fileSystem.assertOpen();
        return this.startsWith(this.fileSystem.getPath(string, new String[0]));
    }

    @Override
    public boolean endsWith(Path path) {
        this.fileSystem.assertOpen();
        CryptoPath cryptoPath = CryptoPath.cast(path);
        if (cryptoPath.elements.size() <= this.elements.size()) {
            return this.elements.subList(this.elements.size() - cryptoPath.elements.size(), this.elements.size()).equals(cryptoPath.elements);
        }
        return false;
    }

    @Override
    public boolean endsWith(String string) {
        this.fileSystem.assertOpen();
        return this.endsWith(this.fileSystem.getPath(string, new String[0]));
    }

    @Override
    public CryptoPath normalize() {
        this.fileSystem.assertOpen();
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : this.elements) {
            String string2 = linkedList.peekLast();
            if (string.isEmpty() || CURRENT_DIR.equals(string)) continue;
            if (PARENT_DIR.equals(string) && string2 != null && !PARENT_DIR.equals(string2)) {
                linkedList.removeLast();
                continue;
            }
            linkedList.add(string);
        }
        return this.copyWithElements(linkedList);
    }

    @Override
    public Path resolve(Path path) {
        this.fileSystem.assertOpen();
        CryptoPath cryptoPath = CryptoPath.cast(path);
        if (cryptoPath.isAbsolute()) {
            return cryptoPath;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.elements);
        arrayList.addAll(cryptoPath.elements);
        return this.copyWithElements(arrayList);
    }

    @Override
    public Path resolve(String string) {
        this.fileSystem.assertOpen();
        return this.resolve(this.fileSystem.getPath(string, new String[0]));
    }

    @Override
    public Path resolveSibling(Path path) {
        this.fileSystem.assertOpen();
        CryptoPath cryptoPath = this.getParent();
        if (cryptoPath == null || path.isAbsolute()) {
            return path;
        }
        return cryptoPath.resolve(path);
    }

    @Override
    public Path resolveSibling(String string) {
        this.fileSystem.assertOpen();
        return this.resolveSibling(this.fileSystem.getPath(string, new String[0]));
    }

    @Override
    public Path relativize(Path path) {
        this.fileSystem.assertOpen();
        CryptoPath cryptoPath = this.normalize();
        CryptoPath cryptoPath2 = CryptoPath.cast(path).normalize();
        if (cryptoPath.isAbsolute() == cryptoPath2.isAbsolute()) {
            int n = this.countCommonPrefixElements(cryptoPath, cryptoPath2);
            int n2 = this.getNameCount() - n;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(Collections.nCopies(n2, PARENT_DIR));
            arrayList.addAll(cryptoPath2.elements.subList(n, cryptoPath2.getNameCount()));
            return this.copyWithElementsAndAbsolute(arrayList, false);
        }
        throw new IllegalArgumentException("Can't relativize an absolute path relative to a relative path.");
    }

    private int countCommonPrefixElements(CryptoPath cryptoPath, CryptoPath cryptoPath2) {
        int n = Math.min(cryptoPath.getNameCount(), cryptoPath2.getNameCount());
        for (int i = 0; i < n; ++i) {
            if (cryptoPath.elements.get(i).equals(cryptoPath2.elements.get(i))) continue;
            return i;
        }
        return n;
    }

    @Override
    public URI toUri() {
        this.fileSystem.assertOpen();
        return CryptoFileSystemUri.create(this.fileSystem.getPathToVault(), this.elements.toArray(new String[this.elements.size()]));
    }

    @Override
    public Path toAbsolutePath() {
        this.fileSystem.assertOpen();
        if (this.isAbsolute()) {
            return this;
        }
        return this.copyWithAbsolute(true);
    }

    @Override
    public Path toRealPath(LinkOption ... linkOptionArray) throws IOException {
        this.fileSystem.assertOpen();
        return this.normalize().toAbsolutePath();
    }

    @Override
    public File toFile() {
        this.fileSystem.assertOpen();
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watchService, WatchEvent.Kind<?>[] kindArray, WatchEvent.Modifier ... modifierArray) throws IOException {
        this.fileSystem.assertOpen();
        throw new UnsupportedOperationException("Method not implemented.");
    }

    @Override
    public WatchKey register(WatchService watchService, WatchEvent.Kind<?> ... kindArray) throws IOException {
        this.fileSystem.assertOpen();
        throw new UnsupportedOperationException("Method not implemented.");
    }

    @Override
    public Iterator<Path> iterator() {
        this.fileSystem.assertOpen();
        return new Iterator<Path>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < CryptoPath.this.getNameCount();
            }

            @Override
            public Path next() {
                return CryptoPath.this.getName(this.idx++);
            }
        };
    }

    @Override
    public int compareTo(Path path) {
        CryptoPath cryptoPath = (CryptoPath)path;
        if (this.isAbsolute() != cryptoPath.isAbsolute()) {
            return this.isAbsolute() ? -1 : 1;
        }
        for (int i = 0; i < Math.min(this.getNameCount(), cryptoPath.getNameCount()); ++i) {
            int n = this.elements.get(i).compareTo(cryptoPath.elements.get(i));
            if (n == 0) continue;
            return n;
        }
        return this.getNameCount() - cryptoPath.getNameCount();
    }

    @Override
    public int hashCode() {
        int n = 0;
        n = 31 * n + this.fileSystem.hashCode();
        n = 31 * n + this.elements.hashCode();
        n = 31 * n + (this.absolute ? 1 : 0);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof CryptoPath) {
            CryptoPath cryptoPath = (CryptoPath)object;
            return this.fileSystem.equals(cryptoPath.fileSystem) && this.compareTo(cryptoPath) == 0;
        }
        return false;
    }

    @Override
    public String toString() {
        String string = this.absolute ? "/" : "";
        return string + String.join((CharSequence)"/", this.elements);
    }

    public CryptoPath copyWithElements(List<String> list) {
        return new CryptoPath(this.fileSystem, list, this.absolute);
    }

    public CryptoPath copyWithAbsolute(boolean bl) {
        return new CryptoPath(this.fileSystem, this.elements, bl);
    }

    public CryptoPath copyWithElementsAndAbsolute(List<String> list, boolean bl) {
        return new CryptoPath(this.fileSystem, list, bl);
    }
}

