/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import java.util.function.Consumer;
import org.cryptomator.cryptofs.CryptoFileLock;
import org.cryptomator.cryptofs.EffectiveOpenOptions;
import org.cryptomator.cryptofs.FinallyUtil;
import org.cryptomator.cryptofs.OpenCryptoFile;
import org.cryptomator.cryptofs.SupplierThrowingException;

class CryptoFileChannel
extends FileChannel {
    private static final int BUFFER_SIZE = 4096;
    private final OpenCryptoFile openCryptoFile;
    private final EffectiveOpenOptions options;
    private final Consumer<CryptoFileChannel> onClose;
    private final FinallyUtil finallyUtil;
    private volatile long position = 0L;

    public CryptoFileChannel(OpenCryptoFile openCryptoFile, EffectiveOpenOptions effectiveOpenOptions, Consumer<CryptoFileChannel> consumer, FinallyUtil finallyUtil) throws IOException {
        this.openCryptoFile = Objects.requireNonNull(openCryptoFile);
        this.options = Objects.requireNonNull(effectiveOpenOptions);
        this.openCryptoFile.open(effectiveOpenOptions);
        this.onClose = consumer;
        this.finallyUtil = finallyUtil;
    }

    @Override
    public synchronized long position() throws IOException {
        this.assertOpen();
        return this.position;
    }

    @Override
    public synchronized FileChannel position(long l) throws IOException {
        this.assertOpen();
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        this.position = l;
        return this;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        this.assertOpen();
        this.assertReadable();
        return this.blockingIo(() -> this.internalRead(byteBuffer));
    }

    @Override
    public synchronized int write(ByteBuffer byteBuffer) throws IOException {
        this.assertOpen();
        this.assertWritable();
        return this.blockingIo(() -> this.internalWrite(byteBuffer)).intValue();
    }

    @Override
    public synchronized int read(ByteBuffer byteBuffer, long l) throws IOException {
        this.assertOpen();
        this.assertReadable();
        return this.blockingIo(() -> this.internalRead(byteBuffer, l));
    }

    @Override
    public synchronized int write(ByteBuffer byteBuffer, long l) throws IOException {
        this.assertOpen();
        this.assertWritable();
        return this.blockingIo(() -> this.internalWrite(byteBuffer, l));
    }

    @Override
    public synchronized long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        this.assertOpen();
        this.assertReadable();
        return this.blockingIo(() -> {
            long l = 0L;
            for (int i = 0; i < n2; ++i) {
                int n3 = this.internalRead(byteBufferArray[i + n]);
                if (n3 == -1 && l == 0L) {
                    return -1L;
                }
                if (n3 == -1) {
                    return l;
                }
                l += (long)n3;
            }
            return l;
        });
    }

    @Override
    public synchronized long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        this.assertOpen();
        this.assertWritable();
        return this.blockingIo(() -> {
            long l = 0L;
            for (int i = 0; i < n2; ++i) {
                l += this.internalWrite(byteBufferArray[n + i]);
            }
            return l;
        });
    }

    @Override
    public synchronized long transferTo(long l, long l2, WritableByteChannel writableByteChannel) throws IOException {
        this.assertOpen();
        this.assertReadable();
        return this.blockingIo(() -> {
            long l3;
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)Math.min(l2, 4096L));
            for (l3 = 0L; l3 < l2; l3 += (long)writableByteChannel.write(byteBuffer)) {
                byteBuffer.clear();
                int n = this.internalRead(byteBuffer, l + l3);
                if (n == -1) break;
                byteBuffer.flip();
                byteBuffer.limit((int)Math.min((long)byteBuffer.limit(), l2 - l3));
            }
            return l3;
        });
    }

    @Override
    public synchronized long transferFrom(ReadableByteChannel readableByteChannel, long l, long l2) throws IOException {
        this.assertOpen();
        this.assertWritable();
        return this.blockingIo(() -> {
            long l3;
            if (l > this.size()) {
                return 0L;
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)Math.min(l2, 4096L));
            for (l3 = 0L; l3 < l2; l3 += (long)this.write(byteBuffer, l + l3)) {
                byteBuffer.clear();
                int n = readableByteChannel.read(byteBuffer);
                if (n == -1) break;
                byteBuffer.flip();
                byteBuffer.limit((int)Math.min((long)byteBuffer.limit(), l2 - l3));
            }
            return l3;
        });
    }

    private synchronized long internalWrite(ByteBuffer byteBuffer) throws IOException {
        if (this.options.append()) {
            return this.openCryptoFile.append(this.options, byteBuffer);
        }
        long l = this.position();
        int n = this.openCryptoFile.write(this.options, byteBuffer, l);
        this.position(l + (long)n);
        return n;
    }

    private int internalRead(ByteBuffer byteBuffer) throws IOException {
        long l = this.position();
        int n = this.openCryptoFile.read(byteBuffer, l);
        if (n >= 0) {
            this.position(l + (long)n);
        }
        return n;
    }

    private int internalWrite(ByteBuffer byteBuffer, long l) throws IOException {
        return this.openCryptoFile.write(this.options, byteBuffer, l);
    }

    private int internalRead(ByteBuffer byteBuffer, long l) throws IOException {
        return this.openCryptoFile.read(byteBuffer, l);
    }

    @Override
    public long size() throws ClosedChannelException {
        this.assertOpen();
        return this.openCryptoFile.size();
    }

    @Override
    public synchronized FileChannel truncate(long l) throws IOException {
        this.assertOpen();
        this.assertWritable();
        this.openCryptoFile.truncate(l);
        this.position = Math.min(l, this.position);
        return this;
    }

    @Override
    public void force(boolean bl) throws IOException {
        this.assertOpen();
        this.openCryptoFile.force(bl, this.options);
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mapMode, long l, long l2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock lock(long l, long l2, boolean bl) throws IOException {
        this.assertOpen();
        return this.blockingIo(() -> {
            FileLock fileLock = this.openCryptoFile.lock(l, l2, bl);
            CryptoFileLock cryptoFileLock = CryptoFileLock.builder().withDelegate(fileLock).withChannel(this).withPosition(l).withSize(l2).thatIsShared(bl).build();
            return cryptoFileLock;
        });
    }

    @Override
    public FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        this.assertOpen();
        FileLock fileLock = this.openCryptoFile.tryLock(l, l2, bl);
        if (fileLock == null) {
            return null;
        }
        CryptoFileLock cryptoFileLock = CryptoFileLock.builder().withDelegate(fileLock).withChannel(this).withPosition(l).withSize(l2).thatIsShared(bl).build();
        return cryptoFileLock;
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.finallyUtil.guaranteeInvocationOf(() -> this.onClose.accept(this), () -> this.openCryptoFile.close(this.options));
    }

    private void assertWritable() throws IOException {
        if (!this.options.writable()) {
            throw new IOException("Channel not writable");
        }
    }

    private void assertReadable() throws IOException {
        if (!this.options.readable()) {
            throw new IOException("Channel not readable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T blockingIo(SupplierThrowingException<T, IOException> supplierThrowingException) throws IOException {
        boolean bl = false;
        try {
            this.begin();
            T t = supplierThrowingException.get();
            bl = true;
            T t2 = t;
            return t2;
        }
        finally {
            this.end(bl);
        }
    }

    private void assertOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }
}

